/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.internal.android.JsonUtils;
import io.realm.internal.network.AuthServerResponse;
import io.realm.log.RealmLog;
import io.realm.permissions.AccessLevel;
import io.realm.permissions.PermissionOffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetPermissionsOffersResponse
extends AuthServerResponse {
    private final List<PermissionOffer> offers = new ArrayList<PermissionOffer>();

    static GetPermissionsOffersResponse from(Response response) {
        String serverResponse;
        try {
            serverResponse = response.body().string();
        }
        catch (IOException e) {
            ObjectServerError error = new ObjectServerError(ErrorCode.IO_EXCEPTION, (Throwable)e);
            return new GetPermissionsOffersResponse(error);
        }
        if (!response.isSuccessful()) {
            return new GetPermissionsOffersResponse(AuthServerResponse.createError(serverResponse, response.code()));
        }
        return new GetPermissionsOffersResponse(serverResponse);
    }

    public static GetPermissionsOffersResponse from(ObjectServerError objectServerError) {
        return new GetPermissionsOffersResponse(objectServerError);
    }

    public static GetPermissionsOffersResponse from(Exception exception) {
        return GetPermissionsOffersResponse.from(new ObjectServerError(ErrorCode.fromException(exception), (Throwable)exception));
    }

    private GetPermissionsOffersResponse(ObjectServerError error) {
        RealmLog.debug("GetPermissionOffers - Error: %s", error);
        this.setError(error);
        this.error = error;
    }

    private GetPermissionsOffersResponse(String serverResponse) {
        RealmLog.debug("GetPermissionOffers - Success: %s", serverResponse);
        try {
            JSONObject responseObject = new JSONObject(serverResponse);
            JSONArray responseOffersList = responseObject.getJSONArray("offers");
            for (int i = 0; i < responseOffersList.length(); ++i) {
                JSONObject obj = responseOffersList.getJSONObject(i);
                String path = obj.getString("realmPath");
                Date expiresAt = obj.isNull("expiresAt") ? null : JsonUtils.stringToDate(obj.getString("expiresAt"));
                AccessLevel accessLevel = AccessLevel.fromKey(obj.getString("accessLevel"));
                Date createdAt = JsonUtils.stringToDate(obj.getString("createdAt"));
                String userId = obj.getString("userId");
                String token = obj.getString("token");
                this.offers.add(new PermissionOffer(path, accessLevel, expiresAt, createdAt, userId, token));
            }
        }
        catch (JSONException e) {
            this.error = new ObjectServerError(ErrorCode.JSON_EXCEPTION, (Throwable)e);
        }
    }

    public List<PermissionOffer> getOffers() {
        return this.offers;
    }
}

