/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.internal.network.AuthServerResponse;
import io.realm.log.RealmLog;
import java.io.IOException;
import okhttp3.Response;

public class InvalidatePermissionsOfferResponse
extends AuthServerResponse {
    static InvalidatePermissionsOfferResponse from(Response response) {
        String serverResponse;
        try {
            serverResponse = response.body().string();
        }
        catch (IOException e) {
            ObjectServerError error = new ObjectServerError(ErrorCode.IO_EXCEPTION, (Throwable)e);
            return new InvalidatePermissionsOfferResponse(error);
        }
        if (!response.isSuccessful()) {
            return new InvalidatePermissionsOfferResponse(AuthServerResponse.createError(serverResponse, response.code()));
        }
        return new InvalidatePermissionsOfferResponse(serverResponse);
    }

    public static InvalidatePermissionsOfferResponse from(ObjectServerError objectServerError) {
        return new InvalidatePermissionsOfferResponse(objectServerError);
    }

    public static InvalidatePermissionsOfferResponse from(Exception exception) {
        return InvalidatePermissionsOfferResponse.from(new ObjectServerError(ErrorCode.fromException(exception), (Throwable)exception));
    }

    private InvalidatePermissionsOfferResponse(ObjectServerError error) {
        RealmLog.debug("InvalidatePermissionOffer - Error: %s", error);
        this.setError(error);
        this.error = error;
    }

    private InvalidatePermissionsOfferResponse(String serverResponse) {
        RealmLog.debug("InvalidatePermissionOffer - Success: %s", serverResponse);
    }
}

