/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.internal.network.AuthServerResponse;
import io.realm.log.RealmLog;
import java.io.IOException;
import okhttp3.Response;

public class LogoutResponse
extends AuthServerResponse {
    static LogoutResponse from(Response response) {
        if (response.isSuccessful()) {
            return new LogoutResponse();
        }
        try {
            String serverResponse = response.body().string();
            return new LogoutResponse(AuthServerResponse.createError(serverResponse, response.code()));
        }
        catch (IOException e) {
            ObjectServerError error = new ObjectServerError(ErrorCode.IO_EXCEPTION, (Throwable)e);
            return new LogoutResponse(error);
        }
    }

    public static LogoutResponse from(ObjectServerError error) {
        return new LogoutResponse(error);
    }

    public static LogoutResponse from(Exception exception) {
        return LogoutResponse.from(new ObjectServerError(ErrorCode.fromException(exception), (Throwable)exception));
    }

    private LogoutResponse(ObjectServerError error) {
        RealmLog.debug("Logout response - Error: " + error.getErrorMessage(), new Object[0]);
        this.setError(error);
    }

    private LogoutResponse() {
        RealmLog.debug("Logout response - Success", new Object[0]);
        this.setError(null);
    }

    @Override
    public boolean isValid() {
        return this.error == null || this.error.getErrorCode() == ErrorCode.EXPIRED_REFRESH_TOKEN;
    }
}

