/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.internal.android.JsonUtils;
import io.realm.internal.network.AuthServerResponse;
import io.realm.internal.permissions.PermissionOfferResponse;
import io.realm.log.RealmLog;
import io.realm.permissions.AccessLevel;
import java.io.IOException;
import java.util.Date;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class MakePermissionsOfferResponse
extends AuthServerResponse {
    private PermissionOfferResponse response;

    static MakePermissionsOfferResponse from(Response response) {
        String serverResponse;
        try {
            serverResponse = response.body().string();
        }
        catch (IOException e) {
            ObjectServerError error = new ObjectServerError(ErrorCode.IO_EXCEPTION, (Throwable)e);
            return new MakePermissionsOfferResponse(error);
        }
        if (!response.isSuccessful()) {
            return new MakePermissionsOfferResponse(AuthServerResponse.createError(serverResponse, response.code()));
        }
        return new MakePermissionsOfferResponse(serverResponse);
    }

    public static MakePermissionsOfferResponse from(ObjectServerError objectServerError) {
        return new MakePermissionsOfferResponse(objectServerError);
    }

    public static MakePermissionsOfferResponse from(Exception exception) {
        return MakePermissionsOfferResponse.from(new ObjectServerError(ErrorCode.fromException(exception), (Throwable)exception));
    }

    private MakePermissionsOfferResponse(ObjectServerError error) {
        RealmLog.debug("MakePermissionsOffer - Error: %s", error);
        this.setError(error);
        this.error = error;
    }

    private MakePermissionsOfferResponse(String serverResponse) {
        RealmLog.debug("MakePermissionsOffer - Success: %s", serverResponse);
        try {
            JSONObject obj = new JSONObject(serverResponse);
            String path = obj.getString("realmPath");
            Date expiresAt = obj.isNull("expiresAt") ? null : JsonUtils.stringToDate(obj.getString("expiresAt"));
            AccessLevel accessLevel = AccessLevel.fromKey(obj.getString("accessLevel"));
            Date createdAt = JsonUtils.stringToDate(obj.getString("createdAt"));
            String userId = obj.getString("userId");
            String token = obj.getString("token");
            this.response = new PermissionOfferResponse(path, expiresAt, accessLevel, createdAt, userId, token);
        }
        catch (JSONException e) {
            this.error = new ObjectServerError(ErrorCode.JSON_EXCEPTION, (Throwable)e);
        }
    }

    public String getToken() {
        return this.response.getToken();
    }
}

