/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.SyncCredentials;
import io.realm.internal.Util;
import io.realm.internal.network.AcceptPermissionsOfferResponse;
import io.realm.internal.network.ApplyPermissionsRequest;
import io.realm.internal.network.ApplyPermissionsResponse;
import io.realm.internal.network.AuthenticateRequest;
import io.realm.internal.network.AuthenticateResponse;
import io.realm.internal.network.ChangePasswordRequest;
import io.realm.internal.network.ChangePasswordResponse;
import io.realm.internal.network.GetPermissionsOffersResponse;
import io.realm.internal.network.InvalidatePermissionsOfferResponse;
import io.realm.internal.network.LogoutRequest;
import io.realm.internal.network.LogoutResponse;
import io.realm.internal.network.LookupUserIdResponse;
import io.realm.internal.network.MakePermissionsOfferRequest;
import io.realm.internal.network.MakePermissionsOfferResponse;
import io.realm.internal.network.RealmObjectServer;
import io.realm.internal.network.RetrievePermissionsResponse;
import io.realm.internal.network.UpdateAccountRequest;
import io.realm.internal.network.UpdateAccountResponse;
import io.realm.internal.objectserver.Token;
import io.realm.log.RealmLog;
import io.realm.permissions.PermissionOffer;
import io.realm.permissions.PermissionRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class OkHttpRealmObjectServer
implements RealmObjectServer {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String ACTION_LOGOUT = "revoke";
    private static final String ACTION_CHANGE_PASSWORD = "password";
    private static final String ACTION_LOOKUP_USER_ID = "users/:provider:/:providerId:";
    private static final String ACTION_UPDATE_ACCOUNT = "password/updateAccount";
    private static final String ACTION_GET_PERMISSIONS = "permissions";
    private static final String ACTION_UPDATE_PERMISSIONS = "permissions/apply";
    private static final String ACTION_OFFER_PERMISSIONS = "permissions/offers";
    private static final String ACTION_ACCEPT_PERMISSIONS_OFFER = "permissions/offers/:token:/accept";
    private static final String ACTION_DELETE_PERMISSIONS_OFFER = "permissions/offers/:token:";
    private static final String ACTION_GET_PERMISSION_OFFERS = "permissions/offers";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).followRedirects(true).addInterceptor(new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            if (RealmLog.getLevel() <= 2) {
                StringBuilder sb = new StringBuilder(request.method());
                sb.append(' ');
                sb.append(request.url());
                sb.append('\n');
                sb.append(request.headers());
                if (request.body() != null) {
                    Buffer buffer = new Buffer();
                    request.body().writeTo((BufferedSink)buffer);
                    sb.append(buffer.readString(UTF8));
                }
                RealmLog.trace("HTTP Request = \n%s", sb);
            }
            return chain.proceed(request);
        }
    }).connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).build();
    private Map<String, Map<String, String>> customHeaders = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, String> customAuthorizationHeaders = new HashMap<String, String>();

    public OkHttpRealmObjectServer() {
        this.initHeaders();
    }

    private void initHeaders() {
        this.customAuthorizationHeaders.put("", "Authorization");
        this.customHeaders.put("", new LinkedHashMap());
    }

    @Override
    public void setAuthorizationHeaderName(String headerName, @Nullable String host) {
        if (Util.isEmptyString(host)) {
            this.customAuthorizationHeaders.put("", headerName);
        } else {
            this.customAuthorizationHeaders.put(host, headerName);
        }
    }

    @Override
    public void addHeader(String headerName, String headerValue, @Nullable String host) {
        if (Util.isEmptyString(host)) {
            this.customHeaders.get("").put(headerName, headerValue);
        } else {
            Map<String, String> headers = this.customHeaders.get(host);
            if (headers == null) {
                headers = new LinkedHashMap<String, String>();
                this.customHeaders.put(host, headers);
            }
            headers.put(headerName, headerValue);
        }
    }

    @Override
    public void clearCustomHeaderSettings() {
        this.customAuthorizationHeaders.clear();
        this.customHeaders.clear();
        this.initHeaders();
    }

    @Override
    public AuthenticateResponse loginUser(SyncCredentials credentials, URL authenticationUrl) {
        try {
            String requestBody = AuthenticateRequest.userLogin(credentials).toJson();
            return this.authenticate(authenticationUrl, requestBody);
        }
        catch (Exception e) {
            return AuthenticateResponse.from(e);
        }
    }

    @Override
    public AuthenticateResponse loginToRealm(Token refreshToken, URI serverUrl, URL authenticationUrl) {
        try {
            String requestBody = AuthenticateRequest.realmLogin(refreshToken, serverUrl.getPath()).toJson();
            return this.authenticate(authenticationUrl, requestBody);
        }
        catch (Exception e) {
            return AuthenticateResponse.from(e);
        }
    }

    @Override
    public AuthenticateResponse refreshUser(Token userToken, URI serverUrl, URL authenticationUrl) {
        try {
            String requestBody = AuthenticateRequest.userRefresh(userToken, serverUrl.getPath()).toJson();
            return this.authenticate(authenticationUrl, requestBody);
        }
        catch (Exception e) {
            return AuthenticateResponse.from(e);
        }
    }

    @Override
    public LogoutResponse logout(Token userToken, URL authenticationUrl) {
        try {
            String requestBody = LogoutRequest.create(userToken).toJson();
            return this.logout(OkHttpRealmObjectServer.buildActionUrl(authenticationUrl, ACTION_LOGOUT), userToken.value(), requestBody);
        }
        catch (Exception e) {
            return LogoutResponse.from(e);
        }
    }

    @Override
    public ChangePasswordResponse changePassword(Token userToken, String newPassword, URL authenticationUrl) {
        try {
            String requestBody = ChangePasswordRequest.create(userToken, newPassword).toJson();
            return this.changePassword(OkHttpRealmObjectServer.buildActionUrl(authenticationUrl, ACTION_CHANGE_PASSWORD), userToken.value(), requestBody);
        }
        catch (Exception e) {
            return ChangePasswordResponse.from(e);
        }
    }

    @Override
    public ChangePasswordResponse changePassword(Token adminToken, String userId, String newPassword, URL authenticationUrl) {
        try {
            String requestBody = ChangePasswordRequest.create(adminToken, userId, newPassword).toJson();
            return this.changePassword(OkHttpRealmObjectServer.buildActionUrl(authenticationUrl, ACTION_CHANGE_PASSWORD), adminToken.value(), requestBody);
        }
        catch (Exception e) {
            return ChangePasswordResponse.from(e);
        }
    }

    @Override
    public LookupUserIdResponse retrieveUser(Token adminToken, String provider, String providerId, URL authenticationUrl) {
        try {
            String action = ACTION_LOOKUP_USER_ID.replace(":provider:", provider).replace(":providerId:", providerId);
            return this.lookupUserId(OkHttpRealmObjectServer.buildActionUrl(authenticationUrl, action), adminToken.value());
        }
        catch (Exception e) {
            return LookupUserIdResponse.from(e);
        }
    }

    @Override
    public UpdateAccountResponse requestPasswordReset(String email, URL authenticationUrl) {
        try {
            String requestBody = UpdateAccountRequest.requestPasswordReset(email).toJson();
            return this.updateAccount(OkHttpRealmObjectServer.buildActionUrl(authenticationUrl, ACTION_UPDATE_ACCOUNT), requestBody);
        }
        catch (Exception e) {
            return UpdateAccountResponse.from(e);
        }
    }

    @Override
    public UpdateAccountResponse completePasswordReset(String token, String newPassword, URL authenticationUrl) {
        try {
            String requestBody = UpdateAccountRequest.completePasswordReset(token, newPassword).toJson();
            return this.updateAccount(OkHttpRealmObjectServer.buildActionUrl(authenticationUrl, ACTION_UPDATE_ACCOUNT), requestBody);
        }
        catch (Exception e) {
            return UpdateAccountResponse.from(e);
        }
    }

    @Override
    public UpdateAccountResponse requestEmailConfirmation(String email, URL authenticationUrl) {
        try {
            String requestBody = UpdateAccountRequest.requestEmailConfirmation(email).toJson();
            return this.updateAccount(OkHttpRealmObjectServer.buildActionUrl(authenticationUrl, ACTION_UPDATE_ACCOUNT), requestBody);
        }
        catch (Exception e) {
            return UpdateAccountResponse.from(e);
        }
    }

    @Override
    public UpdateAccountResponse confirmEmail(String confirmationToken, URL authenticationUrl) {
        try {
            String requestBody = UpdateAccountRequest.completeEmailConfirmation(confirmationToken).toJson();
            return this.updateAccount(OkHttpRealmObjectServer.buildActionUrl(authenticationUrl, ACTION_UPDATE_ACCOUNT), requestBody);
        }
        catch (Exception e) {
            return UpdateAccountResponse.from(e);
        }
    }

    @Override
    public RetrievePermissionsResponse getPermissions(Token userToken, URL baseUrl) {
        try {
            URL url = OkHttpRealmObjectServer.buildActionUrl(baseUrl, ACTION_GET_PERMISSIONS);
            RealmLog.debug("Network request (retrieveGrantedPermissions): " + url, new Object[0]);
            Request request = this.newAuthRequest(url, userToken.value()).get().build();
            Call call = this.client.newCall(request);
            Response response = call.execute();
            return RetrievePermissionsResponse.from(response);
        }
        catch (Exception e) {
            return RetrievePermissionsResponse.from(e);
        }
    }

    @Override
    public ApplyPermissionsResponse applyPermissions(PermissionRequest permissionRequest, Token refreshToken, URL baseUrl) {
        try {
            URL url = OkHttpRealmObjectServer.buildActionUrl(baseUrl, ACTION_UPDATE_PERMISSIONS);
            RealmLog.debug("Network request (applyPermissions): " + url, new Object[0]);
            Request request = this.newAuthRequest(url, refreshToken.value()).post(RequestBody.create((MediaType)JSON, (String)new ApplyPermissionsRequest(permissionRequest).toJson())).build();
            Call call = this.client.newCall(request);
            Response response = call.execute();
            return ApplyPermissionsResponse.from(response);
        }
        catch (Exception e) {
            return ApplyPermissionsResponse.from(e);
        }
    }

    @Override
    public MakePermissionsOfferResponse makeOffer(PermissionOffer offer, Token refreshToken, URL baseUrl) {
        try {
            URL url = OkHttpRealmObjectServer.buildActionUrl(baseUrl, "permissions/offers");
            RealmLog.debug("Network request (offerPermissions): " + url, new Object[0]);
            Request request = this.newAuthRequest(url, refreshToken.value()).post(RequestBody.create((MediaType)JSON, (String)new MakePermissionsOfferRequest(offer).toJson())).build();
            Call call = this.client.newCall(request);
            Response response = call.execute();
            return MakePermissionsOfferResponse.from(response);
        }
        catch (Exception e) {
            return MakePermissionsOfferResponse.from(e);
        }
    }

    @Override
    public AcceptPermissionsOfferResponse acceptOffer(String offerToken, Token refreshToken, URL baseUrl) {
        try {
            String action = ACTION_ACCEPT_PERMISSIONS_OFFER.replace(":token:", offerToken);
            URL url = OkHttpRealmObjectServer.buildActionUrl(baseUrl, action);
            RealmLog.debug("Network request (acceptPermissionOffer): " + url, new Object[0]);
            Request request = this.newAuthRequest(url, refreshToken.value()).post(RequestBody.create((MediaType)JSON, (String)"")).build();
            Call call = this.client.newCall(request);
            Response response = call.execute();
            return AcceptPermissionsOfferResponse.from(response);
        }
        catch (Exception e) {
            return AcceptPermissionsOfferResponse.from(e);
        }
    }

    @Override
    public InvalidatePermissionsOfferResponse invalidateOffer(String offerToken, Token refreshToken, URL baseUrl) {
        try {
            String action = ACTION_DELETE_PERMISSIONS_OFFER.replace(":token:", offerToken);
            URL url = OkHttpRealmObjectServer.buildActionUrl(baseUrl, action);
            RealmLog.debug("Network request (invalidatePermissionOffer): " + url, new Object[0]);
            Request request = this.newAuthRequest(url, refreshToken.value()).delete().build();
            Call call = this.client.newCall(request);
            Response response = call.execute();
            return InvalidatePermissionsOfferResponse.from(response);
        }
        catch (Exception e) {
            return InvalidatePermissionsOfferResponse.from(e);
        }
    }

    @Override
    public GetPermissionsOffersResponse getPermissionOffers(Token refreshToken, URL baseUrl) {
        try {
            URL url = OkHttpRealmObjectServer.buildActionUrl(baseUrl, "permissions/offers");
            RealmLog.debug("Network request (GetPermissionsOffers): " + url, new Object[0]);
            Request request = this.newAuthRequest(url, refreshToken.value()).get().build();
            Call call = this.client.newCall(request);
            Response response = call.execute();
            return GetPermissionsOffersResponse.from(response);
        }
        catch (Exception e) {
            return GetPermissionsOffersResponse.from(e);
        }
    }

    private static URL buildActionUrl(URL authenticationUrl, String action) {
        String baseUrlString = authenticationUrl.toExternalForm();
        try {
            String separator = baseUrlString.endsWith("/") ? "" : "/";
            return new URL(baseUrlString + separator + action);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private AuthenticateResponse authenticate(URL authenticationUrl, String requestBody) throws Exception {
        RealmLog.debug("Network request (authenticate): " + authenticationUrl, new Object[0]);
        Request request = this.newAuthRequest(authenticationUrl).post(RequestBody.create((MediaType)JSON, (String)requestBody)).build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        return AuthenticateResponse.from(response);
    }

    private LogoutResponse logout(URL logoutUrl, String authToken, String requestBody) throws Exception {
        RealmLog.debug("Network request (logout): " + logoutUrl, new Object[0]);
        Request request = this.newAuthRequest(logoutUrl, authToken).post(RequestBody.create((MediaType)JSON, (String)requestBody)).build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        return LogoutResponse.from(response);
    }

    private ChangePasswordResponse changePassword(URL changePasswordUrl, String authToken, String requestBody) throws Exception {
        RealmLog.debug("Network request (changePassword): " + changePasswordUrl, new Object[0]);
        Request request = this.newAuthRequest(changePasswordUrl, authToken).put(RequestBody.create((MediaType)JSON, (String)requestBody)).build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        return ChangePasswordResponse.from(response);
    }

    private LookupUserIdResponse lookupUserId(URL lookupUserIdUrl, String authToken) throws Exception {
        RealmLog.debug("Network request (lookupUserId): " + lookupUserIdUrl, new Object[0]);
        Request request = this.newAuthRequest(lookupUserIdUrl, authToken).get().build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        return LookupUserIdResponse.from(response);
    }

    private UpdateAccountResponse updateAccount(URL updateAccountUrl, String requestBody) throws Exception {
        RealmLog.debug("Network request (updateAccount): " + updateAccountUrl, new Object[0]);
        Request request = this.newAuthRequest(updateAccountUrl).post(RequestBody.create((MediaType)JSON, (String)requestBody)).build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        return UpdateAccountResponse.from(response);
    }

    private Request.Builder newAuthRequest(URL url) {
        return this.newAuthRequest(url, null);
    }

    private Request.Builder newAuthRequest(URL url, String authToken) {
        Request.Builder builder = new Request.Builder().url(url).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        for (Map.Entry<String, String> entry : this.customHeaders.get("").entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        Map<String, String> customHeaders = this.customHeaders.get(url.getHost());
        if (customHeaders != null) {
            for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!Util.isEmptyString(authToken)) {
            String string = this.customAuthorizationHeaders.get(url.getHost());
            if (string != null) {
                builder.addHeader(string, authToken);
            } else {
                builder.addHeader(this.customAuthorizationHeaders.get(""), authToken);
            }
        }
        return builder;
    }
}

