/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.internal.android.JsonUtils;
import io.realm.internal.network.AuthServerResponse;
import io.realm.log.RealmLog;
import io.realm.permissions.AccessLevel;
import io.realm.permissions.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RetrievePermissionsResponse
extends AuthServerResponse {
    private final List<Permission> permissions = new ArrayList<Permission>();

    static RetrievePermissionsResponse from(Response response) {
        String serverResponse;
        try {
            serverResponse = response.body().string();
        }
        catch (IOException e) {
            ObjectServerError error = new ObjectServerError(ErrorCode.IO_EXCEPTION, (Throwable)e);
            return new RetrievePermissionsResponse(error);
        }
        if (!response.isSuccessful()) {
            return new RetrievePermissionsResponse(AuthServerResponse.createError(serverResponse, response.code()));
        }
        return new RetrievePermissionsResponse(serverResponse);
    }

    public static RetrievePermissionsResponse from(ObjectServerError objectServerError) {
        return new RetrievePermissionsResponse(objectServerError);
    }

    public static RetrievePermissionsResponse from(Exception exception) {
        return RetrievePermissionsResponse.from(new ObjectServerError(ErrorCode.fromException(exception), (Throwable)exception));
    }

    private RetrievePermissionsResponse(ObjectServerError error) {
        RealmLog.debug("LookupUserIdResponse - Error: %s", error);
        this.setError(error);
        this.error = error;
    }

    private RetrievePermissionsResponse(String serverResponse) {
        RealmLog.debug("RetrievePermissionsResponse - Success: %s", serverResponse);
        try {
            JSONObject obj = new JSONObject(serverResponse);
            JSONArray array = obj.getJSONArray("permissions");
            for (int i = 0; i < array.length(); ++i) {
                JSONObject permission = array.getJSONObject(i);
                String userId = permission.isNull("userId") ? null : permission.getString("userId");
                String path = permission.getString("path");
                AccessLevel accessLevel = AccessLevel.fromKey(permission.getString("accessLevel"));
                boolean mayRead = accessLevel.mayRead();
                boolean mayWrite = accessLevel.mayWrite();
                boolean mayManage = accessLevel.mayManage();
                Date updatedAt = JsonUtils.stringToDate(permission.getString("updatedAt"));
                this.permissions.add(new Permission(userId, path, accessLevel, mayRead, mayWrite, mayManage, updatedAt));
            }
        }
        catch (JSONException e) {
            this.error = new ObjectServerError(ErrorCode.JSON_EXCEPTION, (Throwable)e);
        }
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }
}

