/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.internal.Util;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class UpdateAccountRequest {
    private static final Map<String, String> NO_DATA = new HashMap<String, String>();
    private final String action;
    private final Map<String, String> data;
    private final String providerId;

    public static UpdateAccountRequest requestPasswordReset(String email) {
        return new UpdateAccountRequest("reset_password", NO_DATA, email);
    }

    public static UpdateAccountRequest completePasswordReset(String resetPasswordToken, String newPassword) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("token", resetPasswordToken);
        data.put("new_password", newPassword);
        return new UpdateAccountRequest("complete_reset", data, null);
    }

    public static UpdateAccountRequest requestEmailConfirmation(String email) {
        return new UpdateAccountRequest("request_email_confirmation", NO_DATA, email);
    }

    public static UpdateAccountRequest completeEmailConfirmation(String confirmEmailToken) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("token", confirmEmailToken);
        return new UpdateAccountRequest("confirm_email", data, null);
    }

    private UpdateAccountRequest(String action, Map<String, String> data, String providerId) {
        this.action = action;
        this.data = data;
        this.providerId = providerId;
    }

    public String toJson() {
        HashMap<String, Object> payload = new HashMap<String, Object>(){
            {
                if (!Util.isEmptyString(UpdateAccountRequest.this.providerId)) {
                    this.put("provider_id", UpdateAccountRequest.this.providerId);
                }
                UpdateAccountRequest.this.data.put("action", UpdateAccountRequest.this.action);
                this.put("data", UpdateAccountRequest.this.data);
            }
        };
        return new JSONObject((Map)payload).toString();
    }
}

