/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.objectserver;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Token {
    private static final String KEY_TOKEN = "token";
    private static final String KEY_TOKEN_DATA = "token_data";
    private static final String KEY_IDENTITY = "identity";
    private static final String KEY_PATH = "path";
    private static final String KEY_EXPIRES = "expires";
    private static final String KEY_ACCESS = "access";
    private static final String KEY_IS_ADMIN = "is_admin";
    private final String value;
    private final long expiresSec;
    private final Permission[] permissions;
    private final String identity;
    private final String path;
    private final boolean isAdmin;

    public static Token from(JSONObject token) throws JSONException {
        Permission[] permissions;
        String value = token.getString(KEY_TOKEN);
        JSONObject tokenData = token.getJSONObject(KEY_TOKEN_DATA);
        String identity = tokenData.getString(KEY_IDENTITY);
        String path = tokenData.optString(KEY_PATH);
        long expiresSec = tokenData.getLong(KEY_EXPIRES);
        JSONArray access = tokenData.getJSONArray(KEY_ACCESS);
        if (access != null) {
            permissions = new Permission[access.length()];
            for (int i = 0; i < access.length(); ++i) {
                try {
                    permissions[i] = Permission.valueOf(access.getString(i));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    permissions[i] = Permission.UNKNOWN;
                }
            }
        } else {
            permissions = new Permission[]{};
        }
        boolean isAdmin = tokenData.optBoolean(KEY_IS_ADMIN);
        return new Token(value, identity, path, expiresSec, permissions, isAdmin);
    }

    public Token(String value, String identity, String path, long expiresSec, Permission[] permissions) {
        this(value, identity, path, expiresSec, permissions, false);
    }

    public Token(String value, String identity, String path, long expiresSec, Permission[] permissions, boolean isAdmin) {
        this.value = value;
        this.identity = identity;
        this.path = path;
        this.expiresSec = expiresSec;
        this.permissions = permissions != null ? Arrays.copyOf(permissions, permissions.length) : new Permission[0];
        this.isAdmin = isAdmin;
    }

    public String value() {
        return this.value;
    }

    public String identity() {
        return this.identity;
    }

    public String path() {
        return this.path;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public long expiresSec() {
        return this.expiresSec;
    }

    public long expiresMs() {
        long expiresMs = this.expiresSec * 1000L;
        if (expiresMs < this.expiresSec) {
            return Long.MAX_VALUE;
        }
        return expiresMs;
    }

    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"})
    public Permission[] permissions() {
        return Arrays.copyOf(this.permissions, this.permissions.length);
    }

    public JSONObject toJson() {
        JSONObject obj = new JSONObject();
        try {
            obj.put(KEY_TOKEN, (Object)this.value);
            JSONObject tokenData = new JSONObject();
            tokenData.put(KEY_IDENTITY, (Object)this.identity);
            tokenData.put(KEY_PATH, (Object)this.path);
            tokenData.put(KEY_EXPIRES, this.expiresSec);
            JSONArray perms = new JSONArray();
            for (int i = 0; i < this.permissions.length; ++i) {
                perms.put((Object)this.permissions[i].toString().toLowerCase(Locale.US));
            }
            tokenData.put(KEY_ACCESS, (Object)perms);
            tokenData.put(KEY_IS_ADMIN, this.isAdmin);
            obj.put(KEY_TOKEN_DATA, (Object)tokenData);
            return obj;
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not convert Token to JSON.", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        if (this.expiresSec != token.expiresSec) {
            return false;
        }
        if (this.isAdmin != token.isAdmin) {
            return false;
        }
        if (!this.value.equals(token.value)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.permissions, (Object[])token.permissions)) {
            return false;
        }
        if (!this.identity.equals(token.identity)) {
            return false;
        }
        return this.path != null ? this.path.equals(token.path) : token.path == null;
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (int)(this.expiresSec ^ this.expiresSec >>> 32);
        result = 31 * result + Arrays.hashCode((Object[])this.permissions);
        result = 31 * result + this.identity.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.isAdmin ? 1 : 0);
        return result;
    }

    public static enum Permission {
        UNKNOWN,
        UPLOAD,
        DOWNLOAD,
        REFRESH,
        MANAGE;

        public static final Permission[] ALL;

        static {
            ALL = new Permission[]{UPLOAD, DOWNLOAD, REFRESH, MANAGE};
        }
    }
}

