/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.objectstore;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.internal.KeepMember;
import io.realm.internal.OsRealmConfig;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepMember
public class OsAsyncOpenTask {
    private final OsRealmConfig config;
    private long nativePtr;
    private final CountDownLatch taskComplete = new CountDownLatch(1);
    private final AtomicReference<String> error = new AtomicReference<Object>(null);

    public OsAsyncOpenTask(OsRealmConfig config) {
        this.config = config;
    }

    public void start(long timeOut, TimeUnit unit) throws InterruptedException {
        this.nativePtr = this.start(this.config.getNativePtr());
        try {
            this.taskComplete.await(timeOut, unit);
        }
        catch (InterruptedException e) {
            this.cancel(this.nativePtr);
            throw e;
        }
        String errorMessage = this.error.get();
        if (errorMessage != null) {
            throw new ObjectServerError(ErrorCode.UNKNOWN, errorMessage);
        }
    }

    @KeepMember
    private void notifyRealmReady() {
        this.error.set(null);
        this.taskComplete.countDown();
    }

    @KeepMember
    private void notifyError(String errorMessage) {
        this.error.set(errorMessage);
        this.taskComplete.countDown();
    }

    private native long start(long var1);

    private native void cancel(long var1);
}

