/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.objectstore;

import io.realm.ImportFlag;
import io.realm.MutableRealmInteger;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.internal.NativeContext;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import java.io.Closeable;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class OsObjectBuilder
implements Closeable {
    private final Table table;
    private final long sharedRealmPtr;
    private final long builderPtr;
    private final long tablePtr;
    private final NativeContext context;
    private static ItemCallback<? extends RealmModel> objectItemCallback = new ItemCallback<RealmModel>(){

        @Override
        public void handleItem(long listPtr, RealmModel item) {
            RealmObjectProxy proxyItem = (RealmObjectProxy)item;
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, ((UncheckedRow)proxyItem.realmGet$proxyState().getRow$realm()).getNativePtr());
        }
    };
    private static ItemCallback<String> stringItemCallback = new ItemCallback<String>(){

        @Override
        public void handleItem(long listPtr, String item) {
            OsObjectBuilder.nativeAddStringListItem(listPtr, item);
        }
    };
    private static ItemCallback<Byte> byteItemCallback = new ItemCallback<Byte>(){

        @Override
        public void handleItem(long listPtr, Byte item) {
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, item.longValue());
        }
    };
    private static ItemCallback<Short> shortItemCallback = new ItemCallback<Short>(){

        @Override
        public void handleItem(long listPtr, Short item) {
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, item.shortValue());
        }
    };
    private static ItemCallback<Integer> integerItemCallback = new ItemCallback<Integer>(){

        @Override
        public void handleItem(long listPtr, Integer item) {
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, item.intValue());
        }
    };
    private static ItemCallback<Long> longItemCallback = new ItemCallback<Long>(){

        @Override
        public void handleItem(long listPtr, Long item) {
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, item);
        }
    };
    private static ItemCallback<Boolean> booleanItemCallback = new ItemCallback<Boolean>(){

        @Override
        public void handleItem(long listPtr, Boolean item) {
            OsObjectBuilder.nativeAddBooleanListItem(listPtr, item);
        }
    };
    private static ItemCallback<Float> floatItemCallback = new ItemCallback<Float>(){

        @Override
        public void handleItem(long listPtr, Float item) {
            OsObjectBuilder.nativeAddFloatListItem(listPtr, item.floatValue());
        }
    };
    private static ItemCallback<Double> doubleItemCallback = new ItemCallback<Double>(){

        @Override
        public void handleItem(long listPtr, Double item) {
            OsObjectBuilder.nativeAddDoubleListItem(listPtr, item);
        }
    };
    private static ItemCallback<Date> dateItemCallback = new ItemCallback<Date>(){

        @Override
        public void handleItem(long listPtr, Date item) {
            OsObjectBuilder.nativeAddDateListItem(listPtr, item.getTime());
        }
    };
    private static ItemCallback<byte[]> byteArrayItemCallback = new ItemCallback<byte[]>(){

        @Override
        public void handleItem(long listPtr, byte[] item) {
            OsObjectBuilder.nativeAddByteArrayListItem(listPtr, item);
        }
    };
    private static ItemCallback<MutableRealmInteger> mutableRealmIntegerItemCallback = new ItemCallback<MutableRealmInteger>(){

        @Override
        public void handleItem(long listPtr, MutableRealmInteger item) {
            Long value = item.get();
            if (value == null) {
                OsObjectBuilder.nativeAddNullListItem(listPtr);
            } else {
                OsObjectBuilder.nativeAddIntegerListItem(listPtr, value);
            }
        }
    };
    private final boolean ignoreFieldsWithSameValue;

    public OsObjectBuilder(Table table, long maxColumnIndex, Set<ImportFlag> flags) {
        OsSharedRealm sharedRealm = table.getSharedRealm();
        this.sharedRealmPtr = sharedRealm.getNativePtr();
        this.table = table;
        this.tablePtr = table.getNativePtr();
        this.builderPtr = OsObjectBuilder.nativeCreateBuilder(maxColumnIndex + 1L);
        this.context = sharedRealm.context;
        this.ignoreFieldsWithSameValue = flags.contains((Object)ImportFlag.CHECK_SAME_VALUES_BEFORE_SET);
    }

    public void addInteger(long columnIndex, Byte val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnIndex, val.byteValue());
        }
    }

    public void addInteger(long columnIndex, Short val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnIndex, val.shortValue());
        }
    }

    public void addInteger(long columnIndex, Integer val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnIndex, val.intValue());
        }
    }

    public void addInteger(long columnIndex, Long val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnIndex, val);
        }
    }

    public void addMutableRealmInteger(long columnIndex, MutableRealmInteger val) {
        if (val == null || val.get() == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnIndex, val.get());
        }
    }

    public void addString(long columnIndex, String val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddString(this.builderPtr, columnIndex, val);
        }
    }

    public void addFloat(long columnIndex, Float val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddFloat(this.builderPtr, columnIndex, val.floatValue());
        }
    }

    public void addDouble(long columnIndex, Double val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddDouble(this.builderPtr, columnIndex, val);
        }
    }

    public void addBoolean(long columnIndex, Boolean val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddBoolean(this.builderPtr, columnIndex, val);
        }
    }

    public void addDate(long columnIndex, Date val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddDate(this.builderPtr, columnIndex, val.getTime());
        }
    }

    public void addByteArray(long columnIndex, byte[] val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            OsObjectBuilder.nativeAddByteArray(this.builderPtr, columnIndex, val);
        }
    }

    public void addNull(long columnIndex) {
        OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
    }

    public void addObject(long columnIndex, RealmModel val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnIndex);
        } else {
            RealmObjectProxy proxy = (RealmObjectProxy)val;
            UncheckedRow row = (UncheckedRow)proxy.realmGet$proxyState().getRow$realm();
            OsObjectBuilder.nativeAddObject(this.builderPtr, columnIndex, row.getNativePtr());
        }
    }

    private <T> void addListItem(long builderPtr, long columnIndex, List<T> list, ItemCallback<T> itemCallback) {
        if (list != null) {
            long listPtr = OsObjectBuilder.nativeStartList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                T item = list.get(i);
                if (item == null) {
                    OsObjectBuilder.nativeAddNullListItem(listPtr);
                    continue;
                }
                itemCallback.handleItem(listPtr, item);
            }
            OsObjectBuilder.nativeStopList(builderPtr, columnIndex, listPtr);
        } else {
            this.addEmptyList(columnIndex);
        }
    }

    public <T extends RealmModel> void addObjectList(long columnIndex, RealmList<T> list) {
        if (list != null) {
            long[] rowPointers = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                RealmObjectProxy item = (RealmObjectProxy)list.get(i);
                if (item == null) {
                    throw new IllegalArgumentException("Null values are not allowed in RealmLists containing Realm models");
                }
                rowPointers[i] = ((UncheckedRow)item.realmGet$proxyState().getRow$realm()).getNativePtr();
            }
            OsObjectBuilder.nativeAddObjectList(this.builderPtr, columnIndex, rowPointers);
        } else {
            OsObjectBuilder.nativeAddObjectList(this.builderPtr, columnIndex, new long[0]);
        }
    }

    public void addStringList(long columnIndex, RealmList<String> list) {
        this.addListItem(this.builderPtr, columnIndex, list, stringItemCallback);
    }

    public void addByteList(long columnIndex, RealmList<Byte> list) {
        this.addListItem(this.builderPtr, columnIndex, list, byteItemCallback);
    }

    public void addShortList(long columnIndex, RealmList<Short> list) {
        this.addListItem(this.builderPtr, columnIndex, list, shortItemCallback);
    }

    public void addIntegerList(long columnIndex, RealmList<Integer> list) {
        this.addListItem(this.builderPtr, columnIndex, list, integerItemCallback);
    }

    public void addLongList(long columnIndex, RealmList<Long> list) {
        this.addListItem(this.builderPtr, columnIndex, list, longItemCallback);
    }

    public void addBooleanList(long columnIndex, RealmList<Boolean> list) {
        this.addListItem(this.builderPtr, columnIndex, list, booleanItemCallback);
    }

    public void addFloatList(long columnIndex, RealmList<Float> list) {
        this.addListItem(this.builderPtr, columnIndex, list, floatItemCallback);
    }

    public void addDoubleList(long columnIndex, RealmList<Double> list) {
        this.addListItem(this.builderPtr, columnIndex, list, doubleItemCallback);
    }

    public void addDateList(long columnIndex, RealmList<Date> list) {
        this.addListItem(this.builderPtr, columnIndex, list, dateItemCallback);
    }

    public void addByteArrayList(long columnIndex, RealmList<byte[]> list) {
        this.addListItem(this.builderPtr, columnIndex, list, byteArrayItemCallback);
    }

    public void addMutableRealmIntegerList(long columnIndex, RealmList<MutableRealmInteger> list) {
        this.addListItem(this.builderPtr, columnIndex, list, mutableRealmIntegerItemCallback);
    }

    private void addEmptyList(long columnIndex) {
        long listPtr = OsObjectBuilder.nativeStartList(0L);
        OsObjectBuilder.nativeStopList(this.builderPtr, columnIndex, listPtr);
    }

    public void updateExistingObject() {
        try {
            OsObjectBuilder.nativeCreateOrUpdate(this.sharedRealmPtr, this.tablePtr, this.builderPtr, true, this.ignoreFieldsWithSameValue);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UncheckedRow createNewObject() {
        UncheckedRow row;
        try {
            long rowPtr = OsObjectBuilder.nativeCreateOrUpdate(this.sharedRealmPtr, this.tablePtr, this.builderPtr, false, false);
            row = new UncheckedRow(this.context, this.table, rowPtr);
        }
        finally {
            this.close();
        }
        return row;
    }

    public long getNativePtr() {
        return this.builderPtr;
    }

    @Override
    public void close() {
        OsObjectBuilder.nativeDestroyBuilder(this.builderPtr);
    }

    private static native long nativeCreateBuilder(long var0);

    private static native void nativeDestroyBuilder(long var0);

    private static native long nativeCreateOrUpdate(long var0, long var2, long var4, boolean var6, boolean var7);

    private static native void nativeAddNull(long var0, long var2);

    private static native void nativeAddInteger(long var0, long var2, long var4);

    private static native void nativeAddString(long var0, long var2, String var4);

    private static native void nativeAddFloat(long var0, long var2, float var4);

    private static native void nativeAddDouble(long var0, long var2, double var4);

    private static native void nativeAddBoolean(long var0, long var2, boolean var4);

    private static native void nativeAddByteArray(long var0, long var2, byte[] var4);

    private static native void nativeAddDate(long var0, long var2, long var4);

    private static native void nativeAddObject(long var0, long var2, long var4);

    private static native long nativeStartList(long var0);

    private static native void nativeStopList(long var0, long var2, long var4);

    private static native void nativeAddNullListItem(long var0);

    private static native void nativeAddIntegerListItem(long var0, long var2);

    private static native void nativeAddStringListItem(long var0, String var2);

    private static native void nativeAddFloatListItem(long var0, float var2);

    private static native void nativeAddDoubleListItem(long var0, double var2);

    private static native void nativeAddBooleanListItem(long var0, boolean var2);

    private static native void nativeAddByteArrayListItem(long var0, byte[] var2);

    private static native void nativeAddDateListItem(long var0, long var2);

    private static native void nativeAddObjectListItem(long var0, long var2);

    private static native void nativeAddObjectList(long var0, long var2, long[] var4);

    private static interface ItemCallback<T> {
        public void handleItem(long var1, T var3);
    }
}

