/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.permissions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.permissions.AccessLevel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PermissionOfferResponse {
    @Nonnull
    private final String userId;
    @Nonnull
    private final Date createdAt;
    private final Date expiresAt;
    @Nonnull
    private final String token;
    @Nonnull
    private final String realmUrl;
    @Nonnull
    private final AccessLevel accessLevel;

    public PermissionOfferResponse(String path, Date expiresAt, AccessLevel accessLevel, Date createdAt, String userId, String token) {
        this.realmUrl = path;
        this.expiresAt = expiresAt != null ? (Date)expiresAt.clone() : null;
        this.accessLevel = accessLevel;
        this.createdAt = (Date)createdAt.clone();
        this.userId = userId;
        this.token = token;
    }

    public String getUserId() {
        return this.userId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getToken() {
        return this.token;
    }

    @Nullable
    public String getRealmUrl() {
        return this.realmUrl;
    }

    public String getPath() {
        try {
            return new URI(this.realmUrl).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

