/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.sync;

import io.realm.ImportFlag;
import io.realm.Realm;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.internal.annotations.ObjectServer;
import io.realm.sync.permissions.Permission;
import io.realm.sync.permissions.Role;

@ObjectServer
public class PermissionHelper {
    public static Permission findOrCreatePermissionForRole(RealmObject container, RealmList<Permission> permissions, String roleName) {
        if (!container.isManaged()) {
            throw new IllegalStateException("'findOrCreate()' can only be called on managed objects.");
        }
        Realm realm = container.getRealm();
        if (!realm.isInTransaction()) {
            throw new IllegalStateException("'findOrCreate()' can only be called inside a write transaction.");
        }
        Permission permission = permissions.where().equalTo("role.name", roleName).findFirst();
        if (permission == null) {
            Role role = realm.where(Role.class).equalTo("name", roleName).findFirst();
            if (role == null) {
                role = realm.createObject(Role.class, roleName);
            }
            permission = realm.copyToRealm(new Permission.Builder(role).noPrivileges().build(), new ImportFlag[0]);
            permissions.add(permission);
        }
        return permission;
    }
}

