/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.sync;

public class SubscriptionAction {
    public static final SubscriptionAction NO_SUBSCRIPTION = new SubscriptionAction(null, 0L, false);
    public static final SubscriptionAction ANONYMOUS_SUBSCRIPTION = new SubscriptionAction("", Long.MAX_VALUE, false);
    private final String subscriptionName;
    private final long timeToLiveMs;
    private final boolean update;

    public static SubscriptionAction create(String subscriptionName, long timeToLiveMs) {
        return new SubscriptionAction(subscriptionName, timeToLiveMs, false);
    }

    public static SubscriptionAction update(String subscriptionName, long timeToLiveMs) {
        return new SubscriptionAction(subscriptionName, timeToLiveMs, true);
    }

    public SubscriptionAction(String subscriptionName, long timeToLiveMs, boolean update) {
        this.subscriptionName = subscriptionName;
        this.timeToLiveMs = timeToLiveMs;
        this.update = update;
    }

    public boolean shouldCreateSubscriptions() {
        return this.subscriptionName != null;
    }

    public String getName() {
        return this.subscriptionName;
    }

    public long getTimeToLiveMs() {
        return this.timeToLiveMs;
    }

    public boolean isUpdate() {
        return this.update;
    }
}

