/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.util.JsonReader;
import android.util.JsonToken;
import io.realm.BaseRealm;
import io.realm.ImportFlag;
import io.realm.ProxyState;
import io.realm.Realm;
import io.realm.RealmFieldType;
import io.realm.RealmModel;
import io.realm.internal.ColumnInfo;
import io.realm.internal.OsObject;
import io.realm.internal.OsObjectSchemaInfo;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.android.JsonUtils;
import io.realm.internal.objectstore.OsObjectBuilder;
import io.realm.io_realm_sync_SubscriptionRealmProxyInterface;
import io.realm.sync.Subscription;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class io_realm_sync_SubscriptionRealmProxy
extends Subscription
implements RealmObjectProxy,
io_realm_sync_SubscriptionRealmProxyInterface {
    private static final OsObjectSchemaInfo expectedObjectSchemaInfo = io_realm_sync_SubscriptionRealmProxy.createExpectedObjectSchemaInfo();
    private SubscriptionColumnInfo columnInfo;
    private ProxyState<Subscription> proxyState;

    io_realm_sync_SubscriptionRealmProxy() {
        this.proxyState.setConstructionFinished();
    }

    @Override
    public void realm$injectObjectContext() {
        if (this.proxyState != null) {
            return;
        }
        BaseRealm.RealmObjectContext context = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
        this.columnInfo = (SubscriptionColumnInfo)context.getColumnInfo();
        this.proxyState = new ProxyState<io_realm_sync_SubscriptionRealmProxy>(this);
        this.proxyState.setRealm$realm(context.getRealm());
        this.proxyState.setRow$realm(context.getRow());
        this.proxyState.setAcceptDefaultValue$realm(context.getAcceptDefaultValue());
        this.proxyState.setExcludeFields$realm(context.getExcludeFields());
    }

    @Override
    public String realmGet$name() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.nameIndex);
    }

    @Override
    public void realmSet$name(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'name' to null.");
            }
            row.getTable().setString(this.columnInfo.nameIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            throw new IllegalArgumentException("Trying to set non-nullable field 'name' to null.");
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.nameIndex, value);
    }

    @Override
    public byte realmGet$status() {
        this.proxyState.getRealm$realm().checkIfValid();
        return (byte)this.proxyState.getRow$realm().getLong(this.columnInfo.statusIndex);
    }

    @Override
    public void realmSet$status(byte value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            row.getTable().setLong(this.columnInfo.statusIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        this.proxyState.getRow$realm().setLong(this.columnInfo.statusIndex, value);
    }

    @Override
    public String realmGet$errorMessage() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.errorMessageIndex);
    }

    @Override
    public void realmSet$errorMessage(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'errorMessage' to null.");
            }
            row.getTable().setString(this.columnInfo.errorMessageIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            throw new IllegalArgumentException("Trying to set non-nullable field 'errorMessage' to null.");
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.errorMessageIndex, value);
    }

    @Override
    public String realmGet$matchesProperty() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.matchesPropertyIndex);
    }

    @Override
    public void realmSet$matchesProperty(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'matchesProperty' to null.");
            }
            row.getTable().setString(this.columnInfo.matchesPropertyIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            throw new IllegalArgumentException("Trying to set non-nullable field 'matchesProperty' to null.");
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.matchesPropertyIndex, value);
    }

    @Override
    public String realmGet$query() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.queryIndex);
    }

    @Override
    public void realmSet$query(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'query' to null.");
            }
            row.getTable().setString(this.columnInfo.queryIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            throw new IllegalArgumentException("Trying to set non-nullable field 'query' to null.");
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.queryIndex, value);
    }

    @Override
    public int realmGet$queryParseCounter() {
        this.proxyState.getRealm$realm().checkIfValid();
        return (int)this.proxyState.getRow$realm().getLong(this.columnInfo.queryParseCounterIndex);
    }

    @Override
    public void realmSet$queryParseCounter(int value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            row.getTable().setLong(this.columnInfo.queryParseCounterIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        this.proxyState.getRow$realm().setLong(this.columnInfo.queryParseCounterIndex, value);
    }

    @Override
    public Date realmGet$createdAt() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getDate(this.columnInfo.createdAtIndex);
    }

    @Override
    public void realmSet$createdAt(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'createdAt' to null.");
            }
            row.getTable().setDate(this.columnInfo.createdAtIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            throw new IllegalArgumentException("Trying to set non-nullable field 'createdAt' to null.");
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.createdAtIndex, value);
    }

    @Override
    public Date realmGet$updatedAt() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getDate(this.columnInfo.updatedAtIndex);
    }

    @Override
    public void realmSet$updatedAt(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'updatedAt' to null.");
            }
            row.getTable().setDate(this.columnInfo.updatedAtIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            throw new IllegalArgumentException("Trying to set non-nullable field 'updatedAt' to null.");
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.updatedAtIndex, value);
    }

    @Override
    public Date realmGet$expiresAt() {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this.proxyState.getRow$realm().isNull(this.columnInfo.expiresAtIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(this.columnInfo.expiresAtIndex);
    }

    @Override
    public void realmSet$expiresAt(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.expiresAtIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setDate(this.columnInfo.expiresAtIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.expiresAtIndex);
            return;
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.expiresAtIndex, value);
    }

    @Override
    public Long realmGet$timeToLive() {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this.proxyState.getRow$realm().isNull(this.columnInfo.timeToLiveIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getLong(this.columnInfo.timeToLiveIndex);
    }

    @Override
    public void realmSet$timeToLive(Long value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.timeToLiveIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setLong(this.columnInfo.timeToLiveIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.timeToLiveIndex);
            return;
        }
        this.proxyState.getRow$realm().setLong(this.columnInfo.timeToLiveIndex, value);
    }

    private static OsObjectSchemaInfo createExpectedObjectSchemaInfo() {
        OsObjectSchemaInfo.Builder builder = new OsObjectSchemaInfo.Builder("__ResultSets", 10, 0);
        builder.addPersistedProperty("name", RealmFieldType.STRING, false, true, true);
        builder.addPersistedProperty("status", RealmFieldType.INTEGER, false, false, true);
        builder.addPersistedProperty("error_message", RealmFieldType.STRING, false, false, true);
        builder.addPersistedProperty("matches_property", RealmFieldType.STRING, false, false, true);
        builder.addPersistedProperty("query", RealmFieldType.STRING, false, false, true);
        builder.addPersistedProperty("query_parse_counter", RealmFieldType.INTEGER, false, false, true);
        builder.addPersistedProperty("created_at", RealmFieldType.DATE, false, false, true);
        builder.addPersistedProperty("updated_at", RealmFieldType.DATE, false, false, true);
        builder.addPersistedProperty("expires_at", RealmFieldType.DATE, false, false, false);
        builder.addPersistedProperty("time_to_live", RealmFieldType.INTEGER, false, false, false);
        return builder.build();
    }

    public static OsObjectSchemaInfo getExpectedObjectSchemaInfo() {
        return expectedObjectSchemaInfo;
    }

    public static SubscriptionColumnInfo createColumnInfo(OsSchemaInfo schemaInfo) {
        return new SubscriptionColumnInfo(schemaInfo);
    }

    public static String getSimpleClassName() {
        return "__ResultSets";
    }

    public static Subscription createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update) throws JSONException {
        Object timestamp;
        List<String> excludeFields = Collections.emptyList();
        Subscription obj = realm.createObjectInternal(Subscription.class, true, excludeFields);
        io_realm_sync_SubscriptionRealmProxyInterface objProxy = obj;
        if (json.has("name")) {
            if (json.isNull("name")) {
                objProxy.realmSet$name(null);
            } else {
                objProxy.realmSet$name(json.getString("name"));
            }
        }
        if (json.has("status")) {
            if (json.isNull("status")) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'status' to null.");
            }
            objProxy.realmSet$status((byte)json.getInt("status"));
        }
        if (json.has("errorMessage")) {
            if (json.isNull("errorMessage")) {
                objProxy.realmSet$errorMessage(null);
            } else {
                objProxy.realmSet$errorMessage(json.getString("errorMessage"));
            }
        }
        if (json.has("matchesProperty")) {
            if (json.isNull("matchesProperty")) {
                objProxy.realmSet$matchesProperty(null);
            } else {
                objProxy.realmSet$matchesProperty(json.getString("matchesProperty"));
            }
        }
        if (json.has("query")) {
            if (json.isNull("query")) {
                objProxy.realmSet$query(null);
            } else {
                objProxy.realmSet$query(json.getString("query"));
            }
        }
        if (json.has("queryParseCounter")) {
            if (json.isNull("queryParseCounter")) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'queryParseCounter' to null.");
            }
            objProxy.realmSet$queryParseCounter(json.getInt("queryParseCounter"));
        }
        if (json.has("createdAt")) {
            if (json.isNull("createdAt")) {
                objProxy.realmSet$createdAt(null);
            } else {
                timestamp = json.get("createdAt");
                if (timestamp instanceof String) {
                    objProxy.realmSet$createdAt(JsonUtils.stringToDate((String)timestamp));
                } else {
                    objProxy.realmSet$createdAt(new Date(json.getLong("createdAt")));
                }
            }
        }
        if (json.has("updatedAt")) {
            if (json.isNull("updatedAt")) {
                objProxy.realmSet$updatedAt(null);
            } else {
                timestamp = json.get("updatedAt");
                if (timestamp instanceof String) {
                    objProxy.realmSet$updatedAt(JsonUtils.stringToDate((String)timestamp));
                } else {
                    objProxy.realmSet$updatedAt(new Date(json.getLong("updatedAt")));
                }
            }
        }
        if (json.has("expiresAt")) {
            if (json.isNull("expiresAt")) {
                objProxy.realmSet$expiresAt(null);
            } else {
                timestamp = json.get("expiresAt");
                if (timestamp instanceof String) {
                    objProxy.realmSet$expiresAt(JsonUtils.stringToDate((String)timestamp));
                } else {
                    objProxy.realmSet$expiresAt(new Date(json.getLong("expiresAt")));
                }
            }
        }
        if (json.has("timeToLive")) {
            if (json.isNull("timeToLive")) {
                objProxy.realmSet$timeToLive(null);
            } else {
                objProxy.realmSet$timeToLive(json.getLong("timeToLive"));
            }
        }
        return obj;
    }

    @TargetApi(value=11)
    public static Subscription createUsingJsonStream(Realm realm, JsonReader reader) throws IOException {
        Subscription obj = new Subscription();
        io_realm_sync_SubscriptionRealmProxyInterface objProxy = obj;
        reader.beginObject();
        while (reader.hasNext()) {
            long timestamp;
            String name = reader.nextName();
            if (name.equals("name")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$name(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$name(null);
                continue;
            }
            if (name.equals("status")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$status((byte)reader.nextInt());
                    continue;
                }
                reader.skipValue();
                throw new IllegalArgumentException("Trying to set non-nullable field 'status' to null.");
            }
            if (name.equals("errorMessage")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$errorMessage(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$errorMessage(null);
                continue;
            }
            if (name.equals("matchesProperty")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$matchesProperty(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$matchesProperty(null);
                continue;
            }
            if (name.equals("query")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$query(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$query(null);
                continue;
            }
            if (name.equals("queryParseCounter")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$queryParseCounter(reader.nextInt());
                    continue;
                }
                reader.skipValue();
                throw new IllegalArgumentException("Trying to set non-nullable field 'queryParseCounter' to null.");
            }
            if (name.equals("createdAt")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$createdAt(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$createdAt(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$createdAt(JsonUtils.stringToDate(reader.nextString()));
                continue;
            }
            if (name.equals("updatedAt")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$updatedAt(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$updatedAt(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$updatedAt(JsonUtils.stringToDate(reader.nextString()));
                continue;
            }
            if (name.equals("expiresAt")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$expiresAt(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$expiresAt(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$expiresAt(JsonUtils.stringToDate(reader.nextString()));
                continue;
            }
            if (name.equals("timeToLive")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$timeToLive(reader.nextLong());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$timeToLive(null);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return realm.copyToRealm(obj, new ImportFlag[0]);
    }

    private static io_realm_sync_SubscriptionRealmProxy newProxyInstance(BaseRealm realm, Row row) {
        BaseRealm.RealmObjectContext objectContext = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
        objectContext.set(realm, row, realm.getSchema().getColumnInfo(Subscription.class), false, Collections.emptyList());
        io_realm_sync_SubscriptionRealmProxy obj = new io_realm_sync_SubscriptionRealmProxy();
        objectContext.clear();
        return obj;
    }

    public static Subscription copyOrUpdate(Realm realm, SubscriptionColumnInfo columnInfo, Subscription object, boolean update, Map<RealmModel, RealmObjectProxy> cache, Set<ImportFlag> flags) {
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm() != null) {
            BaseRealm otherRealm = ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm();
            if (otherRealm.threadId != realm.threadId) {
                throw new IllegalArgumentException("Objects which belong to Realm instances in other threads cannot be copied into this Realm instance.");
            }
            if (otherRealm.getPath().equals(realm.getPath())) {
                return object;
            }
        }
        BaseRealm.RealmObjectContext objectContext = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
        RealmObjectProxy cachedRealmObject = cache.get(object);
        if (cachedRealmObject != null) {
            return (Subscription)((Object)cachedRealmObject);
        }
        return io_realm_sync_SubscriptionRealmProxy.copy(realm, columnInfo, object, update, cache, flags);
    }

    public static Subscription copy(Realm realm, SubscriptionColumnInfo columnInfo, Subscription newObject, boolean update, Map<RealmModel, RealmObjectProxy> cache, Set<ImportFlag> flags) {
        RealmObjectProxy cachedRealmObject = cache.get(newObject);
        if (cachedRealmObject != null) {
            return (Subscription)((Object)cachedRealmObject);
        }
        io_realm_sync_SubscriptionRealmProxyInterface realmObjectSource = newObject;
        Table table = realm.getTable(Subscription.class);
        OsObjectBuilder builder = new OsObjectBuilder(table, columnInfo.maxColumnIndexValue, flags);
        builder.addString(columnInfo.nameIndex, realmObjectSource.realmGet$name());
        builder.addInteger(columnInfo.statusIndex, realmObjectSource.realmGet$status());
        builder.addString(columnInfo.errorMessageIndex, realmObjectSource.realmGet$errorMessage());
        builder.addString(columnInfo.matchesPropertyIndex, realmObjectSource.realmGet$matchesProperty());
        builder.addString(columnInfo.queryIndex, realmObjectSource.realmGet$query());
        builder.addInteger(columnInfo.queryParseCounterIndex, realmObjectSource.realmGet$queryParseCounter());
        builder.addDate(columnInfo.createdAtIndex, realmObjectSource.realmGet$createdAt());
        builder.addDate(columnInfo.updatedAtIndex, realmObjectSource.realmGet$updatedAt());
        builder.addDate(columnInfo.expiresAtIndex, realmObjectSource.realmGet$expiresAt());
        builder.addInteger(columnInfo.timeToLiveIndex, realmObjectSource.realmGet$timeToLive());
        UncheckedRow row = builder.createNewObject();
        io_realm_sync_SubscriptionRealmProxy realmObjectCopy = io_realm_sync_SubscriptionRealmProxy.newProxyInstance(realm, row);
        cache.put(newObject, realmObjectCopy);
        return realmObjectCopy;
    }

    public static long insert(Realm realm, Subscription object, Map<RealmModel, Long> cache) {
        Long realmGet$timeToLive;
        Date realmGet$expiresAt;
        Date realmGet$updatedAt;
        String realmGet$query;
        String realmGet$matchesProperty;
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
            return ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRow$realm().getIndex();
        }
        Table table = realm.getTable(Subscription.class);
        long tableNativePtr = table.getNativePtr();
        SubscriptionColumnInfo columnInfo = (SubscriptionColumnInfo)realm.getSchema().getColumnInfo(Subscription.class);
        long rowIndex = OsObject.createRow(table);
        cache.put(object, rowIndex);
        String realmGet$name = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$name();
        if (realmGet$name != null) {
            Table.nativeSetString(tableNativePtr, columnInfo.nameIndex, rowIndex, realmGet$name, false);
        }
        Table.nativeSetLong(tableNativePtr, columnInfo.statusIndex, rowIndex, ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$status(), false);
        String realmGet$errorMessage = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$errorMessage();
        if (realmGet$errorMessage != null) {
            Table.nativeSetString(tableNativePtr, columnInfo.errorMessageIndex, rowIndex, realmGet$errorMessage, false);
        }
        if ((realmGet$matchesProperty = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$matchesProperty()) != null) {
            Table.nativeSetString(tableNativePtr, columnInfo.matchesPropertyIndex, rowIndex, realmGet$matchesProperty, false);
        }
        if ((realmGet$query = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$query()) != null) {
            Table.nativeSetString(tableNativePtr, columnInfo.queryIndex, rowIndex, realmGet$query, false);
        }
        Table.nativeSetLong(tableNativePtr, columnInfo.queryParseCounterIndex, rowIndex, ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$queryParseCounter(), false);
        Date realmGet$createdAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$createdAt();
        if (realmGet$createdAt != null) {
            Table.nativeSetTimestamp(tableNativePtr, columnInfo.createdAtIndex, rowIndex, realmGet$createdAt.getTime(), false);
        }
        if ((realmGet$updatedAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$updatedAt()) != null) {
            Table.nativeSetTimestamp(tableNativePtr, columnInfo.updatedAtIndex, rowIndex, realmGet$updatedAt.getTime(), false);
        }
        if ((realmGet$expiresAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$expiresAt()) != null) {
            Table.nativeSetTimestamp(tableNativePtr, columnInfo.expiresAtIndex, rowIndex, realmGet$expiresAt.getTime(), false);
        }
        if ((realmGet$timeToLive = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$timeToLive()) != null) {
            Table.nativeSetLong(tableNativePtr, columnInfo.timeToLiveIndex, rowIndex, realmGet$timeToLive, false);
        }
        return rowIndex;
    }

    public static void insert(Realm realm, Iterator<? extends RealmModel> objects, Map<RealmModel, Long> cache) {
        Table table = realm.getTable(Subscription.class);
        long tableNativePtr = table.getNativePtr();
        SubscriptionColumnInfo columnInfo = (SubscriptionColumnInfo)realm.getSchema().getColumnInfo(Subscription.class);
        Subscription object = null;
        while (objects.hasNext()) {
            Long realmGet$timeToLive;
            Date realmGet$expiresAt;
            Date realmGet$updatedAt;
            String realmGet$query;
            String realmGet$matchesProperty;
            object = (Subscription)objects.next();
            if (cache.containsKey(object)) continue;
            if (object instanceof RealmObjectProxy && ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                cache.put(object, ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRow$realm().getIndex());
                continue;
            }
            long rowIndex = OsObject.createRow(table);
            cache.put(object, rowIndex);
            String realmGet$name = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$name();
            if (realmGet$name != null) {
                Table.nativeSetString(tableNativePtr, columnInfo.nameIndex, rowIndex, realmGet$name, false);
            }
            Table.nativeSetLong(tableNativePtr, columnInfo.statusIndex, rowIndex, ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$status(), false);
            String realmGet$errorMessage = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$errorMessage();
            if (realmGet$errorMessage != null) {
                Table.nativeSetString(tableNativePtr, columnInfo.errorMessageIndex, rowIndex, realmGet$errorMessage, false);
            }
            if ((realmGet$matchesProperty = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$matchesProperty()) != null) {
                Table.nativeSetString(tableNativePtr, columnInfo.matchesPropertyIndex, rowIndex, realmGet$matchesProperty, false);
            }
            if ((realmGet$query = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$query()) != null) {
                Table.nativeSetString(tableNativePtr, columnInfo.queryIndex, rowIndex, realmGet$query, false);
            }
            Table.nativeSetLong(tableNativePtr, columnInfo.queryParseCounterIndex, rowIndex, ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$queryParseCounter(), false);
            Date realmGet$createdAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$createdAt();
            if (realmGet$createdAt != null) {
                Table.nativeSetTimestamp(tableNativePtr, columnInfo.createdAtIndex, rowIndex, realmGet$createdAt.getTime(), false);
            }
            if ((realmGet$updatedAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$updatedAt()) != null) {
                Table.nativeSetTimestamp(tableNativePtr, columnInfo.updatedAtIndex, rowIndex, realmGet$updatedAt.getTime(), false);
            }
            if ((realmGet$expiresAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$expiresAt()) != null) {
                Table.nativeSetTimestamp(tableNativePtr, columnInfo.expiresAtIndex, rowIndex, realmGet$expiresAt.getTime(), false);
            }
            if ((realmGet$timeToLive = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$timeToLive()) == null) continue;
            Table.nativeSetLong(tableNativePtr, columnInfo.timeToLiveIndex, rowIndex, realmGet$timeToLive, false);
        }
    }

    public static long insertOrUpdate(Realm realm, Subscription object, Map<RealmModel, Long> cache) {
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
            return ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRow$realm().getIndex();
        }
        Table table = realm.getTable(Subscription.class);
        long tableNativePtr = table.getNativePtr();
        SubscriptionColumnInfo columnInfo = (SubscriptionColumnInfo)realm.getSchema().getColumnInfo(Subscription.class);
        long rowIndex = OsObject.createRow(table);
        cache.put(object, rowIndex);
        String realmGet$name = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$name();
        if (realmGet$name != null) {
            Table.nativeSetString(tableNativePtr, columnInfo.nameIndex, rowIndex, realmGet$name, false);
        } else {
            Table.nativeSetNull(tableNativePtr, columnInfo.nameIndex, rowIndex, false);
        }
        Table.nativeSetLong(tableNativePtr, columnInfo.statusIndex, rowIndex, ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$status(), false);
        String realmGet$errorMessage = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$errorMessage();
        if (realmGet$errorMessage != null) {
            Table.nativeSetString(tableNativePtr, columnInfo.errorMessageIndex, rowIndex, realmGet$errorMessage, false);
        } else {
            Table.nativeSetNull(tableNativePtr, columnInfo.errorMessageIndex, rowIndex, false);
        }
        String realmGet$matchesProperty = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$matchesProperty();
        if (realmGet$matchesProperty != null) {
            Table.nativeSetString(tableNativePtr, columnInfo.matchesPropertyIndex, rowIndex, realmGet$matchesProperty, false);
        } else {
            Table.nativeSetNull(tableNativePtr, columnInfo.matchesPropertyIndex, rowIndex, false);
        }
        String realmGet$query = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$query();
        if (realmGet$query != null) {
            Table.nativeSetString(tableNativePtr, columnInfo.queryIndex, rowIndex, realmGet$query, false);
        } else {
            Table.nativeSetNull(tableNativePtr, columnInfo.queryIndex, rowIndex, false);
        }
        Table.nativeSetLong(tableNativePtr, columnInfo.queryParseCounterIndex, rowIndex, ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$queryParseCounter(), false);
        Date realmGet$createdAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$createdAt();
        if (realmGet$createdAt != null) {
            Table.nativeSetTimestamp(tableNativePtr, columnInfo.createdAtIndex, rowIndex, realmGet$createdAt.getTime(), false);
        } else {
            Table.nativeSetNull(tableNativePtr, columnInfo.createdAtIndex, rowIndex, false);
        }
        Date realmGet$updatedAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$updatedAt();
        if (realmGet$updatedAt != null) {
            Table.nativeSetTimestamp(tableNativePtr, columnInfo.updatedAtIndex, rowIndex, realmGet$updatedAt.getTime(), false);
        } else {
            Table.nativeSetNull(tableNativePtr, columnInfo.updatedAtIndex, rowIndex, false);
        }
        Date realmGet$expiresAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$expiresAt();
        if (realmGet$expiresAt != null) {
            Table.nativeSetTimestamp(tableNativePtr, columnInfo.expiresAtIndex, rowIndex, realmGet$expiresAt.getTime(), false);
        } else {
            Table.nativeSetNull(tableNativePtr, columnInfo.expiresAtIndex, rowIndex, false);
        }
        Long realmGet$timeToLive = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$timeToLive();
        if (realmGet$timeToLive != null) {
            Table.nativeSetLong(tableNativePtr, columnInfo.timeToLiveIndex, rowIndex, realmGet$timeToLive, false);
        } else {
            Table.nativeSetNull(tableNativePtr, columnInfo.timeToLiveIndex, rowIndex, false);
        }
        return rowIndex;
    }

    public static void insertOrUpdate(Realm realm, Iterator<? extends RealmModel> objects, Map<RealmModel, Long> cache) {
        Table table = realm.getTable(Subscription.class);
        long tableNativePtr = table.getNativePtr();
        SubscriptionColumnInfo columnInfo = (SubscriptionColumnInfo)realm.getSchema().getColumnInfo(Subscription.class);
        Subscription object = null;
        while (objects.hasNext()) {
            object = (Subscription)objects.next();
            if (cache.containsKey(object)) continue;
            if (object instanceof RealmObjectProxy && ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                cache.put(object, ((RealmObjectProxy)((Object)object)).realmGet$proxyState().getRow$realm().getIndex());
                continue;
            }
            long rowIndex = OsObject.createRow(table);
            cache.put(object, rowIndex);
            String realmGet$name = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$name();
            if (realmGet$name != null) {
                Table.nativeSetString(tableNativePtr, columnInfo.nameIndex, rowIndex, realmGet$name, false);
            } else {
                Table.nativeSetNull(tableNativePtr, columnInfo.nameIndex, rowIndex, false);
            }
            Table.nativeSetLong(tableNativePtr, columnInfo.statusIndex, rowIndex, ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$status(), false);
            String realmGet$errorMessage = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$errorMessage();
            if (realmGet$errorMessage != null) {
                Table.nativeSetString(tableNativePtr, columnInfo.errorMessageIndex, rowIndex, realmGet$errorMessage, false);
            } else {
                Table.nativeSetNull(tableNativePtr, columnInfo.errorMessageIndex, rowIndex, false);
            }
            String realmGet$matchesProperty = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$matchesProperty();
            if (realmGet$matchesProperty != null) {
                Table.nativeSetString(tableNativePtr, columnInfo.matchesPropertyIndex, rowIndex, realmGet$matchesProperty, false);
            } else {
                Table.nativeSetNull(tableNativePtr, columnInfo.matchesPropertyIndex, rowIndex, false);
            }
            String realmGet$query = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$query();
            if (realmGet$query != null) {
                Table.nativeSetString(tableNativePtr, columnInfo.queryIndex, rowIndex, realmGet$query, false);
            } else {
                Table.nativeSetNull(tableNativePtr, columnInfo.queryIndex, rowIndex, false);
            }
            Table.nativeSetLong(tableNativePtr, columnInfo.queryParseCounterIndex, rowIndex, ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$queryParseCounter(), false);
            Date realmGet$createdAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$createdAt();
            if (realmGet$createdAt != null) {
                Table.nativeSetTimestamp(tableNativePtr, columnInfo.createdAtIndex, rowIndex, realmGet$createdAt.getTime(), false);
            } else {
                Table.nativeSetNull(tableNativePtr, columnInfo.createdAtIndex, rowIndex, false);
            }
            Date realmGet$updatedAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$updatedAt();
            if (realmGet$updatedAt != null) {
                Table.nativeSetTimestamp(tableNativePtr, columnInfo.updatedAtIndex, rowIndex, realmGet$updatedAt.getTime(), false);
            } else {
                Table.nativeSetNull(tableNativePtr, columnInfo.updatedAtIndex, rowIndex, false);
            }
            Date realmGet$expiresAt = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$expiresAt();
            if (realmGet$expiresAt != null) {
                Table.nativeSetTimestamp(tableNativePtr, columnInfo.expiresAtIndex, rowIndex, realmGet$expiresAt.getTime(), false);
            } else {
                Table.nativeSetNull(tableNativePtr, columnInfo.expiresAtIndex, rowIndex, false);
            }
            Long realmGet$timeToLive = ((io_realm_sync_SubscriptionRealmProxyInterface)object).realmGet$timeToLive();
            if (realmGet$timeToLive != null) {
                Table.nativeSetLong(tableNativePtr, columnInfo.timeToLiveIndex, rowIndex, realmGet$timeToLive, false);
                continue;
            }
            Table.nativeSetNull(tableNativePtr, columnInfo.timeToLiveIndex, rowIndex, false);
        }
    }

    public static Subscription createDetachedCopy(Subscription realmObject, int currentDepth, int maxDepth, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> cache) {
        Subscription unmanagedObject;
        if (currentDepth > maxDepth || realmObject == null) {
            return null;
        }
        RealmObjectProxy.CacheData<RealmModel> cachedObject = cache.get(realmObject);
        if (cachedObject == null) {
            unmanagedObject = new Subscription();
            cache.put(realmObject, new RealmObjectProxy.CacheData<Subscription>(currentDepth, unmanagedObject));
        } else {
            if (currentDepth >= cachedObject.minDepth) {
                return (Subscription)cachedObject.object;
            }
            unmanagedObject = (Subscription)cachedObject.object;
            cachedObject.minDepth = currentDepth;
        }
        io_realm_sync_SubscriptionRealmProxyInterface unmanagedCopy = unmanagedObject;
        io_realm_sync_SubscriptionRealmProxyInterface realmSource = realmObject;
        unmanagedCopy.realmSet$name(realmSource.realmGet$name());
        unmanagedCopy.realmSet$status(realmSource.realmGet$status());
        unmanagedCopy.realmSet$errorMessage(realmSource.realmGet$errorMessage());
        unmanagedCopy.realmSet$matchesProperty(realmSource.realmGet$matchesProperty());
        unmanagedCopy.realmSet$query(realmSource.realmGet$query());
        unmanagedCopy.realmSet$queryParseCounter(realmSource.realmGet$queryParseCounter());
        unmanagedCopy.realmSet$createdAt(realmSource.realmGet$createdAt());
        unmanagedCopy.realmSet$updatedAt(realmSource.realmGet$updatedAt());
        unmanagedCopy.realmSet$expiresAt(realmSource.realmGet$expiresAt());
        unmanagedCopy.realmSet$timeToLive(realmSource.realmGet$timeToLive());
        return unmanagedObject;
    }

    @Override
    public ProxyState<?> realmGet$proxyState() {
        return this.proxyState;
    }

    public int hashCode() {
        String realmName = this.proxyState.getRealm$realm().getPath();
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        long rowIndex = this.proxyState.getRow$realm().getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        io_realm_sync_SubscriptionRealmProxy aSubscription = (io_realm_sync_SubscriptionRealmProxy)o;
        String path = this.proxyState.getRealm$realm().getPath();
        String otherPath = aSubscription.proxyState.getRealm$realm().getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        String otherTableName = aSubscription.proxyState.getRow$realm().getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.proxyState.getRow$realm().getIndex() == aSubscription.proxyState.getRow$realm().getIndex();
    }

    public static final class ClassNameHelper {
        public static final String INTERNAL_CLASS_NAME = "__ResultSets";
    }

    static final class SubscriptionColumnInfo
    extends ColumnInfo {
        long maxColumnIndexValue;
        long nameIndex;
        long statusIndex;
        long errorMessageIndex;
        long matchesPropertyIndex;
        long queryIndex;
        long queryParseCounterIndex;
        long createdAtIndex;
        long updatedAtIndex;
        long expiresAtIndex;
        long timeToLiveIndex;

        SubscriptionColumnInfo(OsSchemaInfo schemaInfo) {
            super(10);
            OsObjectSchemaInfo objectSchemaInfo = schemaInfo.getObjectSchemaInfo("__ResultSets");
            this.nameIndex = this.addColumnDetails("name", "name", objectSchemaInfo);
            this.statusIndex = this.addColumnDetails("status", "status", objectSchemaInfo);
            this.errorMessageIndex = this.addColumnDetails("errorMessage", "error_message", objectSchemaInfo);
            this.matchesPropertyIndex = this.addColumnDetails("matchesProperty", "matches_property", objectSchemaInfo);
            this.queryIndex = this.addColumnDetails("query", "query", objectSchemaInfo);
            this.queryParseCounterIndex = this.addColumnDetails("queryParseCounter", "query_parse_counter", objectSchemaInfo);
            this.createdAtIndex = this.addColumnDetails("createdAt", "created_at", objectSchemaInfo);
            this.updatedAtIndex = this.addColumnDetails("updatedAt", "updated_at", objectSchemaInfo);
            this.expiresAtIndex = this.addColumnDetails("expiresAt", "expires_at", objectSchemaInfo);
            this.timeToLiveIndex = this.addColumnDetails("timeToLive", "time_to_live", objectSchemaInfo);
            this.maxColumnIndexValue = objectSchemaInfo.getMaxColumnIndex();
        }

        SubscriptionColumnInfo(ColumnInfo src, boolean mutable) {
            super(src, mutable);
            this.copy(src, this);
        }

        @Override
        protected final ColumnInfo copy(boolean mutable) {
            return new SubscriptionColumnInfo(this, mutable);
        }

        @Override
        protected final void copy(ColumnInfo rawSrc, ColumnInfo rawDst) {
            SubscriptionColumnInfo src = (SubscriptionColumnInfo)rawSrc;
            SubscriptionColumnInfo dst = (SubscriptionColumnInfo)rawDst;
            dst.nameIndex = src.nameIndex;
            dst.statusIndex = src.statusIndex;
            dst.errorMessageIndex = src.errorMessageIndex;
            dst.matchesPropertyIndex = src.matchesPropertyIndex;
            dst.queryIndex = src.queryIndex;
            dst.queryParseCounterIndex = src.queryParseCounterIndex;
            dst.createdAtIndex = src.createdAtIndex;
            dst.updatedAtIndex = src.updatedAtIndex;
            dst.expiresAtIndex = src.expiresAtIndex;
            dst.timeToLiveIndex = src.timeToLiveIndex;
            dst.maxColumnIndexValue = src.maxColumnIndexValue;
        }
    }
}

