/*
 * Decompiled with CFR 0.152.
 */
package io.realm.permissions;

public enum AccessLevel {
    NONE("none", false, false, false),
    READ("read", true, false, false),
    WRITE("write", true, true, false),
    ADMIN("admin", true, true, true);

    private final String key;
    private final boolean mayRead;
    private final boolean mayWrite;
    private final boolean mayManage;

    private AccessLevel(String serverKey, boolean mayRead, boolean mayWrite, boolean mayManage) {
        this.key = serverKey;
        this.mayRead = mayRead;
        this.mayWrite = mayWrite;
        this.mayManage = mayManage;
    }

    public static AccessLevel fromKey(String accessLevel) {
        for (AccessLevel level : AccessLevel.values()) {
            if (!level.getKey().equals(accessLevel)) continue;
            return level;
        }
        throw new IllegalArgumentException("Unknown access level: " + accessLevel);
    }

    public boolean mayRead() {
        return this.mayRead;
    }

    public boolean mayWrite() {
        return this.mayWrite;
    }

    public boolean mayManage() {
        return this.mayManage;
    }

    public String getKey() {
        return this.key;
    }
}

