/*
 * Decompiled with CFR 0.152.
 */
package io.realm.permissions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.permissions.AccessLevel;
import java.util.Date;
import javax.annotation.Nullable;

public final class Permission {
    @Nullable
    private final String userId;
    private final String path;
    private final AccessLevel accessLevel;
    private final boolean mayRead;
    private final boolean mayWrite;
    private final boolean mayManage;
    private final Date updatedAt;

    public Permission(@Nullable String userId, String path, AccessLevel accessLevel, boolean mayRead, boolean mayWrite, boolean mayManage, Date updatedAt) {
        this.userId = userId;
        this.path = path;
        this.accessLevel = accessLevel;
        this.mayRead = mayRead;
        this.mayWrite = mayWrite;
        this.mayManage = mayManage;
        this.updatedAt = (Date)updatedAt.clone();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPath() {
        return this.path;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public boolean mayRead() {
        return this.mayRead;
    }

    public boolean mayWrite() {
        return this.mayWrite;
    }

    public boolean mayManage() {
        return this.mayManage;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String toString() {
        return "Permission{userId='" + this.userId + '\'' + ", path='" + this.path + '\'' + ", accessLevel=" + (Object)((Object)this.accessLevel) + ", mayRead=" + this.mayRead + ", mayWrite=" + this.mayWrite + ", mayManage=" + this.mayManage + ", updatedAt=" + this.updatedAt + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permission that = (Permission)o;
        if (this.mayRead != that.mayRead) {
            return false;
        }
        if (this.mayWrite != that.mayWrite) {
            return false;
        }
        if (this.mayManage != that.mayManage) {
            return false;
        }
        if (this.userId != null ? !this.userId.equals(that.userId) : that.userId != null) {
            return false;
        }
        if (!this.path.equals(that.path)) {
            return false;
        }
        if (this.accessLevel != that.accessLevel) {
            return false;
        }
        return this.updatedAt.equals(that.updatedAt);
    }

    public int hashCode() {
        int result = this.userId != null ? this.userId.hashCode() : 0;
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.accessLevel.hashCode();
        result = 31 * result + (this.mayRead ? 1 : 0);
        result = 31 * result + (this.mayWrite ? 1 : 0);
        result = 31 * result + (this.mayManage ? 1 : 0);
        result = 31 * result + this.updatedAt.hashCode();
        return result;
    }
}

