/*
 * Decompiled with CFR 0.152.
 */
package io.realm.permissions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.internal.Util;
import io.realm.permissions.AccessLevel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PermissionOffer {
    @Nonnull
    private final Date createdAt;
    private final String userId;
    private final String token;
    @Nonnull
    private final String realmUrl;
    @Nonnull
    private final AccessLevel accessLevel;
    private final Date expiresAt;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PermissionOffer(String url, AccessLevel accessLevel) {
        this(url, accessLevel, null);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PermissionOffer(String url, AccessLevel accessLevel, @Nullable Date expiresAt) {
        this(url, accessLevel, expiresAt, new Date(), null, null);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PermissionOffer(String path, AccessLevel accessLevel, @Nullable Date expiresAt, Date createdAt, @Nullable String userId, @Nullable String token) {
        this.validateUrl(path);
        this.validateAccessLevel(accessLevel);
        this.realmUrl = path;
        this.accessLevel = accessLevel;
        this.expiresAt = expiresAt != null ? (Date)expiresAt.clone() : null;
        this.createdAt = (Date)createdAt.clone();
        this.userId = userId;
        this.token = token;
    }

    private void validateUrl(String url) {
        if (Util.isEmptyString(url)) {
            throw new IllegalArgumentException("Non-empty 'realmUrl' required.");
        }
        try {
            new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid 'realmUrl'.", e);
        }
    }

    private void validateAccessLevel(AccessLevel accessLevel) {
        if (accessLevel == null) {
            throw new IllegalArgumentException("Non-null 'accessLevel' required.");
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public String getRealmUrl() {
        return this.realmUrl;
    }

    public boolean mayRead() {
        return this.accessLevel.mayRead();
    }

    public boolean mayWrite() {
        return this.accessLevel.mayWrite();
    }

    public boolean mayManage() {
        return this.accessLevel.mayManage();
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public boolean isOfferCreated() {
        return !Util.isEmptyString(this.token);
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public String toString() {
        return "PermissionOffer{userId='" + this.userId + '\'' + ", createdAt=" + this.createdAt + ", token='" + this.token + '\'' + ", realmUrl='" + this.realmUrl + '\'' + ", mayRead=" + this.accessLevel.mayRead() + ", mayWrite=" + this.accessLevel.mayWrite() + ", mayManage=" + this.accessLevel.mayManage() + ", expiresAt=" + this.expiresAt + '}';
    }
}

