/*
 * Decompiled with CFR 0.152.
 */
package io.realm.sync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.annotations.Index;
import io.realm.annotations.RealmClass;
import io.realm.annotations.RealmField;
import io.realm.annotations.Required;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.annotations.ObjectServer;
import io.realm.io_realm_sync_SubscriptionRealmProxyInterface;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@RealmClass(name="__ResultSets")
@ObjectServer
public class Subscription
extends RealmObject
implements io_realm_sync_SubscriptionRealmProxyInterface {
    @Index
    @Required
    private String name;
    private byte status;
    @Required
    @RealmField(value="error_message")
    private String errorMessage;
    @Required
    @RealmField(value="matches_property")
    private String matchesProperty;
    @Required
    private String query;
    @RealmField(value="query_parse_counter")
    private int queryParseCounter;
    @Required
    @RealmField(value="created_at")
    private Date createdAt;
    @Required
    @RealmField(value="updated_at")
    private Date updatedAt;
    @Nullable
    @RealmField(value="expires_at")
    private Date expiresAt;
    @Nullable
    @RealmField(value="time_to_live")
    private Long timeToLive;

    public Subscription() {
        if (this instanceof RealmObjectProxy) {
            ((RealmObjectProxy)((Object)this)).realm$injectObjectContext();
        }
    }

    public Subscription(String name, RealmQuery<?> query) {
        if (this instanceof RealmObjectProxy) {
            ((RealmObjectProxy)((Object)this)).realm$injectObjectContext();
        }
        String string = name;
        Subscription subscription = this;
        subscription.realmSet$name(string);
        string = query.getDescription();
        subscription = this;
        subscription.realmSet$query(string);
        byte by = 0;
        subscription = this;
        subscription.realmSet$status(by);
        String string2 = "";
        subscription = this;
        subscription.realmSet$errorMessage(string2);
        string2 = "";
        subscription = this;
        subscription.realmSet$matchesProperty(string2);
    }

    public String getName() {
        Subscription subscription = this;
        String string = null;
        string = subscription.realmGet$name();
        return string;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Date getCreatedAt() {
        Subscription subscription = this;
        Date date = null;
        date = subscription.realmGet$createdAt();
        return date;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Date getUpdatedAt() {
        Subscription subscription = this;
        Date date = null;
        date = subscription.realmGet$updatedAt();
        return date;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Date getExpiresAt() {
        Subscription subscription = this;
        Date date = null;
        date = subscription.realmGet$expiresAt();
        if (date == null) {
            return new Date(Long.MAX_VALUE);
        }
        subscription = this;
        date = null;
        date = subscription.realmGet$expiresAt();
        return date;
    }

    public long getTimeToLive() {
        long l;
        Subscription subscription = this;
        Long l2 = null;
        l2 = subscription.realmGet$timeToLive();
        if (l2 != null) {
            subscription = this;
            l2 = null;
            l2 = subscription.realmGet$timeToLive();
            l = l2;
        } else {
            l = Long.MAX_VALUE;
        }
        return l;
    }

    public void setTimeToLive(long timeToLive, TimeUnit timeUnit) {
        if (timeToLive < 0L) {
            throw new IllegalArgumentException("A negative time-to-live is not allowed: " + timeToLive);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Non-null 'timeUnit' required.");
        }
        Comparable<Date> comparable = new Date(System.currentTimeMillis());
        Subscription subscription = this;
        subscription.realmSet$updatedAt((Date)comparable);
        comparable = TimeUnit.MILLISECONDS.convert(timeToLive, timeUnit);
        subscription = this;
        subscription.realmSet$timeToLive((Long)comparable);
        subscription = this;
        comparable = null;
        comparable = subscription.realmGet$updatedAt();
        long expiryTime = ((Date)comparable).getTime();
        subscription = this;
        comparable = null;
        comparable = subscription.realmGet$timeToLive();
        if (expiryTime + (Long)comparable < expiryTime) {
            expiryTime = Long.MAX_VALUE;
        } else {
            subscription = this;
            comparable = null;
            comparable = subscription.realmGet$timeToLive();
            expiryTime += ((Long)comparable).longValue();
        }
        comparable = new Date(expiryTime);
        subscription = this;
        subscription.realmSet$expiresAt((Date)comparable);
    }

    public String getQueryDescription() {
        Subscription subscription = this;
        String string = null;
        string = subscription.realmGet$query();
        return string;
    }

    public void setQuery(RealmQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Non-null 'query' required");
        }
        if (!query.getTypeQueried().equals(this.getQueryClassName())) {
            throw new IllegalArgumentException(String.format("It is only allowed to replace a query with another query on the same type.Existing query: '%s'. New query: '%s'", this.getQueryClassName(), query.getTypeQueried()));
        }
        Object object = query.getDescription();
        Subscription subscription = this;
        subscription.realmSet$query((String)object);
        object = new Date();
        subscription = this;
        subscription.realmSet$updatedAt((Date)object);
    }

    public String getQueryClassName() {
        Subscription subscription = this;
        String string = null;
        String classQueried = string = subscription.realmGet$matchesProperty();
        return classQueried.substring(0, classQueried.length() - "_matches".length());
    }

    public State getState() {
        if (!RealmObject.isValid(this)) {
            return State.INVALIDATED;
        }
        Subscription subscription = this;
        byte by = 0;
        by = subscription.realmGet$status();
        switch (by) {
            case -1: {
                return State.ERROR;
            }
            case 0: {
                return State.PENDING;
            }
            case 1: {
                return State.ACTIVE;
            }
        }
        subscription = this;
        by = 0;
        by = subscription.realmGet$status();
        throw new IllegalArgumentException("Unknown subscription state value: " + by);
    }

    public String getErrorMessage() {
        Subscription subscription = this;
        String string = null;
        string = subscription.realmGet$errorMessage();
        return string;
    }

    public void unsubscribe() {
        RealmObject.deleteFromRealm(this);
    }

    public String toString() {
        Subscription subscription = this;
        String string = null;
        string = subscription.realmGet$name();
        subscription = this;
        byte by = 0;
        by = subscription.realmGet$status();
        subscription = this;
        Object object = null;
        object = subscription.realmGet$errorMessage();
        StringBuilder stringBuilder = new StringBuilder().append("Subscription{name='").append(string).append('\'').append(", status=").append(by).append(", errorMessage='").append((String)object).append('\'').append(", query='");
        subscription = this;
        object = null;
        object = subscription.realmGet$query();
        StringBuilder stringBuilder2 = stringBuilder.append((String)object).append('\'').append(", createdAt=");
        subscription = this;
        object = null;
        object = subscription.realmGet$createdAt();
        StringBuilder stringBuilder3 = stringBuilder2.append(object).append(", updatedAt=");
        subscription = this;
        object = null;
        object = subscription.realmGet$updatedAt();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", expiresAt=");
        subscription = this;
        object = null;
        object = subscription.realmGet$expiresAt();
        StringBuilder stringBuilder5 = stringBuilder4.append(object).append(", timeToLive=");
        subscription = this;
        object = null;
        object = subscription.realmGet$timeToLive();
        return stringBuilder5.append(object).append('}').toString();
    }

    @Override
    public String realmGet$name() {
        return this.name;
    }

    @Override
    public void realmSet$name(String string) {
        this.name = string;
    }

    @Override
    public byte realmGet$status() {
        return this.status;
    }

    @Override
    public void realmSet$status(byte by) {
        this.status = by;
    }

    @Override
    public String realmGet$errorMessage() {
        return this.errorMessage;
    }

    @Override
    public void realmSet$errorMessage(String string) {
        this.errorMessage = string;
    }

    @Override
    public String realmGet$matchesProperty() {
        return this.matchesProperty;
    }

    @Override
    public void realmSet$matchesProperty(String string) {
        this.matchesProperty = string;
    }

    @Override
    public String realmGet$query() {
        return this.query;
    }

    @Override
    public void realmSet$query(String string) {
        this.query = string;
    }

    @Override
    public int realmGet$queryParseCounter() {
        return this.queryParseCounter;
    }

    @Override
    public void realmSet$queryParseCounter(int n) {
        this.queryParseCounter = n;
    }

    @Override
    public Date realmGet$createdAt() {
        return this.createdAt;
    }

    @Override
    public void realmSet$createdAt(Date date) {
        this.createdAt = date;
    }

    @Override
    public Date realmGet$updatedAt() {
        return this.updatedAt;
    }

    @Override
    public void realmSet$updatedAt(Date date) {
        this.updatedAt = date;
    }

    @Override
    public Date realmGet$expiresAt() {
        return this.expiresAt;
    }

    @Override
    public void realmSet$expiresAt(Date date) {
        this.expiresAt = date;
    }

    @Override
    public Long realmGet$timeToLive() {
        return this.timeToLive;
    }

    @Override
    public void realmSet$timeToLive(Long l) {
        this.timeToLive = l;
    }

    public static enum State {
        ERROR((byte)-1),
        PENDING((byte)0),
        ACTIVE((byte)1),
        INVALIDATED(null);

        private final Byte nativeValue;

        private State(Byte nativeValue) {
            this.nativeValue = nativeValue;
        }

        public Byte getValue() {
            return this.nativeValue;
        }
    }
}

