/*
 * Decompiled with CFR 0.152.
 */
package io.realm.sync.permissions;

import io.realm.internal.annotations.ObjectServer;

@ObjectServer
public final class RealmPrivileges {
    private boolean canRead;
    private boolean canUpdate;
    private boolean canDelete;
    private boolean canSetPermissions;
    private boolean canQuery;
    private boolean canCreate;
    private boolean canModifySchema;

    public RealmPrivileges(long privileges) {
        this.canRead = (privileges & 1L) != 0L;
        this.canUpdate = (privileges & 2L) != 0L;
        this.canDelete = (privileges & 4L) != 0L;
        this.canSetPermissions = (privileges & 8L) != 0L;
        this.canQuery = (privileges & 0x10L) != 0L;
        this.canCreate = (privileges & 0x20L) != 0L;
        this.canModifySchema = (privileges & 0x40L) != 0L;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canUpdate() {
        return this.canUpdate;
    }

    public boolean canSetPermissions() {
        return this.canSetPermissions;
    }

    public boolean canModifySchema() {
        return this.canModifySchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealmPrivileges that = (RealmPrivileges)o;
        if (this.canRead != that.canRead) {
            return false;
        }
        if (this.canUpdate != that.canUpdate) {
            return false;
        }
        if (this.canDelete != that.canDelete) {
            return false;
        }
        if (this.canSetPermissions != that.canSetPermissions) {
            return false;
        }
        if (this.canQuery != that.canQuery) {
            return false;
        }
        if (this.canCreate != that.canCreate) {
            return false;
        }
        return this.canModifySchema == that.canModifySchema;
    }

    public int hashCode() {
        int result = this.canRead ? 1 : 0;
        result = 31 * result + (this.canUpdate ? 1 : 0);
        result = 31 * result + (this.canDelete ? 1 : 0);
        result = 31 * result + (this.canSetPermissions ? 1 : 0);
        result = 31 * result + (this.canQuery ? 1 : 0);
        result = 31 * result + (this.canCreate ? 1 : 0);
        result = 31 * result + (this.canModifySchema ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RealmPrivileges{canRead=" + this.canRead + ", canUpdate=" + this.canUpdate + ", canDelete=" + this.canDelete + ", canSetPermissions=" + this.canSetPermissions + ", canQuery=" + this.canQuery + ", canCreate=" + this.canCreate + ", canModifySchema=" + this.canModifySchema + '}';
    }
}

