/*
 * Decompiled with CFR 0.152.
 */
package io.realm.sync.permissions;

import io.realm.Realm;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.annotations.PrimaryKey;
import io.realm.annotations.RealmClass;
import io.realm.annotations.Required;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Util;
import io.realm.internal.annotations.ObjectServer;
import io.realm.io_realm_sync_permissions_RoleRealmProxyInterface;
import io.realm.sync.permissions.PermissionUser;

@RealmClass(name="__Role")
@ObjectServer
public class Role
extends RealmObject
implements io_realm_sync_permissions_RoleRealmProxyInterface {
    @PrimaryKey
    @Required
    private String name;
    private RealmList<PermissionUser> members;

    public Role() {
        if (this instanceof RealmObjectProxy) {
            ((RealmObjectProxy)((Object)this)).realm$injectObjectContext();
        }
        RealmList realmList = new RealmList();
        Role role = this;
        role.realmSet$members(realmList);
    }

    public Role(String name) {
        if (this instanceof RealmObjectProxy) {
            ((RealmObjectProxy)((Object)this)).realm$injectObjectContext();
        }
        Object object = new RealmList();
        Role role = this;
        role.realmSet$members((RealmList)object);
        object = name;
        role = this;
        role.realmSet$name((String)object);
    }

    public String getName() {
        Role role = this;
        String string = null;
        string = role.realmGet$name();
        return string;
    }

    public void addMember(String userId) {
        PermissionUser user;
        if (this.isManaged()) {
            if (Util.isEmptyString(userId)) {
                throw new IllegalArgumentException("Non-empty 'userId' required");
            }
            Realm realm = this.getRealm();
            user = realm.where(PermissionUser.class).equalTo("id", userId).findFirst();
            if (user == null) {
                user = realm.createObject(PermissionUser.class, userId);
            }
        } else {
            throw new IllegalStateException("Can not add a member to a non managed Role");
        }
        Role role = this;
        RealmList realmList = null;
        realmList = role.realmGet$members();
        realmList.add(user);
    }

    public boolean removeMember(String userId) {
        PermissionUser user = this.getRealm().where(PermissionUser.class).equalTo("id", userId).findFirst();
        if (user != null) {
            Role role = this;
            RealmList realmList = null;
            realmList = role.realmGet$members();
            return realmList.remove(user);
        }
        return false;
    }

    public boolean hasMember(String userId) {
        Role role = this;
        RealmList realmList = null;
        realmList = role.realmGet$members();
        return realmList.where().equalTo("id", userId).count() > 0L;
    }

    public RealmList<PermissionUser> getMembers() {
        Role role = this;
        RealmList realmList = null;
        realmList = role.realmGet$members();
        return realmList;
    }

    @Override
    public String realmGet$name() {
        return this.name;
    }

    @Override
    public void realmSet$name(String string) {
        this.name = string;
    }

    public RealmList realmGet$members() {
        return this.members;
    }

    public void realmSet$members(RealmList realmList) {
        this.members = realmList;
    }
}

