/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Looper;
import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.RealmCache;
import io.realm.RealmConfiguration;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.internal.Table;
import io.realm.internal.TableView;
import io.realm.internal.log.RealmLog;
import rx.Observable;

public final class DynamicRealm
extends BaseRealm {
    private DynamicRealm(RealmConfiguration configuration, boolean autoRefresh) {
        super(configuration, autoRefresh);
    }

    public static DynamicRealm getInstance(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return RealmCache.createRealmOrGetFromCache(configuration, DynamicRealm.class);
    }

    public DynamicRealmObject createObject(String className) {
        this.checkIfValid();
        Table table = this.schema.getTable(className);
        long rowIndex = table.addEmptyRow();
        return this.get(DynamicRealmObject.class, className, rowIndex);
    }

    public DynamicRealmObject createObject(String className, Object primaryKeyValue) {
        Table table = this.schema.getTable(className);
        long index = table.addEmptyRowWithPrimaryKey(primaryKeyValue);
        DynamicRealmObject dynamicRealmObject = new DynamicRealmObject(this, table.getCheckedRow(index));
        this.handlerController.addToRealmObjects(dynamicRealmObject);
        return dynamicRealmObject;
    }

    public RealmQuery<DynamicRealmObject> where(String className) {
        this.checkIfValid();
        if (!this.sharedGroupManager.hasTable(Table.TABLE_PREFIX + className)) {
            throw new IllegalArgumentException("Class does not exist in the Realm so it cannot be queried: " + className);
        }
        return RealmQuery.createDynamicQuery(this, className);
    }

    @Deprecated
    public void clear(String className) {
        this.delete(className);
    }

    public void delete(String className) {
        this.checkIfValid();
        this.schema.getTable(className).clear();
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (RuntimeException e) {
            if (this.isInTransaction()) {
                this.cancelTransaction();
            } else {
                RealmLog.w("Could not cancel transaction, not currently in a transaction.");
            }
            throw e;
        }
    }

    public RealmResults<DynamicRealmObject> allObjects(String className) {
        return this.where(className).findAll();
    }

    public RealmResults<DynamicRealmObject> allObjectsSorted(String className, String fieldName, Sort sortOrder) {
        this.checkIfValid();
        Table table = this.schema.getTable(className);
        long columnIndex = table.getColumnIndex(fieldName);
        if (columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        TableView tableView = table.getSortedView(columnIndex, sortOrder);
        return RealmResults.createFromDynamicTableOrView(this, tableView, className);
    }

    public RealmResults<DynamicRealmObject> allObjectsSorted(String className, String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.allObjectsSorted(className, new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    public RealmResults<DynamicRealmObject> allObjectsSorted(String className, String[] fieldNames, Sort[] sortOrders) {
        this.checkAllObjectsSortedParameters(fieldNames, sortOrders);
        Table table = this.schema.getTable(className);
        TableView tableView = this.doMultiFieldSort(fieldNames, sortOrders, table);
        return RealmResults.createFromDynamicTableOrView(this, tableView, className);
    }

    static DynamicRealm createInstance(RealmConfiguration configuration) {
        boolean autoRefresh = Looper.myLooper() != null;
        return new DynamicRealm(configuration, autoRefresh);
    }

    public RealmResults<DynamicRealmObject> distinct(String className, String fieldName) {
        this.checkIfValid();
        Table table = this.schema.getTable(className);
        long columnIndex = RealmQuery.getAndValidateDistinctColumnIndex(fieldName, table);
        TableView tableView = table.getDistinctView(columnIndex);
        return RealmResults.createFromDynamicTableOrView(this, tableView, className);
    }

    public RealmResults<DynamicRealmObject> distinctAsync(String className, String fieldName) {
        this.checkIfValid();
        return this.where(className).distinctAsync(fieldName);
    }

    public RealmResults<DynamicRealmObject> distinct(String className, String firstFieldName, String ... remainingFieldNames) {
        this.checkIfValid();
        return this.where(className).distinct(firstFieldName, remainingFieldNames);
    }

    public Observable<DynamicRealm> asObservable() {
        return this.configuration.getRxFactory().from(this);
    }

    public static interface Transaction {
        public void execute(DynamicRealm var1);
    }
}

