/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ProxyState;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmSchema;
import io.realm.internal.CheckedRow;
import io.realm.internal.LinkView;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.android.JsonUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public final class DynamicRealmObject
extends RealmObject
implements RealmObjectProxy {
    private final ProxyState proxyState = new ProxyState();

    public DynamicRealmObject(RealmModel obj) {
        if (obj == null) {
            throw new IllegalArgumentException("A non-null object must be provided.");
        }
        if (obj instanceof DynamicRealmObject) {
            throw new IllegalArgumentException("The object is already a DynamicRealmObject: " + obj);
        }
        if (!RealmObject.isValid(obj)) {
            throw new IllegalArgumentException("An object managed by Realm must be provided. This is a standalone object or it was deleted.");
        }
        RealmObjectProxy proxy = (RealmObjectProxy)obj;
        Row row = proxy.realmGet$proxyState().getRow$realm();
        this.proxyState.setRealm$realm(proxy.realmGet$proxyState().getRealm$realm());
        this.proxyState.setRow$realm(((UncheckedRow)row).convertToChecked());
    }

    DynamicRealmObject() {
    }

    DynamicRealmObject(BaseRealm realm, Row row) {
        this.proxyState.setRealm$realm(realm);
        this.proxyState.setRow$realm(row instanceof CheckedRow ? (CheckedRow)row : ((UncheckedRow)row).convertToChecked());
    }

    DynamicRealmObject(String className) {
        this.proxyState.setClassName(className);
    }

    public <E> E get(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
        switch (type) {
            case BOOLEAN: {
                return (E)Boolean.valueOf(this.proxyState.getRow$realm().getBoolean(columnIndex));
            }
            case INTEGER: {
                return (E)Long.valueOf(this.proxyState.getRow$realm().getLong(columnIndex));
            }
            case FLOAT: {
                return (E)Float.valueOf(this.proxyState.getRow$realm().getFloat(columnIndex));
            }
            case DOUBLE: {
                return (E)Double.valueOf(this.proxyState.getRow$realm().getDouble(columnIndex));
            }
            case STRING: {
                return (E)this.proxyState.getRow$realm().getString(columnIndex);
            }
            case BINARY: {
                return (E)this.proxyState.getRow$realm().getBinaryByteArray(columnIndex);
            }
            case DATE: {
                return (E)this.proxyState.getRow$realm().getDate(columnIndex);
            }
            case OBJECT: {
                return (E)this.getObject(fieldName);
            }
            case LIST: {
                return (E)this.getList(fieldName);
            }
        }
        throw new IllegalStateException("Field type not supported: " + (Object)((Object)type));
    }

    public boolean getBoolean(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        return this.proxyState.getRow$realm().getBoolean(columnIndex);
    }

    public int getInt(String fieldName) {
        return (int)this.getLong(fieldName);
    }

    public short getShort(String fieldName) {
        return (short)this.getLong(fieldName);
    }

    public long getLong(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        return this.proxyState.getRow$realm().getLong(columnIndex);
    }

    public byte getByte(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        return (byte)this.proxyState.getRow$realm().getLong(columnIndex);
    }

    public float getFloat(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        return this.proxyState.getRow$realm().getFloat(columnIndex);
    }

    public double getDouble(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        return this.proxyState.getRow$realm().getDouble(columnIndex);
    }

    public byte[] getBlob(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        return this.proxyState.getRow$realm().getBinaryByteArray(columnIndex);
    }

    public String getString(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        return this.proxyState.getRow$realm().getString(columnIndex);
    }

    public Date getDate(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        if (this.proxyState.getRow$realm().isNull(columnIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(columnIndex);
    }

    public DynamicRealmObject getObject(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        if (this.proxyState.getRow$realm().isNullLink(columnIndex)) {
            return null;
        }
        long linkRowIndex = this.proxyState.getRow$realm().getLink(columnIndex);
        CheckedRow linkRow = this.proxyState.getRow$realm().getTable().getLinkTarget(columnIndex).getCheckedRow(linkRowIndex);
        return new DynamicRealmObject(this.proxyState.getRealm$realm(), linkRow);
    }

    public RealmList<DynamicRealmObject> getList(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        LinkView linkView = this.proxyState.getRow$realm().getLinkList(columnIndex);
        String className = RealmSchema.getSchemaForTable(linkView.getTargetTable());
        return new RealmList<DynamicRealmObject>(className, linkView, this.proxyState.getRealm$realm());
    }

    public boolean isNull(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
        switch (type) {
            case OBJECT: {
                return this.proxyState.getRow$realm().isNullLink(columnIndex);
            }
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BINARY: 
            case DATE: {
                return this.proxyState.getRow$realm().isNull(columnIndex);
            }
        }
        return false;
    }

    public boolean hasField(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        return this.proxyState.getRow$realm().hasColumn(fieldName);
    }

    public String[] getFieldNames() {
        String[] keys = new String[(int)this.proxyState.getRow$realm().getColumnCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.proxyState.getRow$realm().getColumnName(i);
        }
        return keys;
    }

    public void set(String fieldName, Object value) {
        boolean isString = value instanceof String;
        String strValue = isString ? (String)value : null;
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
        if (isString && type != RealmFieldType.STRING) {
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.parseBoolean(strValue);
                    break;
                }
                case INTEGER: {
                    value = Long.parseLong(strValue);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(Float.parseFloat(strValue));
                    break;
                }
                case DOUBLE: {
                    value = Double.parseDouble(strValue);
                    break;
                }
                case DATE: {
                    value = JsonUtils.stringToDate(strValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Field %s is not a String field, and the provide value could not be automatically converted: %s. Use a typedsetter instead", fieldName, value));
                }
            }
        }
        if (value == null) {
            this.setNull(fieldName);
        } else {
            this.setValue(fieldName, value);
        }
    }

    private void setValue(String fieldName, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass == Boolean.class) {
            this.setBoolean(fieldName, (Boolean)value);
        } else if (valueClass == Short.class) {
            this.setShort(fieldName, (Short)value);
        } else if (valueClass == Integer.class) {
            this.setInt(fieldName, (Integer)value);
        } else if (valueClass == Long.class) {
            this.setLong(fieldName, (Long)value);
        } else if (valueClass == Byte.class) {
            this.setByte(fieldName, (Byte)value);
        } else if (valueClass == Float.class) {
            this.setFloat(fieldName, ((Float)value).floatValue());
        } else if (valueClass == Double.class) {
            this.setDouble(fieldName, (Double)value);
        } else if (valueClass == String.class) {
            this.setString(fieldName, (String)value);
        } else if (value instanceof Date) {
            this.setDate(fieldName, (Date)value);
        } else if (value instanceof byte[]) {
            this.setBlob(fieldName, (byte[])value);
        } else if (valueClass == DynamicRealmObject.class) {
            this.setObject(fieldName, (DynamicRealmObject)value);
        } else if (valueClass == RealmList.class) {
            RealmList list = (RealmList)value;
            this.setList(fieldName, list);
        } else {
            throw new IllegalArgumentException("Value is of an type not supported: " + value.getClass());
        }
    }

    public void setBoolean(String fieldName, boolean value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setBoolean(columnIndex, value);
    }

    public void setShort(String fieldName, short value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setLong(columnIndex, value);
    }

    public void setInt(String fieldName, int value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setLong(columnIndex, value);
    }

    public void setLong(String fieldName, long value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setLong(columnIndex, value);
    }

    public void setByte(String fieldName, byte value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setLong(columnIndex, value);
    }

    public void setFloat(String fieldName, float value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setFloat(columnIndex, value);
    }

    public void setDouble(String fieldName, double value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setDouble(columnIndex, value);
    }

    public void setString(String fieldName, String value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setString(columnIndex, value);
    }

    public void setBlob(String fieldName, byte[] value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setBinaryByteArray(columnIndex, value);
    }

    public void setDate(String fieldName, Date value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnIndex);
        } else {
            this.proxyState.getRow$realm().setDate(columnIndex, value);
        }
    }

    public void setObject(String fieldName, DynamicRealmObject value) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().nullifyLink(columnIndex);
        } else {
            Table inputTable;
            if (value.proxyState.getRealm$realm() == null || value.proxyState.getRow$realm() == null) {
                throw new IllegalArgumentException("Cannot link to objects that are not part of the Realm.");
            }
            if (this.proxyState.getRealm$realm() != value.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Cannot add an object from another Realm instance.");
            }
            Table table = this.proxyState.getRow$realm().getTable().getLinkTarget(columnIndex);
            if (!table.hasSameSchema(inputTable = value.proxyState.getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format("Type of object is wrong. Was %s, expected %s", inputTable.getName(), table.getName()));
            }
            this.proxyState.getRow$realm().setLink(columnIndex, value.proxyState.getRow$realm().getIndex());
        }
    }

    public void setList(String fieldName, RealmList<? extends RealmModel> list) {
        boolean typeValidated;
        if (list == null) {
            throw new IllegalArgumentException("Null values not allowed for lists");
        }
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        if (list.className == null && list.clazz == null) {
            typeValidated = false;
        } else {
            String listType;
            String string = listType = list.className != null ? list.className : this.proxyState.getRealm$realm().schema.getTable(list.clazz).getName();
            if (!tableName.equals(listType)) {
                throw new IllegalArgumentException(String.format("The elements in the list is not the proper type. Was %s expected %s.", listType, tableName));
            }
            typeValidated = true;
        }
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        LinkView links = this.proxyState.getRow$realm().getLinkList(columnIndex);
        links.clear();
        Table linkTargetTable = links.getTargetTable();
        for (int i = 0; i < list.size(); ++i) {
            RealmObjectProxy obj = (RealmObjectProxy)list.get(i);
            if (obj.realmGet$proxyState().getRealm$realm() != this.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Each element in 'list' must belong to the same Realm instance.");
            }
            if (!typeValidated && !linkTargetTable.hasSameSchema(obj.realmGet$proxyState().getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Element at index %d is not the proper type. Was '%s' expected '%s'.", i, obj.realmGet$proxyState().getRow$realm().getTable().getName(), linkTargetTable.getName()));
            }
            links.add(obj.realmGet$proxyState().getRow$realm().getIndex());
        }
    }

    public void setNull(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
        if (type == RealmFieldType.OBJECT) {
            this.proxyState.getRow$realm().nullifyLink(columnIndex);
        } else {
            this.proxyState.getRow$realm().setNull(columnIndex);
        }
    }

    public String getType() {
        return RealmSchema.getSchemaForTable(this.proxyState.getRow$realm().getTable());
    }

    public RealmFieldType getFieldType(String fieldName) {
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        return this.proxyState.getRow$realm().getColumnType(columnIndex);
    }

    public int hashCode() {
        String realmName = this.proxyState.getRealm$realm().getPath();
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        long rowIndex = this.proxyState.getRow$realm().getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicRealmObject other = (DynamicRealmObject)o;
        String path = this.proxyState.getRealm$realm().getPath();
        String otherPath = other.proxyState.getRealm$realm().getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        String otherTableName = other.proxyState.getRow$realm().getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.proxyState.getRow$realm().getIndex() == other.proxyState.getRow$realm().getIndex();
    }

    public String toString() {
        String[] fields;
        if (this.proxyState.getRealm$realm() == null || !this.proxyState.getRow$realm().isAttached()) {
            return "Invalid object";
        }
        String className = Table.tableNameToClassName(this.proxyState.getRow$realm().getTable().getName());
        StringBuilder sb = new StringBuilder(className + " = [");
        for (String field : fields = this.getFieldNames()) {
            long columnIndex = this.proxyState.getRow$realm().getColumnIndex(field);
            RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
            sb.append("{");
            sb.append(field).append(":");
            switch (type) {
                case BOOLEAN: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : Boolean.valueOf(this.proxyState.getRow$realm().getBoolean(columnIndex)));
                    break;
                }
                case INTEGER: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : Long.valueOf(this.proxyState.getRow$realm().getLong(columnIndex)));
                    break;
                }
                case FLOAT: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : Float.valueOf(this.proxyState.getRow$realm().getFloat(columnIndex)));
                    break;
                }
                case DOUBLE: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : Double.valueOf(this.proxyState.getRow$realm().getDouble(columnIndex)));
                    break;
                }
                case STRING: {
                    sb.append(this.proxyState.getRow$realm().getString(columnIndex));
                    break;
                }
                case BINARY: {
                    sb.append(Arrays.toString(this.proxyState.getRow$realm().getBinaryByteArray(columnIndex)));
                    break;
                }
                case DATE: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : this.proxyState.getRow$realm().getDate(columnIndex));
                    break;
                }
                case OBJECT: {
                    sb.append(this.proxyState.getRow$realm().isNullLink(columnIndex) ? "null" : Table.tableNameToClassName(this.proxyState.getRow$realm().getTable().getLinkTarget(columnIndex).getName()));
                    break;
                }
                case LIST: {
                    String tableName = this.proxyState.getRow$realm().getTable().getLinkTarget(columnIndex).getName();
                    String targetType = Table.tableNameToClassName(tableName);
                    sb.append(String.format("RealmList<%s>[%s]", targetType, this.proxyState.getRow$realm().getLinkList(columnIndex).size()));
                    break;
                }
                default: {
                    sb.append("?");
                }
            }
            sb.append("}, ");
        }
        sb.replace(sb.length() - 2, sb.length(), "");
        sb.append("]");
        return sb.toString();
    }

    @Override
    public ProxyState realmGet$proxyState() {
        return this.proxyState;
    }
}

