/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import io.realm.BaseRealm;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.internal.IdentitySet;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.SharedGroup;
import io.realm.internal.async.BadVersionException;
import io.realm.internal.async.QueryUpdateTask;
import io.realm.internal.log.RealmLog;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

public final class HandlerController
implements Handler.Callback {
    static final int REALM_CHANGED = 14930352;
    static final int COMPLETED_UPDATE_ASYNC_QUERIES = 24157817;
    static final int COMPLETED_ASYNC_REALM_RESULTS = 39088169;
    static final int COMPLETED_ASYNC_REALM_OBJECT = 63245986;
    static final int REALM_ASYNC_BACKGROUND_EXCEPTION = 102334155;
    final CopyOnWriteArrayList<RealmChangeListener> changeListeners = new CopyOnWriteArrayList();
    final List<WeakReference<RealmChangeListener>> weakChangeListeners = new CopyOnWriteArrayList<WeakReference<RealmChangeListener>>();
    final BaseRealm realm;
    private boolean autoRefresh;
    private Future updateAsyncQueriesTask;
    private final ReferenceQueue<RealmResults<? extends RealmModel>> referenceQueueAsyncRealmResults = new ReferenceQueue();
    private final ReferenceQueue<RealmResults<? extends RealmModel>> referenceQueueSyncRealmResults = new ReferenceQueue();
    final ReferenceQueue<RealmModel> referenceQueueRealmObject = new ReferenceQueue();
    final Map<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>> asyncRealmResults = new IdentityHashMap<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>>();
    final Map<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>> emptyAsyncRealmObject = new IdentityHashMap<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>>();
    final IdentitySet<WeakReference<RealmResults<? extends RealmModel>>> syncRealmResults = new IdentitySet();
    final Map<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>> realmObjects = new IdentityHashMap<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>>();

    public HandlerController(BaseRealm realm) {
        this.realm = realm;
    }

    public boolean handleMessage(Message message) {
        if (this.realm.sharedGroupManager != null) {
            switch (message.what) {
                case 14930352: {
                    this.realmChanged();
                    break;
                }
                case 39088169: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncRealmResults(result);
                    break;
                }
                case 63245986: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncRealmObject(result);
                    break;
                }
                case 24157817: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncQueriesUpdate(result);
                    break;
                }
                case 102334155: {
                    throw (Error)message.obj;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message: " + message.what);
                }
            }
        }
        return true;
    }

    void addChangeListener(RealmChangeListener listener) {
        this.changeListeners.addIfAbsent(listener);
    }

    void addChangeListenerAsWeakReference(RealmChangeListener listener) {
        Iterator<WeakReference<RealmChangeListener>> iterator = this.weakChangeListeners.iterator();
        ArrayList<WeakReference<RealmChangeListener>> toRemoveList = null;
        boolean addListener = true;
        while (iterator.hasNext()) {
            WeakReference<RealmChangeListener> weakRef = iterator.next();
            RealmChangeListener weakListener = (RealmChangeListener)weakRef.get();
            if (weakListener == null) {
                if (toRemoveList == null) {
                    toRemoveList = new ArrayList<WeakReference<RealmChangeListener>>(this.weakChangeListeners.size());
                }
                toRemoveList.add(weakRef);
            }
            if (weakListener != listener) continue;
            addListener = false;
        }
        if (toRemoveList != null) {
            this.weakChangeListeners.removeAll(toRemoveList);
        }
        if (addListener) {
            this.weakChangeListeners.add(new WeakReference<RealmChangeListener>(listener));
        }
    }

    void removeWeakChangeListener(RealmChangeListener listener) {
        ArrayList<WeakReference<RealmChangeListener>> toRemoveList = null;
        for (int i = 0; i < this.weakChangeListeners.size(); ++i) {
            WeakReference<RealmChangeListener> weakRef = this.weakChangeListeners.get(i);
            RealmChangeListener weakListener = (RealmChangeListener)weakRef.get();
            if (weakListener != null && weakListener != listener) continue;
            if (toRemoveList == null) {
                toRemoveList = new ArrayList<WeakReference<RealmChangeListener>>(this.weakChangeListeners.size());
            }
            toRemoveList.add(weakRef);
        }
        this.weakChangeListeners.removeAll(toRemoveList);
    }

    void removeChangeListener(RealmChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    void removeAllChangeListeners() {
        this.changeListeners.clear();
    }

    private void notifyGlobalListeners() {
        Iterator<RealmChangeListener> iteratorStrongListeners = this.changeListeners.iterator();
        while (iteratorStrongListeners.hasNext() && !this.realm.isClosed()) {
            RealmChangeListener listener = iteratorStrongListeners.next();
            listener.onChange();
        }
        Iterator<WeakReference<RealmChangeListener>> iteratorWeakListeners = this.weakChangeListeners.iterator();
        ArrayList<WeakReference<RealmChangeListener>> toRemoveList = null;
        while (iteratorWeakListeners.hasNext() && !this.realm.isClosed()) {
            WeakReference<RealmChangeListener> weakRef = iteratorWeakListeners.next();
            RealmChangeListener listener = (RealmChangeListener)weakRef.get();
            if (listener == null) {
                if (toRemoveList == null) {
                    toRemoveList = new ArrayList<WeakReference<RealmChangeListener>>(this.weakChangeListeners.size());
                }
                toRemoveList.add(weakRef);
                continue;
            }
            listener.onChange();
        }
        if (toRemoveList != null) {
            this.weakChangeListeners.removeAll(toRemoveList);
        }
    }

    private void updateAsyncEmptyRealmObject() {
        Iterator<Map.Entry<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>>> iterator = this.emptyAsyncRealmObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>> next = iterator.next();
            if (next.getKey().get() != null) {
                Realm.asyncQueryExecutor.submit(QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).addObject(next.getKey(), next.getValue().handoverQueryPointer(), next.getValue().getArgument()).sendToHandler(this.realm.handler, 63245986).build());
                continue;
            }
            iterator.remove();
        }
    }

    void notifyAllListeners() {
        this.notifyGlobalListeners();
        this.notifyTypeBasedListeners();
        if (!this.realm.isClosed() && this.threadContainsAsyncEmptyRealmObject()) {
            this.updateAsyncEmptyRealmObject();
        }
    }

    private void notifyTypeBasedListeners() {
        this.notifyAsyncRealmResultsCallbacks();
        this.notifySyncRealmResultsCallbacks();
        this.notifyRealmObjectCallbacks();
    }

    private void notifyAsyncRealmResultsCallbacks() {
        this.notifyRealmResultsCallbacks(this.asyncRealmResults.keySet().iterator());
    }

    private void notifySyncRealmResultsCallbacks() {
        this.notifyRealmResultsCallbacks(this.syncRealmResults.keySet().iterator());
    }

    private void notifyRealmResultsCallbacks(Iterator<WeakReference<RealmResults<? extends RealmModel>>> iterator) {
        RealmResults realmResults;
        ArrayList<RealmResults> resultsToBeNotified = new ArrayList<RealmResults>();
        while (iterator.hasNext()) {
            WeakReference<RealmResults<? extends RealmModel>> weakRealmResults = iterator.next();
            realmResults = (RealmResults)weakRealmResults.get();
            if (realmResults == null) {
                iterator.remove();
                continue;
            }
            resultsToBeNotified.add(realmResults);
        }
        Iterator it = resultsToBeNotified.iterator();
        while (it.hasNext() && !this.realm.isClosed()) {
            realmResults = (RealmResults)it.next();
            realmResults.notifyChangeListeners();
        }
    }

    private void notifyRealmObjectCallbacks() {
        RealmObjectProxy realmObject;
        ArrayList<RealmObjectProxy> objectsToBeNotified = new ArrayList<RealmObjectProxy>();
        Iterator<WeakReference<RealmObjectProxy>> iterator = this.realmObjects.keySet().iterator();
        while (iterator.hasNext()) {
            WeakReference<RealmObjectProxy> weakRealmObject = iterator.next();
            realmObject = (RealmObjectProxy)weakRealmObject.get();
            if (realmObject == null) {
                iterator.remove();
                continue;
            }
            if (realmObject.realmGet$proxyState().getRow$realm().isAttached()) {
                objectsToBeNotified.add(realmObject);
                continue;
            }
            if (realmObject.realmGet$proxyState().getRow$realm() == Row.EMPTY_ROW) continue;
            iterator.remove();
        }
        Iterator it = objectsToBeNotified.iterator();
        while (it.hasNext() && !this.realm.isClosed()) {
            realmObject = (RealmObjectProxy)it.next();
            realmObject.realmGet$proxyState().notifyChangeListeners$realm();
        }
    }

    private void updateAsyncQueries() {
        if (this.updateAsyncQueriesTask != null && !this.updateAsyncQueriesTask.isDone()) {
            this.updateAsyncQueriesTask.cancel(true);
            Realm.asyncQueryExecutor.getQueue().remove(this.updateAsyncQueriesTask);
            RealmLog.d("REALM_CHANGED realm:" + this + " cancelling pending COMPLETED_UPDATE_ASYNC_QUERIES updates");
        }
        RealmLog.d("REALM_CHANGED realm:" + this + " updating async queries, total: " + this.asyncRealmResults.size());
        QueryUpdateTask.Builder.UpdateQueryStep updateQueryStep = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration());
        QueryUpdateTask.Builder.RealmResultsQueryStep realmResultsQueryStep = null;
        Iterator<Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>>> iterator = this.asyncRealmResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>> entry = iterator.next();
            WeakReference<RealmResults<? extends RealmModel>> weakReference = entry.getKey();
            RealmResults realmResults = (RealmResults)weakReference.get();
            if (realmResults == null) {
                iterator.remove();
                continue;
            }
            realmResultsQueryStep = updateQueryStep.add(weakReference, entry.getValue().handoverQueryPointer(), entry.getValue().getArgument());
        }
        if (realmResultsQueryStep != null) {
            QueryUpdateTask queryUpdateTask = realmResultsQueryStep.sendToHandler(this.realm.handler, 24157817).build();
            this.updateAsyncQueriesTask = Realm.asyncQueryExecutor.submit(queryUpdateTask);
        }
    }

    private void realmChanged() {
        this.deleteWeakReferences();
        if (this.threadContainsAsyncQueries()) {
            this.updateAsyncQueries();
        } else {
            RealmLog.d("REALM_CHANGED realm:" + this + " no async queries, advance_read");
            this.realm.sharedGroupManager.advanceRead();
            this.notifyAllListeners();
        }
    }

    private void completedAsyncRealmResults(QueryUpdateTask.Result result) {
        Set<WeakReference<RealmResults<? extends RealmModel>>> updatedTableViewsKeys = result.updatedTableViews.keySet();
        if (updatedTableViewsKeys.size() > 0) {
            WeakReference<RealmResults<? extends RealmModel>> weakRealmResults = updatedTableViewsKeys.iterator().next();
            RealmResults realmResults = (RealmResults)weakRealmResults.get();
            if (realmResults == null) {
                this.asyncRealmResults.remove(weakRealmResults);
                RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] realm:" + this + " RealmResults GC'd ignore results");
            } else {
                SharedGroup.VersionID callerVersionID = this.realm.sharedGroupManager.getVersion();
                int compare = callerVersionID.compareTo(result.versionID);
                if (compare == 0) {
                    if (!realmResults.isLoaded()) {
                        RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " same versions, using results (RealmResults is not loaded)");
                        realmResults.swapTableViewPointer(result.updatedTableViews.get(weakRealmResults));
                        realmResults.notifyChangeListeners();
                    } else {
                        RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " ignoring result the RealmResults (is already loaded)");
                    }
                } else if (compare > 0) {
                    if (!realmResults.isLoaded()) {
                        RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " caller is more advanced & RealmResults is not loaded, rerunning the query against the latest version");
                        RealmQuery<? extends RealmModel> query = this.asyncRealmResults.get(weakRealmResults);
                        QueryUpdateTask queryUpdateTask = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).add(weakRealmResults, query.handoverQueryPointer(), query.getArgument()).sendToHandler(this.realm.handler, 39088169).build();
                        Realm.asyncQueryExecutor.submit(queryUpdateTask);
                    } else {
                        RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " caller is more advanced & RealmResults is loaded ignore the outdated result");
                    }
                } else {
                    RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " caller thread behind worker thread, ignore results (a batch update will update everything including this query)");
                }
            }
        }
    }

    private void completedAsyncQueriesUpdate(QueryUpdateTask.Result result) {
        SharedGroup.VersionID callerVersionID = this.realm.sharedGroupManager.getVersion();
        int compare = callerVersionID.compareTo(result.versionID);
        if (compare > 0) {
            RealmLog.d("COMPLETED_UPDATE_ASYNC_QUERIES realm:" + this + " caller is more advanced, Looper will updates queries");
        } else {
            if (compare != 0) {
                RealmLog.d("COMPLETED_UPDATE_ASYNC_QUERIES realm:" + this + " caller is behind  advance_read");
                try {
                    this.realm.sharedGroupManager.advanceRead(result.versionID);
                }
                catch (BadVersionException e) {
                    throw new IllegalStateException("Failed to advance Caller Realm to Worker Realm version", e);
                }
            }
            ArrayList<RealmResults> callbacksToNotify = new ArrayList<RealmResults>(result.updatedTableViews.size());
            for (Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, Long> entry : result.updatedTableViews.entrySet()) {
                WeakReference<RealmResults<? extends RealmModel>> weakRealmResults = entry.getKey();
                RealmResults realmResults = (RealmResults)weakRealmResults.get();
                if (realmResults == null) {
                    this.asyncRealmResults.remove(weakRealmResults);
                    continue;
                }
                realmResults.swapTableViewPointer(entry.getValue());
                callbacksToNotify.add(realmResults);
                RealmLog.d("COMPLETED_UPDATE_ASYNC_QUERIES realm:" + this + " updating RealmResults " + weakRealmResults);
            }
            for (RealmResults realmResults : callbacksToNotify) {
                realmResults.notifyChangeListeners();
            }
            this.notifyGlobalListeners();
            this.notifySyncRealmResultsCallbacks();
            this.notifyRealmObjectCallbacks();
            this.updateAsyncQueriesTask = null;
        }
    }

    private void completedAsyncRealmObject(QueryUpdateTask.Result result) {
        WeakReference<RealmObjectProxy> realmObjectWeakReference;
        RealmObjectProxy proxy;
        Set<WeakReference<RealmObjectProxy>> updatedRowKey = result.updatedRow.keySet();
        if (updatedRowKey.size() > 0 && (proxy = (RealmObjectProxy)(realmObjectWeakReference = updatedRowKey.iterator().next()).get()) != null) {
            SharedGroup.VersionID callerVersionID = this.realm.sharedGroupManager.getVersion();
            int compare = callerVersionID.compareTo(result.versionID);
            if (compare == 0) {
                long rowPointer = result.updatedRow.get(realmObjectWeakReference);
                if (rowPointer != 0L && this.emptyAsyncRealmObject.containsKey(realmObjectWeakReference)) {
                    this.emptyAsyncRealmObject.remove(realmObjectWeakReference);
                    this.realmObjects.put(realmObjectWeakReference, null);
                }
                proxy.realmGet$proxyState().onCompleted$realm(rowPointer);
                proxy.realmGet$proxyState().notifyChangeListeners$realm();
            } else if (compare > 0) {
                if (RealmObject.isValid(proxy)) {
                    RealmLog.d("[COMPLETED_ASYNC_REALM_OBJECT " + proxy + "] , realm:" + this + " RealmObject is already loaded, just notify it.");
                    proxy.realmGet$proxyState().notifyChangeListeners$realm();
                } else {
                    RealmLog.d("[COMPLETED_ASYNC_REALM_OBJECT " + proxy + "] , realm:" + this + " RealmObject is not loaded yet. Rerun the query.");
                    RealmQuery<? extends RealmModel> realmQuery = this.realmObjects.get(realmObjectWeakReference);
                    if (realmQuery == null) {
                        realmQuery = this.emptyAsyncRealmObject.get(realmObjectWeakReference);
                    }
                    QueryUpdateTask queryUpdateTask = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).addObject(realmObjectWeakReference, realmQuery.handoverQueryPointer(), realmQuery.getArgument()).sendToHandler(this.realm.handler, 63245986).build();
                    Realm.asyncQueryExecutor.submit(queryUpdateTask);
                }
            } else {
                throw new IllegalStateException("Caller thread behind the Worker thread");
            }
        }
    }

    private boolean threadContainsAsyncQueries() {
        boolean isEmpty = true;
        Iterator<Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>>> iterator = this.asyncRealmResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmResults<? extends RealmModel>>, RealmQuery<? extends RealmModel>> next = iterator.next();
            if (next.getKey().get() == null) {
                iterator.remove();
                continue;
            }
            isEmpty = false;
        }
        return !isEmpty;
    }

    boolean threadContainsAsyncEmptyRealmObject() {
        boolean isEmpty = true;
        Iterator<Map.Entry<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>>> iterator = this.emptyAsyncRealmObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmObjectProxy>, RealmQuery<? extends RealmModel>> next = iterator.next();
            if (next.getKey().get() == null) {
                iterator.remove();
                continue;
            }
            isEmpty = false;
        }
        return !isEmpty;
    }

    private void deleteWeakReferences() {
        Reference<RealmModel> weakReferenceObject;
        Reference<RealmResults<? extends RealmModel>> weakReferenceResults;
        while ((weakReferenceResults = this.referenceQueueAsyncRealmResults.poll()) != null) {
            this.asyncRealmResults.remove(weakReferenceResults);
        }
        while ((weakReferenceResults = this.referenceQueueSyncRealmResults.poll()) != null) {
            this.syncRealmResults.remove(weakReferenceResults);
        }
        while ((weakReferenceObject = this.referenceQueueRealmObject.poll()) != null) {
            this.realmObjects.remove(weakReferenceObject);
        }
    }

    WeakReference<RealmResults<? extends RealmModel>> addToAsyncRealmResults(RealmResults<? extends RealmModel> realmResults, RealmQuery<? extends RealmModel> realmQuery) {
        WeakReference<RealmResults<? extends RealmModel>> weakRealmResults = new WeakReference<RealmResults<? extends RealmModel>>(realmResults, this.referenceQueueAsyncRealmResults);
        this.asyncRealmResults.put(weakRealmResults, realmQuery);
        return weakRealmResults;
    }

    void addToRealmResults(RealmResults<? extends RealmModel> realmResults) {
        WeakReference<RealmResults<? extends RealmModel>> realmResultsWeakReference = new WeakReference<RealmResults<? extends RealmModel>>(realmResults, this.referenceQueueSyncRealmResults);
        this.syncRealmResults.add(realmResultsWeakReference);
    }

    <E extends RealmModel> void addToRealmObjects(E realmobject) {
        this.realmObjects.put(new WeakReference<RealmObjectProxy>((RealmObjectProxy)realmobject), null);
    }

    <E extends RealmObjectProxy> WeakReference<RealmObjectProxy> addToAsyncRealmObject(E realmObject, RealmQuery<? extends RealmModel> realmQuery) {
        WeakReference<RealmModel> realmObjectWeakReference = new WeakReference<RealmModel>(realmObject, this.referenceQueueRealmObject);
        this.realmObjects.put(realmObjectWeakReference, realmQuery);
        return realmObjectWeakReference;
    }

    void removeFromAsyncRealmObject(WeakReference<RealmObjectProxy> realmObjectWeakReference) {
        this.realmObjects.remove(realmObjectWeakReference);
    }

    void addToEmptyAsyncRealmObject(WeakReference<RealmObjectProxy> realmObjectWeakReference, RealmQuery<? extends RealmModel> realmQuery) {
        this.emptyAsyncRealmObject.put(realmObjectWeakReference, realmQuery);
    }

    public void refreshSynchronousTableViews() {
        Iterator iterator = this.syncRealmResults.keySet().iterator();
        while (iterator.hasNext()) {
            WeakReference weakRealmResults = (WeakReference)iterator.next();
            RealmResults realmResults = (RealmResults)weakRealmResults.get();
            if (realmResults == null) {
                iterator.remove();
                continue;
            }
            realmResults.syncIfNeeded();
        }
    }

    public void setAutoRefresh(boolean autoRefresh) {
        if (autoRefresh && Looper.myLooper() == null) {
            throw new IllegalStateException("Cannot enabled autorefresh on a non-looper thread.");
        }
        this.autoRefresh = autoRefresh;
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefresh;
    }

    public void notifyCurrentThreadRealmChanged() {
        if (this.realm != null) {
            this.realm.handler.sendEmptyMessage(14930352);
        }
    }
}

