/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.RealmChangeListener;
import io.realm.RealmModel;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.log.RealmLog;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

public final class ProxyState {
    private String className;
    private Class<? extends RealmModel> clazzName;
    private Row row;
    private BaseRealm realm;
    private final List<RealmChangeListener> listeners = new CopyOnWriteArrayList<RealmChangeListener>();
    private Future<Long> pendingQuery;
    private boolean isCompleted = false;
    protected long currentTableVersion = -1L;

    public ProxyState() {
    }

    public ProxyState(Class<? extends RealmModel> clazzName) {
        this.clazzName = clazzName;
    }

    public void setPendingQuery$realm(Future<Long> pendingQuery) {
        this.pendingQuery = pendingQuery;
        if (this.isLoaded()) {
            this.onCompleted$realm();
        }
    }

    public BaseRealm getRealm$realm() {
        return this.realm;
    }

    public void setRealm$realm(BaseRealm realm) {
        this.realm = realm;
    }

    public Row getRow$realm() {
        return this.row;
    }

    public void setRow$realm(Row row) {
        this.row = row;
    }

    public Object getPendingQuery$realm() {
        return this.pendingQuery;
    }

    public boolean isCompleted$realm() {
        return this.isCompleted;
    }

    public boolean onCompleted$realm() {
        try {
            Long handoverResult = this.pendingQuery.get();
            if (handoverResult != 0L) {
                this.onCompleted$realm(handoverResult);
                this.notifyChangeListeners$realm();
            } else {
                this.isCompleted = true;
            }
        }
        catch (Exception e) {
            RealmLog.d(e.getMessage());
            return false;
        }
        return true;
    }

    public List<RealmChangeListener> getListeners$realm() {
        return this.listeners;
    }

    public void onCompleted$realm(long handoverRowPointer) {
        if (handoverRowPointer == 0L) {
            this.isCompleted = true;
        } else if (!this.isCompleted || this.row == Row.EMPTY_ROW) {
            this.isCompleted = true;
            long nativeRowPointer = TableQuery.nativeImportHandoverRowIntoSharedGroup(handoverRowPointer, this.realm.sharedGroupManager.getNativePointer());
            Table table = this.getTable();
            this.row = table.getUncheckedRowByPointer(nativeRowPointer);
        }
    }

    void notifyChangeListeners$realm() {
        if (!this.listeners.isEmpty()) {
            boolean notify = false;
            Table table = this.row.getTable();
            if (table == null) {
                notify = true;
            } else {
                long version = table.getVersion();
                if (this.currentTableVersion != version) {
                    this.currentTableVersion = version;
                    notify = true;
                }
            }
            if (notify) {
                for (RealmChangeListener listener : this.listeners) {
                    listener.onChange();
                }
            }
        }
    }

    public void setTableVersion$realm() {
        if (this.row.getTable() != null) {
            this.currentTableVersion = this.row.getTable().getVersion();
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }

    private Table getTable() {
        if (this.className != null) {
            return this.getRealm$realm().schema.getTable(this.className);
        }
        return this.getRealm$realm().schema.getTable(this.clazzName);
    }

    private boolean isLoaded() {
        this.realm.checkIfValid();
        return this.getPendingQuery$realm() == null || this.isCompleted$realm();
    }
}

