/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Looper;
import android.util.JsonReader;
import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.RealmAsyncTask;
import io.realm.RealmCache;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmIOException;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnIndices;
import io.realm.internal.ColumnInfo;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Table;
import io.realm.internal.TableView;
import io.realm.internal.Util;
import io.realm.internal.log.RealmLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;

public final class Realm
extends BaseRealm {
    public static final String DEFAULT_REALM_NAME = "default.realm";
    private final Map<Class<? extends RealmModel>, Table> classToTable = new HashMap<Class<? extends RealmModel>, Table>();
    private static RealmConfiguration defaultConfiguration;

    Realm(RealmConfiguration configuration, boolean autoRefresh) {
        super(configuration, autoRefresh);
    }

    public Observable<Realm> asObservable() {
        return this.configuration.getRxFactory().from(this);
    }

    protected void finalize() throws Throwable {
        if (this.sharedGroupManager != null && this.sharedGroupManager.isOpen()) {
            RealmLog.w("Remember to call close() on all Realm instances. Realm " + this.configuration.getPath() + " is being finalized without being closed, " + "this can lead to running out of native memory.");
        }
        super.finalize();
    }

    public static Realm getInstance(Context context) {
        return Realm.getInstance(new RealmConfiguration.Builder(context).name(DEFAULT_REALM_NAME).build());
    }

    public static Realm getDefaultInstance() {
        if (defaultConfiguration == null) {
            throw new NullPointerException("No default RealmConfiguration was found. Call setDefaultConfiguration() first");
        }
        return RealmCache.createRealmOrGetFromCache(defaultConfiguration, Realm.class);
    }

    public static Realm getInstance(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return RealmCache.createRealmOrGetFromCache(configuration, Realm.class);
    }

    public static void setDefaultConfiguration(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        defaultConfiguration = configuration;
    }

    public static void removeDefaultConfiguration() {
        defaultConfiguration = null;
    }

    static Realm createInstance(RealmConfiguration configuration, ColumnIndices columnIndices) {
        try {
            return Realm.createAndValidate(configuration, columnIndices);
        }
        catch (RealmMigrationNeededException e) {
            if (configuration.shouldDeleteRealmIfMigrationNeeded()) {
                Realm.deleteRealm(configuration);
            } else {
                try {
                    Realm.migrateRealm(configuration);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RealmIOException(fileNotFoundException);
                }
            }
            return Realm.createAndValidate(configuration, columnIndices);
        }
    }

    static Realm createAndValidate(RealmConfiguration configuration, ColumnIndices columnIndices) {
        boolean autoRefresh = Looper.myLooper() != null;
        Realm realm = new Realm(configuration, autoRefresh);
        long currentVersion = realm.getVersion();
        long requiredVersion = configuration.getSchemaVersion();
        if (currentVersion != -1L && currentVersion < requiredVersion && columnIndices == null) {
            realm.doClose();
            throw new RealmMigrationNeededException(configuration.getPath(), String.format("Realm on disk need to migrate from v%s to v%s", currentVersion, requiredVersion));
        }
        if (currentVersion != -1L && requiredVersion < currentVersion && columnIndices == null) {
            realm.doClose();
            throw new IllegalArgumentException(String.format("Realm on disk is newer than the one specified: v%s vs. v%s", currentVersion, requiredVersion));
        }
        if (columnIndices == null) {
            try {
                Realm.initializeRealm(realm);
            }
            catch (RuntimeException e) {
                realm.doClose();
                throw e;
            }
        } else {
            realm.schema.columnIndices = columnIndices;
        }
        return realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeRealm(Realm realm) {
        long version = realm.getVersion();
        boolean commitNeeded = false;
        try {
            Transaction transaction;
            realm.beginTransaction();
            if (version == -1L) {
                commitNeeded = true;
                realm.setVersion(realm.configuration.getSchemaVersion());
            }
            RealmProxyMediator mediator = realm.configuration.getSchemaMediator();
            Set<Class<? extends RealmModel>> modelClasses = mediator.getModelClasses();
            HashMap<Class<? extends RealmModel>, ColumnInfo> columnInfoMap = new HashMap<Class<? extends RealmModel>, ColumnInfo>(modelClasses.size());
            for (Class<? extends RealmModel> modelClass : modelClasses) {
                if (version == -1L) {
                    mediator.createTable(modelClass, realm.sharedGroupManager.getTransaction());
                }
                columnInfoMap.put(modelClass, mediator.validateTable(modelClass, realm.sharedGroupManager.getTransaction()));
            }
            realm.schema.columnIndices = new ColumnIndices(columnInfoMap);
            if (version == -1L && (transaction = realm.getConfiguration().getInitialDataTransaction()) != null) {
                transaction.execute(realm);
            }
        }
        finally {
            if (commitNeeded) {
                realm.commitTransaction(false, null);
            } else {
                realm.cancelTransaction();
            }
        }
    }

    public <E extends RealmModel> void createAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), false);
                continue;
            }
            catch (Exception e) {
                throw new RealmException("Could not map Json", e);
            }
        }
    }

    public <E extends RealmModel> void createOrUpdateAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
                continue;
            }
            catch (Exception e) {
                throw new RealmException("Could not map Json", e);
            }
        }
    }

    public <E extends RealmModel> void createAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        try {
            arr = new JSONArray(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createAllFromJson(clazz, arr);
    }

    public <E extends RealmModel> void createOrUpdateAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            arr = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createOrUpdateAllFromJson(clazz, arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmModel> void createAllFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        if (clazz == null || inputStream == null) {
            return;
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));){
            reader.beginArray();
            while (reader.hasNext()) {
                this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
            }
            reader.endArray();
        }
    }

    @TargetApi(value=11)
    public <E extends RealmModel> void createOrUpdateAllFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        try (Scanner scanner = null;){
            scanner = this.getFullStringScanner(in);
            JSONArray json = new JSONArray(scanner.next());
            for (int i = 0; i < json.length(); ++i) {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
            }
        }
    }

    public <E extends RealmModel> E createObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        try {
            return this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, false);
        }
        catch (Exception e) {
            throw new RealmException("Could not map Json", e);
        }
    }

    public <E extends RealmModel> E createOrUpdateObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            E realmObject = this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, true);
            this.handlerController.addToRealmObjects(realmObject);
            return realmObject;
        }
        catch (JSONException e) {
            throw new RealmException("Could not map Json", e);
        }
    }

    public <E extends RealmModel> E createObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        try {
            obj = new JSONObject(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createObjectFromJson(clazz, obj);
    }

    public <E extends RealmModel> E createOrUpdateObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            obj = new JSONObject(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createOrUpdateObjectFromJson(clazz, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmModel> E createObjectFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        E realmObject;
        if (clazz == null || inputStream == null) {
            return null;
        }
        Table table = this.getTable(clazz);
        if (table.hasPrimaryKey()) {
            try (Scanner scanner = null;){
                scanner = this.getFullStringScanner(inputStream);
                JSONObject json = new JSONObject(scanner.next());
                realmObject = this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, false);
            }
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));){
            realmObject = this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
        }
        return realmObject;
    }

    @TargetApi(value=11)
    public <E extends RealmModel> E createOrUpdateObjectFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        try (Scanner scanner = null;){
            scanner = this.getFullStringScanner(in);
            JSONObject json = new JSONObject(scanner.next());
            E e = this.createOrUpdateObjectFromJson(clazz, json);
            return e;
        }
    }

    private Scanner getFullStringScanner(InputStream in) {
        return new Scanner(in, "UTF-8").useDelimiter("\\A");
    }

    public <E extends RealmModel> E createObject(Class<E> clazz) {
        this.checkIfValid();
        Table table = this.getTable(clazz);
        long rowIndex = table.addEmptyRow();
        return this.get(clazz, rowIndex);
    }

    <E extends RealmModel> E createObject(Class<E> clazz, Object primaryKeyValue) {
        Table table = this.getTable(clazz);
        long rowIndex = table.addEmptyRowWithPrimaryKey(primaryKeyValue);
        return this.get(clazz, rowIndex);
    }

    void remove(Class<? extends RealmModel> clazz, long objectIndex) {
        this.getTable(clazz).moveLastOver(objectIndex);
    }

    public <E extends RealmModel> E copyToRealm(E object) {
        this.checkNotNullObject(object);
        return this.copyOrUpdate(object, false);
    }

    public <E extends RealmModel> E copyToRealmOrUpdate(E object) {
        this.checkNotNullObject(object);
        this.checkHasPrimaryKey(object.getClass());
        return this.copyOrUpdate(object, true);
    }

    public <E extends RealmModel> List<E> copyToRealm(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList();
        }
        ArrayList<RealmModel> realmObjects = new ArrayList<RealmModel>();
        for (RealmModel object : objects) {
            realmObjects.add(this.copyToRealm(object));
        }
        return realmObjects;
    }

    public <E extends RealmModel> List<E> copyToRealmOrUpdate(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList(0);
        }
        ArrayList<RealmModel> realmObjects = new ArrayList<RealmModel>();
        for (RealmModel object : objects) {
            realmObjects.add(this.copyToRealmOrUpdate(object));
        }
        return realmObjects;
    }

    public <E extends RealmModel> List<E> copyFromRealm(Iterable<E> realmObjects) {
        return this.copyFromRealm((E)((Object)realmObjects), Integer.MAX_VALUE);
    }

    public <E extends RealmModel> List<E> copyFromRealm(Iterable<E> realmObjects, int maxDepth) {
        this.checkMaxDepth(maxDepth);
        if (realmObjects == null) {
            return new ArrayList(0);
        }
        ArrayList<RealmModel> standaloneObjects = new ArrayList<RealmModel>();
        HashMap<RealmModel, RealmObjectProxy.CacheData<RealmModel>> listCache = new HashMap<RealmModel, RealmObjectProxy.CacheData<RealmModel>>();
        for (RealmModel object : realmObjects) {
            this.checkValidObjectForDetach(object);
            standaloneObjects.add(this.createDetachedCopy(object, maxDepth, listCache));
        }
        return standaloneObjects;
    }

    public <E extends RealmModel> E copyFromRealm(E realmObject) {
        return this.copyFromRealm(realmObject, Integer.MAX_VALUE);
    }

    public <E extends RealmModel> E copyFromRealm(E realmObject, int maxDepth) {
        this.checkMaxDepth(maxDepth);
        this.checkValidObjectForDetach(realmObject);
        return this.createDetachedCopy(realmObject, maxDepth, new HashMap<RealmModel, RealmObjectProxy.CacheData<RealmModel>>());
    }

    boolean contains(Class<? extends RealmModel> clazz) {
        return this.configuration.getSchemaMediator().getModelClasses().contains(clazz);
    }

    public <E extends RealmModel> RealmQuery<E> where(Class<E> clazz) {
        this.checkIfValid();
        return RealmQuery.createQuery(this, clazz);
    }

    public <E extends RealmModel> RealmResults<E> allObjects(Class<E> clazz) {
        return this.where(clazz).findAll();
    }

    public <E extends RealmModel> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName, Sort sortOrder) {
        this.checkIfValid();
        Table table = this.getTable(clazz);
        long columnIndex = this.schema.columnIndices.getColumnIndex(clazz, fieldName);
        if (columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        TableView tableView = table.getSortedView(columnIndex, sortOrder);
        return RealmResults.createFromTableOrView(this, tableView, clazz);
    }

    public <E extends RealmModel> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.allObjectsSorted(clazz, new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    public <E extends RealmModel> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2, String fieldName3, Sort sortOrder3) {
        return this.allObjectsSorted(clazz, new String[]{fieldName1, fieldName2, fieldName3}, new Sort[]{sortOrder1, sortOrder2, sortOrder3});
    }

    public <E extends RealmModel> RealmResults<E> allObjectsSorted(Class<E> clazz, String[] fieldNames, Sort[] sortOrders) {
        this.checkAllObjectsSortedParameters(fieldNames, sortOrders);
        Table table = this.getTable(clazz);
        TableView tableView = this.doMultiFieldSort(fieldNames, sortOrders, table);
        return RealmResults.createFromTableOrView(this, tableView, clazz);
    }

    public <E extends RealmModel> RealmResults<E> distinct(Class<E> clazz, String fieldName) {
        this.checkIfValid();
        Table table = this.schema.getTable(clazz);
        long columnIndex = RealmQuery.getAndValidateDistinctColumnIndex(fieldName, table);
        TableView tableView = table.getDistinctView(columnIndex);
        return RealmResults.createFromTableOrView(this, tableView, clazz);
    }

    public <E extends RealmModel> RealmResults<E> distinctAsync(Class<E> clazz, String fieldName) {
        this.checkIfValid();
        return this.where(clazz).distinctAsync(fieldName);
    }

    public <E extends RealmObject> RealmResults<E> distinct(Class<E> clazz, String firstFieldName, String ... remainingFieldNames) {
        this.checkIfValid();
        return this.where(clazz).distinct(firstFieldName, remainingFieldNames);
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (Throwable e) {
            if (this.isInTransaction()) {
                this.cancelTransaction();
            } else {
                RealmLog.w("Could not cancel transaction, not currently in a transaction.");
            }
            throw e;
        }
    }

    @Deprecated
    public RealmAsyncTask executeTransaction(final Transaction transaction, final Transaction.Callback callback) {
        this.checkIfValid();
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        if (callback != null && this.handler == null) {
            throw new IllegalStateException("Your Realm is opened from a thread without a Looper and you provided a callback, we need a Handler to invoke your callback");
        }
        final RealmConfiguration realmConfiguration = this.getConfiguration();
        Future<?> pendingQuery = asyncQueryExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Realm bgRealm;
                Exception[] exception;
                boolean transactionCommitted;
                block29: {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    transactionCommitted = false;
                    exception = new Exception[1];
                    bgRealm = Realm.getInstance(realmConfiguration);
                    bgRealm.beginTransaction();
                    try {
                        transaction.execute(bgRealm);
                        if (Thread.currentThread().isInterrupted()) break block29;
                        bgRealm.commitTransaction(false, new Runnable(){

                            @Override
                            public void run() {
                                bgRealm.close();
                            }
                        });
                        transactionCommitted = true;
                    }
                    catch (Exception e) {
                        try {
                            exception[0] = e;
                        }
                        catch (Throwable throwable) {
                            if (!bgRealm.isClosed()) {
                                if (bgRealm.isInTransaction()) {
                                    bgRealm.cancelTransaction();
                                } else if (exception[0] != null) {
                                    RealmLog.w("Could not cancel transaction, not currently in a transaction.");
                                }
                                bgRealm.close();
                            }
                            if (callback != null && Realm.this.handler != null && !Thread.currentThread().isInterrupted() && Realm.this.handler.getLooper().getThread().isAlive()) {
                                if (transactionCommitted) {
                                    Realm.this.handler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            callback.onSuccess();
                                        }
                                    });
                                } else if (exception[0] != null) {
                                    Realm.this.handler.post(new Runnable(exception){
                                        final /* synthetic */ Exception[] val$exception;
                                        {
                                            this.val$exception = exceptionArray;
                                        }

                                        @Override
                                        public void run() {
                                            callback.onError(this.val$exception[0]);
                                        }
                                    });
                                }
                            }
                            throw throwable;
                        }
                        if (!bgRealm.isClosed()) {
                            if (bgRealm.isInTransaction()) {
                                bgRealm.cancelTransaction();
                            } else if (exception[0] != null) {
                                RealmLog.w("Could not cancel transaction, not currently in a transaction.");
                            }
                            bgRealm.close();
                        }
                        if (callback != null && Realm.this.handler != null && !Thread.currentThread().isInterrupted() && Realm.this.handler.getLooper().getThread().isAlive()) {
                            if (transactionCommitted) {
                                Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                            } else if (exception[0] != null) {
                                Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                    }
                }
                if (!bgRealm.isClosed()) {
                    if (bgRealm.isInTransaction()) {
                        bgRealm.cancelTransaction();
                    } else if (exception[0] != null) {
                        RealmLog.w("Could not cancel transaction, not currently in a transaction.");
                    }
                    bgRealm.close();
                }
                if (callback != null && Realm.this.handler != null && !Thread.currentThread().isInterrupted() && Realm.this.handler.getLooper().getThread().isAlive()) {
                    if (transactionCommitted) {
                        Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                    } else if (exception[0] != null) {
                        Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            }
        });
        return new RealmAsyncTask(pendingQuery);
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction) {
        return this.executeTransactionAsync(transaction, null, null);
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction, Transaction.OnSuccess onSuccess) {
        if (onSuccess == null) {
            throw new IllegalArgumentException("onSuccess callback can't be null");
        }
        return this.executeTransactionAsync(transaction, onSuccess, null);
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction, Transaction.OnError onError) {
        if (onError == null) {
            throw new IllegalArgumentException("onError callback can't be null");
        }
        return this.executeTransactionAsync(transaction, null, onError);
    }

    public RealmAsyncTask executeTransactionAsync(final Transaction transaction, final Transaction.OnSuccess onSuccess, final Transaction.OnError onError) {
        this.checkIfValid();
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        if ((onSuccess != null || onError != null) && this.handler == null) {
            throw new IllegalStateException("Your Realm is opened from a thread without a Looper and you provided a callback, we need a Handler to invoke your callback");
        }
        final RealmConfiguration realmConfiguration = this.getConfiguration();
        Future<?> pendingQuery = asyncQueryExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Realm bgRealm;
                Throwable[] exception;
                boolean transactionCommitted;
                block47: {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    transactionCommitted = false;
                    exception = new Throwable[1];
                    bgRealm = Realm.getInstance(realmConfiguration);
                    bgRealm.beginTransaction();
                    try {
                        transaction.execute(bgRealm);
                        if (Thread.currentThread().isInterrupted()) break block47;
                        bgRealm.commitTransaction(false, new Runnable(){

                            @Override
                            public void run() {
                                bgRealm.close();
                            }
                        });
                        transactionCommitted = true;
                    }
                    catch (Throwable e) {
                        try {
                            exception[0] = e;
                        }
                        catch (Throwable throwable) {
                            if (!bgRealm.isClosed()) {
                                if (bgRealm.isInTransaction()) {
                                    bgRealm.cancelTransaction();
                                } else if (exception[0] != null) {
                                    RealmLog.w("Could not cancel transaction, not currently in a transaction.");
                                }
                                bgRealm.close();
                            }
                            Throwable backgroundException = exception[0];
                            if (Realm.this.handler != null && !Thread.currentThread().isInterrupted() && Realm.this.handler.getLooper().getThread().isAlive()) {
                                if (onSuccess != null && transactionCommitted) {
                                    Realm.this.handler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            onSuccess.onSuccess();
                                        }
                                    });
                                }
                                if (backgroundException != null) {
                                    if (onError != null) {
                                        Realm.this.handler.post(new Runnable(backgroundException){
                                            final /* synthetic */ Throwable val$backgroundException;
                                            {
                                                this.val$backgroundException = throwable;
                                            }

                                            @Override
                                            public void run() {
                                                onError.onError(this.val$backgroundException);
                                            }
                                        });
                                    } else {
                                        Realm.this.handler.post(new Runnable(backgroundException){
                                            final /* synthetic */ Throwable val$backgroundException;
                                            {
                                                this.val$backgroundException = throwable;
                                            }

                                            @Override
                                            public void run() {
                                                if (this.val$backgroundException instanceof RuntimeException) {
                                                    throw (RuntimeException)this.val$backgroundException;
                                                }
                                                if (this.val$backgroundException instanceof Exception) {
                                                    throw new RealmException("Async transaction failed", this.val$backgroundException);
                                                }
                                                if (this.val$backgroundException instanceof Error) {
                                                    throw (Error)this.val$backgroundException;
                                                }
                                            }
                                        });
                                    }
                                }
                            } else if (backgroundException != null) {
                                if (backgroundException instanceof RuntimeException) {
                                    throw (RuntimeException)backgroundException;
                                }
                                if (backgroundException instanceof Exception) {
                                    throw new RealmException("Async transaction failed", backgroundException);
                                }
                                if (backgroundException instanceof Error) {
                                    throw (Error)backgroundException;
                                }
                            }
                            throw throwable;
                        }
                        if (!bgRealm.isClosed()) {
                            if (bgRealm.isInTransaction()) {
                                bgRealm.cancelTransaction();
                            } else if (exception[0] != null) {
                                RealmLog.w("Could not cancel transaction, not currently in a transaction.");
                            }
                            bgRealm.close();
                        }
                        Throwable backgroundException = exception[0];
                        if (Realm.this.handler != null && !Thread.currentThread().isInterrupted() && Realm.this.handler.getLooper().getThread().isAlive()) {
                            if (onSuccess != null && transactionCommitted) {
                                Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                            }
                            if (backgroundException != null) {
                                if (onError != null) {
                                    Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                                } else {
                                    Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                                }
                            }
                        } else if (backgroundException != null) {
                            if (backgroundException instanceof RuntimeException) {
                                throw (RuntimeException)backgroundException;
                            }
                            if (backgroundException instanceof Exception) {
                                throw new RealmException("Async transaction failed", backgroundException);
                            }
                            if (backgroundException instanceof Error) {
                                throw (Error)backgroundException;
                            }
                        }
                    }
                }
                if (!bgRealm.isClosed()) {
                    if (bgRealm.isInTransaction()) {
                        bgRealm.cancelTransaction();
                    } else if (exception[0] != null) {
                        RealmLog.w("Could not cancel transaction, not currently in a transaction.");
                    }
                    bgRealm.close();
                }
                Throwable backgroundException = exception[0];
                if (Realm.this.handler != null && !Thread.currentThread().isInterrupted() && Realm.this.handler.getLooper().getThread().isAlive()) {
                    if (onSuccess != null && transactionCommitted) {
                        Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                    }
                    if (backgroundException != null) {
                        if (onError != null) {
                            Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                        } else {
                            Realm.this.handler.post(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                } else if (backgroundException != null) {
                    if (backgroundException instanceof RuntimeException) {
                        throw (RuntimeException)backgroundException;
                    }
                    if (backgroundException instanceof Exception) {
                        throw new RealmException("Async transaction failed", backgroundException);
                    }
                    if (backgroundException instanceof Error) {
                        throw (Error)backgroundException;
                    }
                }
            }
        });
        return new RealmAsyncTask(pendingQuery);
    }

    @Deprecated
    public void clear(Class<? extends RealmModel> clazz) {
        this.delete(clazz);
    }

    public void delete(Class<? extends RealmModel> clazz) {
        this.checkIfValid();
        this.getTable(clazz).clear();
    }

    private <E extends RealmModel> E copyOrUpdate(E object, boolean update) {
        this.checkIfValid();
        return this.configuration.getSchemaMediator().copyOrUpdate(this, object, update, new HashMap<RealmModel, RealmObjectProxy>());
    }

    private <E extends RealmModel> E createDetachedCopy(E object, int maxDepth, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> cache) {
        this.checkIfValid();
        return this.configuration.getSchemaMediator().createDetachedCopy(object, maxDepth, cache);
    }

    private <E extends RealmModel> void checkNotNullObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Null objects cannot be copied into Realm.");
        }
    }

    private void checkHasPrimaryKey(Class<? extends RealmModel> clazz) {
        if (!this.getTable(clazz).hasPrimaryKey()) {
            throw new IllegalArgumentException("A RealmObject with no @PrimaryKey cannot be updated: " + clazz.toString());
        }
    }

    private void checkMaxDepth(int maxDepth) {
        if (maxDepth < 0) {
            throw new IllegalArgumentException("maxDepth must be > 0. It was: " + maxDepth);
        }
    }

    private <E extends RealmModel> void checkValidObjectForDetach(E realmObject) {
        if (realmObject == null) {
            throw new IllegalArgumentException("Null objects cannot be copied from Realm.");
        }
        if (!RealmObject.isValid(realmObject)) {
            throw new IllegalArgumentException("RealmObject is not valid, so it cannot be copied.");
        }
        if (realmObject instanceof DynamicRealmObject) {
            throw new IllegalArgumentException("DynamicRealmObject cannot be copied from Realm.");
        }
    }

    public static void migrateRealm(RealmConfiguration configuration) throws FileNotFoundException {
        Realm.migrateRealm(configuration, null);
    }

    public static void migrateRealm(RealmConfiguration configuration, RealmMigration migration) throws FileNotFoundException {
        BaseRealm.migrateRealm(configuration, migration, new BaseRealm.MigrationCallback(){

            @Override
            public void migrationComplete() {
            }
        });
    }

    public static boolean deleteRealm(RealmConfiguration configuration) {
        return BaseRealm.deleteRealm(configuration);
    }

    public static boolean compactRealm(RealmConfiguration configuration) {
        return BaseRealm.compactRealm(configuration);
    }

    static String getCanonicalPath(File realmFile) {
        try {
            return realmFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RealmException("Could not resolve the canonical path to the Realm file: " + realmFile.getAbsolutePath());
        }
    }

    Table getTable(Class<? extends RealmModel> clazz) {
        Table table = this.classToTable.get(clazz);
        if (table == null) {
            clazz = Util.getOriginalModelClass(clazz);
            table = this.sharedGroupManager.getTable(this.configuration.getSchemaMediator().getTableName(clazz));
            this.classToTable.put(clazz, table);
        }
        return table;
    }

    public static Object getDefaultModule() {
        String moduleName = "io.realm.DefaultRealmModule";
        try {
            Class<?> clazz = Class.forName(moduleName);
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (InstantiationException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
    }

    public static interface Transaction {
        public void execute(Realm var1);

        public static interface OnError {
            public void onError(Throwable var1);
        }

        public static interface OnSuccess {
            public void onSuccess();
        }

        public static class Callback {
            public void onSuccess() {
            }

            public void onError(Exception e) {
            }
        }
    }
}

