/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.view.LayoutInflater;
import android.widget.BaseAdapter;
import io.realm.OrderedRealmCollection;
import io.realm.RealmChangeListener;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmResults;

public abstract class RealmBaseAdapter<T extends RealmModel>
extends BaseAdapter {
    protected LayoutInflater inflater;
    protected OrderedRealmCollection<T> adapterData;
    protected Context context;
    private final RealmChangeListener listener;

    public RealmBaseAdapter(Context context, OrderedRealmCollection<T> data, boolean automaticUpdate) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        this.context = context;
        this.adapterData = data;
        this.inflater = LayoutInflater.from((Context)context);
        RealmChangeListener realmChangeListener = this.listener = !automaticUpdate ? null : new RealmChangeListener(){

            @Override
            public void onChange() {
                RealmBaseAdapter.this.notifyDataSetChanged();
            }
        };
        if (this.listener != null && data != null) {
            this.addListener(data);
        }
    }

    private void addListener(OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults realmResults = (RealmResults)data;
            realmResults.realm.handlerController.addChangeListenerAsWeakReference(this.listener);
        } else if (data instanceof RealmList) {
            RealmList realmList = (RealmList)data;
            realmList.realm.handlerController.addChangeListenerAsWeakReference(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    private void removeListener(OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults realmResults = (RealmResults)data;
            realmResults.realm.handlerController.removeWeakChangeListener(this.listener);
        } else if (data instanceof RealmList) {
            RealmList realmList = (RealmList)data;
            realmList.realm.handlerController.removeWeakChangeListener(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    public int getCount() {
        if (this.adapterData == null) {
            return 0;
        }
        return this.adapterData.size();
    }

    public T getItem(int i) {
        if (this.adapterData == null) {
            return null;
        }
        return (T)((RealmModel)this.adapterData.get(i));
    }

    public long getItemId(int i) {
        return i;
    }

    @Deprecated
    public void updateRealmResults(RealmResults<T> queryResults) {
        this.updateData(queryResults);
    }

    public void updateData(OrderedRealmCollection<T> data) {
        if (this.listener != null) {
            if (this.adapterData != null) {
                this.removeListener(this.adapterData);
            }
            if (data != null) {
                this.addListener(data);
            }
        }
        this.adapterData = data;
        this.notifyDataSetChanged();
    }
}

