/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.OrderedRealmCollection;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.RealmSchema;
import io.realm.Sort;
import io.realm.internal.InvalidRow;
import io.realm.internal.LinkView;
import io.realm.internal.RealmObjectProxy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class RealmList<E extends RealmModel>
extends AbstractList<E>
implements OrderedRealmCollection<E> {
    private static final String ONLY_IN_MANAGED_MODE_MESSAGE = "This method is only available in managed mode";
    private static final String NULL_OBJECTS_NOT_ALLOWED_MESSAGE = "RealmList does not accept null values";
    public static final String REMOVE_OUTSIDE_TRANSACTION_ERROR = "Objects can only be removed from inside a write transaction";
    private final boolean managedMode;
    protected Class<E> clazz;
    protected String className;
    protected LinkView view;
    protected BaseRealm realm;
    private List<E> nonManagedList;

    public RealmList() {
        this.managedMode = false;
        this.nonManagedList = new ArrayList();
    }

    public RealmList(E ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException("The objects argument cannot be null");
        }
        this.managedMode = false;
        this.nonManagedList = new ArrayList(objects.length);
        Collections.addAll(this.nonManagedList, objects);
    }

    RealmList(Class<E> clazz, LinkView linkView, BaseRealm realm) {
        this.managedMode = true;
        this.clazz = clazz;
        this.view = linkView;
        this.realm = realm;
    }

    RealmList(String className, LinkView linkView, BaseRealm realm) {
        this.managedMode = true;
        this.view = linkView;
        this.realm = realm;
        this.className = className;
    }

    @Override
    public boolean isValid() {
        if (this.realm == null || this.realm.isClosed()) {
            return false;
        }
        return this.isAttached();
    }

    private boolean isAttached() {
        return this.view != null && this.view.isAttached();
    }

    @Override
    public void add(int location, E object) {
        this.checkValidObject(object);
        if (this.managedMode) {
            this.checkValidView();
            if (location < 0 || location > this.size()) {
                throw new IndexOutOfBoundsException("Invalid index " + location + ", size is " + this.size());
            }
            RealmObjectProxy proxy = (RealmObjectProxy)this.copyToRealmIfNeeded(object);
            this.view.insert(location, proxy.realmGet$proxyState().getRow$realm().getIndex());
        } else {
            this.nonManagedList.add(location, object);
        }
        ++this.modCount;
    }

    @Override
    public boolean add(E object) {
        this.checkValidObject(object);
        if (this.managedMode) {
            this.checkValidView();
            RealmObjectProxy proxy = (RealmObjectProxy)this.copyToRealmIfNeeded(object);
            this.view.add(proxy.realmGet$proxyState().getRow$realm().getIndex());
        } else {
            this.nonManagedList.add(object);
        }
        ++this.modCount;
        return true;
    }

    @Override
    public E set(int location, E object) {
        this.checkValidObject(object);
        if (this.managedMode) {
            this.checkValidView();
            RealmObjectProxy proxy = (RealmObjectProxy)this.copyToRealmIfNeeded(object);
            Object oldObject = this.get(location);
            this.view.set(location, proxy.realmGet$proxyState().getRow$realm().getIndex());
            return (E)oldObject;
        }
        RealmModel oldObject = (RealmModel)this.nonManagedList.set(location, object);
        return (E)oldObject;
    }

    private E copyToRealmIfNeeded(E object) {
        Realm realm;
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            if (proxy instanceof DynamicRealmObject) {
                String listClassName = RealmSchema.getSchemaForTable(this.view.getTargetTable());
                String objectClassName = ((DynamicRealmObject)object).getType();
                if (proxy.realmGet$proxyState().getRealm$realm() == this.realm) {
                    if (listClassName.equals(objectClassName)) {
                        return object;
                    }
                    throw new IllegalArgumentException(String.format("The object has a different type from list's. Type of the list is '%s', type of object is '%s'.", listClassName, objectClassName));
                }
                if (this.realm.threadId == proxy.realmGet$proxyState().getRealm$realm().threadId) {
                    throw new IllegalArgumentException("Cannot copy DynamicRealmObject between Realm instances.");
                }
                throw new IllegalStateException("Cannot copy an object to a Realm instance created in another thread.");
            }
            if (proxy.realmGet$proxyState().getRow$realm() != null && proxy.realmGet$proxyState().getRealm$realm().getPath().equals(this.realm.getPath())) {
                if (this.realm != proxy.realmGet$proxyState().getRealm$realm()) {
                    throw new IllegalArgumentException("Cannot copy an object from another Realm instance.");
                }
                return object;
            }
        }
        if ((realm = (Realm)this.realm).getTable(object.getClass()).hasPrimaryKey()) {
            return realm.copyToRealmOrUpdate(object);
        }
        return realm.copyToRealm(object);
    }

    public void move(int oldPos, int newPos) {
        if (this.managedMode) {
            this.checkValidView();
            this.view.move(oldPos, newPos);
        } else {
            this.checkIndex(oldPos);
            this.checkIndex(newPos);
            RealmModel object = (RealmModel)this.nonManagedList.remove(oldPos);
            if (newPos > oldPos) {
                this.nonManagedList.add(newPos - 1, object);
            } else {
                this.nonManagedList.add(newPos, object);
            }
        }
    }

    @Override
    public void clear() {
        if (this.managedMode) {
            this.checkValidView();
            this.view.clear();
        } else {
            this.nonManagedList.clear();
        }
        ++this.modCount;
    }

    @Override
    public E remove(int location) {
        Object removedItem;
        if (this.managedMode) {
            this.checkValidView();
            removedItem = this.get(location);
            this.view.remove(location);
        } else {
            removedItem = (RealmModel)this.nonManagedList.remove(location);
        }
        ++this.modCount;
        return (E)removedItem;
    }

    @Override
    public boolean remove(Object object) {
        if (this.managedMode && !this.realm.isInTransaction()) {
            throw new IllegalStateException(REMOVE_OUTSIDE_TRANSACTION_ERROR);
        }
        return super.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.managedMode && !this.realm.isInTransaction()) {
            throw new IllegalStateException(REMOVE_OUTSIDE_TRANSACTION_ERROR);
        }
        return super.removeAll(collection);
    }

    @Override
    public boolean deleteFirstFromRealm() {
        if (this.managedMode) {
            if (this.size() > 0) {
                this.deleteFromRealm(0);
                ++this.modCount;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public boolean deleteLastFromRealm() {
        if (this.managedMode) {
            if (this.size() > 0) {
                this.deleteFromRealm(this.size() - 1);
                ++this.modCount;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public E get(int location) {
        if (this.managedMode) {
            this.checkValidView();
            long rowIndex = this.view.getTargetRowIndex(location);
            return this.realm.get(this.clazz, this.className, rowIndex);
        }
        return (E)((RealmModel)this.nonManagedList.get(location));
    }

    @Override
    public E first() {
        if (this.managedMode) {
            this.checkValidView();
            if (!this.view.isEmpty()) {
                return (E)this.get(0);
            }
        } else if (this.nonManagedList != null && this.nonManagedList.size() > 0) {
            return (E)((RealmModel)this.nonManagedList.get(0));
        }
        throw new IndexOutOfBoundsException("The list is empty.");
    }

    @Override
    public E last() {
        if (this.managedMode) {
            this.checkValidView();
            if (!this.view.isEmpty()) {
                return (E)this.get((int)this.view.size() - 1);
            }
        } else if (this.nonManagedList != null && this.nonManagedList.size() > 0) {
            return (E)((RealmModel)this.nonManagedList.get(this.nonManagedList.size() - 1));
        }
        throw new IndexOutOfBoundsException("The list is empty.");
    }

    @Override
    public RealmResults<E> sort(String fieldName) {
        return this.sort(fieldName, Sort.ASCENDING);
    }

    @Override
    public RealmResults<E> sort(String fieldName, Sort sortOrder) {
        if (this.managedMode) {
            return this.where().findAllSorted(fieldName, sortOrder);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public RealmResults<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    @Override
    public RealmResults<E> sort(String[] fieldNames, Sort[] sortOrders) {
        if (this.managedMode) {
            return this.where().findAllSorted(fieldNames, sortOrders);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public void deleteFromRealm(int location) {
        if (this.managedMode) {
            this.checkValidView();
            this.view.removeTargetRow(location);
            ++this.modCount;
        } else {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }
    }

    @Override
    public int size() {
        if (this.managedMode) {
            this.checkValidView();
            long size = this.view.size();
            return size < Integer.MAX_VALUE ? (int)size : Integer.MAX_VALUE;
        }
        return this.nonManagedList.size();
    }

    @Override
    public RealmQuery<E> where() {
        if (this.managedMode) {
            this.checkValidView();
            return RealmQuery.createQueryFromList(this);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public Number min(String fieldName) {
        if (this.managedMode) {
            return this.where().min(fieldName);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public Number max(String fieldName) {
        if (this.managedMode) {
            return this.where().max(fieldName);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public Number sum(String fieldName) {
        if (this.managedMode) {
            return this.where().sum(fieldName);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public double average(String fieldName) {
        if (this.managedMode) {
            return this.where().average(fieldName);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public Date maxDate(String fieldName) {
        if (this.managedMode) {
            return this.where().maximumDate(fieldName);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public Date minDate(String fieldName) {
        if (this.managedMode) {
            return this.where().minimumDate(fieldName);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public boolean deleteAllFromRealm() {
        if (this.managedMode) {
            this.checkValidView();
            if (this.size() > 0) {
                this.view.removeAllTargetRows();
                ++this.modCount;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public boolean load() {
        return true;
    }

    @Override
    public boolean contains(Object object) {
        boolean contains = false;
        if (this.managedMode) {
            RealmObjectProxy proxy;
            this.realm.checkIfValid();
            if (object instanceof RealmObjectProxy && (proxy = (RealmObjectProxy)object).realmGet$proxyState().getRow$realm() != null && this.realm.getPath().equals(proxy.realmGet$proxyState().getRealm$realm().getPath()) && proxy.realmGet$proxyState().getRow$realm() != InvalidRow.INSTANCE) {
                contains = this.view.contains(proxy.realmGet$proxyState().getRow$realm().getIndex());
            }
        } else {
            contains = this.nonManagedList.contains(object);
        }
        return contains;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.managedMode) {
            return new RealmItr();
        }
        return super.iterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        if (this.managedMode) {
            return new RealmListItr(location);
        }
        return super.listIterator(location);
    }

    private void checkValidObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException(NULL_OBJECTS_NOT_ALLOWED_MESSAGE);
        }
    }

    private void checkIndex(int location) {
        int size = this.size();
        if (location < 0 || location >= size) {
            throw new IndexOutOfBoundsException("Invalid index " + location + ", size is " + size);
        }
    }

    private void checkValidView() {
        this.realm.checkIfValid();
        if (this.view == null || !this.view.isAttached()) {
            throw new IllegalStateException("Realm instance has been closed or this object or its parent has been deleted.");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.managedMode ? this.clazz.getSimpleName() : this.getClass().getSimpleName());
        sb.append("@[");
        if (this.managedMode && !this.isAttached()) {
            sb.append("invalid");
        } else {
            for (int i = 0; i < this.size(); ++i) {
                if (this.managedMode) {
                    sb.append(((RealmObjectProxy)this.get(i)).realmGet$proxyState().getRow$realm().getIndex());
                } else {
                    sb.append(System.identityHashCode(this.get(i)));
                }
                if (i >= this.size() - 1) continue;
                sb.append(',');
            }
        }
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ int access$100(RealmList x0) {
        return x0.modCount;
    }

    private class RealmListItr
    extends RealmItr
    implements ListIterator<E> {
        RealmListItr(int index) {
            if (index < 0 || index > RealmList.this.size()) {
                throw new IndexOutOfBoundsException("Starting location must be a valid index: [0, " + (RealmList.this.size() - 1) + "]. Index was " + index);
            }
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkConcurrentModification();
            int i = this.cursor - 1;
            try {
                Object previous = RealmList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkConcurrentModification();
                throw new NoSuchElementException("Cannot access index less than zero. This was " + i + ". Remember to check hasPrevious() before using previous().");
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            RealmList.this.realm.checkIfValid();
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkConcurrentModification();
            try {
                RealmList.this.set(this.lastRet, e);
                this.expectedModCount = RealmList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            RealmList.this.realm.checkIfValid();
            this.checkConcurrentModification();
            try {
                int i = this.cursor;
                RealmList.this.add(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
                this.expectedModCount = RealmList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class RealmItr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = RealmList.access$100(RealmList.this);

        private RealmItr() {
        }

        @Override
        public boolean hasNext() {
            RealmList.this.realm.checkIfValid();
            this.checkConcurrentModification();
            return this.cursor != RealmList.this.size();
        }

        @Override
        public E next() {
            RealmList.this.realm.checkIfValid();
            this.checkConcurrentModification();
            int i = this.cursor;
            try {
                Object next = RealmList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkConcurrentModification();
                throw new NoSuchElementException("Cannot access index " + i + " when size is " + RealmList.this.size() + ". Remember to check hasNext() before using next().");
            }
        }

        @Override
        public void remove() {
            RealmList.this.realm.checkIfValid();
            if (this.lastRet < 0) {
                throw new IllegalStateException("Cannot call remove() twice. Must call next() in between.");
            }
            this.checkConcurrentModification();
            try {
                RealmList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = RealmList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkConcurrentModification() {
            if (RealmList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

