/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.internal.ColumnIndices;
import io.realm.internal.ColumnInfo;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.Table;
import io.realm.internal.Util;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class RealmSchema {
    private static final String TABLE_PREFIX = Table.TABLE_PREFIX;
    private static final String EMPTY_STRING_MSG = "Null or empty class names are not allowed";
    private final Map<String, Table> dynamicClassToTable = new HashMap<String, Table>();
    private final Map<Class<? extends RealmModel>, Table> classToTable = new HashMap<Class<? extends RealmModel>, Table>();
    private final Map<Class<? extends RealmModel>, RealmObjectSchema> classToSchema = new HashMap<Class<? extends RealmModel>, RealmObjectSchema>();
    private final Map<String, RealmObjectSchema> dynamicClassToSchema = new HashMap<String, RealmObjectSchema>();
    private final ImplicitTransaction transaction;
    private final BaseRealm realm;
    ColumnIndices columnIndices;

    RealmSchema(BaseRealm realm, ImplicitTransaction transaction) {
        this.realm = realm;
        this.transaction = transaction;
    }

    public RealmObjectSchema get(String className) {
        this.checkEmpty(className, EMPTY_STRING_MSG);
        String internalClassName = TABLE_PREFIX + className;
        if (this.transaction.hasTable(internalClassName)) {
            Table table = this.transaction.getTable(internalClassName);
            RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
            return new RealmObjectSchema(this.realm, table, columnIndices);
        }
        return null;
    }

    public Set<RealmObjectSchema> getAll() {
        int tableCount = (int)this.transaction.size();
        LinkedHashSet<RealmObjectSchema> schemas = new LinkedHashSet<RealmObjectSchema>(tableCount);
        for (int i = 0; i < tableCount; ++i) {
            String tableName = this.transaction.getTableName(i);
            if (Table.isMetaTable(tableName)) continue;
            Table table = this.transaction.getTable(tableName);
            RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
            schemas.add(new RealmObjectSchema(this.realm, table, columnIndices));
        }
        return schemas;
    }

    public RealmObjectSchema create(String className) {
        this.checkEmpty(className, EMPTY_STRING_MSG);
        String internalTableName = TABLE_PREFIX + className;
        if (internalTableName.length() > 56) {
            throw new IllegalArgumentException("Class name is to long. Limit is 57 characters: " + className.length());
        }
        if (this.transaction.hasTable(internalTableName)) {
            throw new IllegalArgumentException("Class already exists: " + className);
        }
        Table table = this.transaction.getTable(internalTableName);
        RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
        return new RealmObjectSchema(this.realm, table, columnIndices);
    }

    public void remove(String className) {
        this.checkEmpty(className, EMPTY_STRING_MSG);
        String internalTableName = TABLE_PREFIX + className;
        this.checkHasTable(className, "Cannot remove class because it is not in this Realm: " + className);
        this.transaction.removeTable(internalTableName);
    }

    public RealmObjectSchema rename(String oldClassName, String newClassName) {
        this.checkEmpty(oldClassName, "Class names cannot be empty or null");
        this.checkEmpty(newClassName, "Class names cannot be empty or null");
        String oldInternalName = TABLE_PREFIX + oldClassName;
        String newInternalName = TABLE_PREFIX + newClassName;
        this.checkHasTable(oldClassName, "Cannot rename class because it doesn't exist in this Realm: " + oldClassName);
        if (this.transaction.hasTable(newInternalName)) {
            throw new IllegalArgumentException(oldClassName + " cannot be renamed because the new class already exists: " + newClassName);
        }
        this.transaction.renameTable(oldInternalName, newInternalName);
        Table table = this.transaction.getTable(newInternalName);
        RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
        return new RealmObjectSchema(this.realm, table, columnIndices);
    }

    public boolean contains(String className) {
        return this.transaction.hasTable(Table.TABLE_PREFIX + className);
    }

    private void checkEmpty(String str, String error) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException(error);
        }
    }

    private void checkHasTable(String className, String errorMsg) {
        String internalTableName = TABLE_PREFIX + className;
        if (!this.transaction.hasTable(internalTableName)) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    ColumnInfo getColumnInfo(Class<? extends RealmModel> clazz) {
        ColumnInfo columnInfo = this.columnIndices.getColumnInfo(clazz);
        if (columnInfo == null) {
            throw new IllegalStateException("No validated schema information found for " + this.realm.configuration.getSchemaMediator().getTableName(clazz));
        }
        return columnInfo;
    }

    Table getTable(String className) {
        className = Table.TABLE_PREFIX + className;
        Table table = this.dynamicClassToTable.get(className);
        if (table == null) {
            if (!this.transaction.hasTable(className)) {
                throw new IllegalArgumentException("The class " + className + " doesn't exist in this Realm.");
            }
            table = this.transaction.getTable(className);
            this.dynamicClassToTable.put(className, table);
        }
        return table;
    }

    Table getTable(Class<? extends RealmModel> clazz) {
        Table table = this.classToTable.get(clazz);
        if (table == null) {
            clazz = Util.getOriginalModelClass(clazz);
            table = this.transaction.getTable(this.realm.configuration.getSchemaMediator().getTableName(clazz));
            this.classToTable.put(clazz, table);
        }
        return table;
    }

    RealmObjectSchema getSchemaForClass(Class<? extends RealmModel> clazz) {
        RealmObjectSchema classSchema = this.classToSchema.get(clazz);
        if (classSchema == null) {
            clazz = Util.getOriginalModelClass(clazz);
            Table table = this.transaction.getTable(this.realm.configuration.getSchemaMediator().getTableName(clazz));
            classSchema = new RealmObjectSchema(this.realm, table, this.columnIndices.getColumnInfo(clazz).getIndicesMap());
            this.classToSchema.put(clazz, classSchema);
        }
        return classSchema;
    }

    RealmObjectSchema getSchemaForClass(String className) {
        className = Table.TABLE_PREFIX + className;
        RealmObjectSchema dynamicSchema = this.dynamicClassToSchema.get(className);
        if (dynamicSchema == null) {
            if (!this.transaction.hasTable(className)) {
                throw new IllegalArgumentException("The class " + className + " doesn't exist in this Realm.");
            }
            Table table = this.transaction.getTable(className);
            RealmObjectSchema.DynamicColumnMap columnIndices = new RealmObjectSchema.DynamicColumnMap(table);
            dynamicSchema = new RealmObjectSchema(this.realm, table, columnIndices);
            this.dynamicClassToSchema.put(className, dynamicSchema);
        }
        return dynamicSchema;
    }

    void setColumnIndices(ColumnIndices columnIndices) {
        this.columnIndices = columnIndices;
    }

    static String getSchemaForTable(Table table) {
        return table.getName().substring(Table.TABLE_PREFIX.length());
    }
}

