/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.Context;
import io.realm.internal.LinkView;
import io.realm.internal.Mixed;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;

public class CheckedRow
extends UncheckedRow {
    private UncheckedRow originalRow;

    private CheckedRow(Context context, Table parent, long nativePtr) {
        super(context, parent, nativePtr);
    }

    private CheckedRow(UncheckedRow row) {
        super(row.context, row.parent, row.nativePointer);
        this.originalRow = row;
    }

    public static CheckedRow get(Context context, Table table, long index) {
        long nativeRowPointer = table.nativeGetRowPtr(table.nativePtr, index);
        CheckedRow row = new CheckedRow(context, table, nativeRowPointer);
        context.addReference(1, row);
        return row;
    }

    public static CheckedRow get(Context context, LinkView linkView, long index) {
        long nativeRowPointer = linkView.nativeGetRow(linkView.nativePointer, index);
        CheckedRow row = new CheckedRow(context, linkView.getTargetTable(), nativeRowPointer);
        context.addReference(1, row);
        return row;
    }

    public static CheckedRow getFromRow(UncheckedRow row) {
        return new CheckedRow(row);
    }

    @Override
    public boolean isNullLink(long columnIndex) {
        RealmFieldType columnType = this.getColumnType(columnIndex);
        if (columnType == RealmFieldType.OBJECT || columnType == RealmFieldType.LIST) {
            return super.isNullLink(columnIndex);
        }
        return false;
    }

    @Override
    public boolean isNull(long columnIndex) {
        return super.isNull(columnIndex);
    }

    @Override
    public void setNull(long columnIndex) {
        RealmFieldType columnType = this.getColumnType(columnIndex);
        if (columnType == RealmFieldType.BINARY) {
            super.setBinaryByteArray(columnIndex, null);
        } else {
            super.setNull(columnIndex);
        }
    }

    @Override
    protected native long nativeGetColumnCount(long var1);

    @Override
    protected native String nativeGetColumnName(long var1, long var3);

    @Override
    protected native long nativeGetColumnIndex(long var1, String var3);

    @Override
    protected native int nativeGetColumnType(long var1, long var3);

    @Override
    protected native long nativeGetLong(long var1, long var3);

    @Override
    protected native boolean nativeGetBoolean(long var1, long var3);

    @Override
    protected native float nativeGetFloat(long var1, long var3);

    @Override
    protected native double nativeGetDouble(long var1, long var3);

    @Override
    protected native long nativeGetDateTime(long var1, long var3);

    @Override
    protected native String nativeGetString(long var1, long var3);

    @Override
    protected native boolean nativeIsNullLink(long var1, long var3);

    @Override
    protected native byte[] nativeGetByteArray(long var1, long var3);

    @Override
    protected native int nativeGetMixedType(long var1, long var3);

    @Override
    protected native Mixed nativeGetMixed(long var1, long var3);

    @Override
    protected native long nativeGetLinkView(long var1, long var3);

    @Override
    protected native void nativeSetLong(long var1, long var3, long var5);

    @Override
    protected native void nativeSetBoolean(long var1, long var3, boolean var5);

    @Override
    protected native void nativeSetFloat(long var1, long var3, float var5);

    @Override
    protected native long nativeGetLink(long var1, long var3);

    @Override
    protected native void nativeSetDouble(long var1, long var3, double var5);

    @Override
    protected native void nativeSetDate(long var1, long var3, long var5);

    @Override
    protected native void nativeSetString(long var1, long var3, String var5);

    @Override
    protected native void nativeSetByteArray(long var1, long var3, byte[] var5);

    @Override
    protected native void nativeSetMixed(long var1, long var3, Mixed var5);

    @Override
    protected native void nativeSetLink(long var1, long var3, long var5);

    @Override
    protected native void nativeNullifyLink(long var1, long var3);
}

