/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Group;
import io.realm.internal.NativeObject;
import io.realm.internal.NativeObjectReference;
import io.realm.internal.SharedGroup;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.TableView;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;

public class Context {
    private List<Long> abandonedTables = new ArrayList<Long>();
    private List<Long> abandonedTableViews = new ArrayList<Long>();
    private List<Long> abandonedQueries = new ArrayList<Long>();
    private ReferencesPool referencesPool = new ReferencesPool();
    private ReferenceQueue<NativeObject> referenceQueue = new ReferenceQueue();
    private boolean isFinalized = false;

    public synchronized void addReference(int type, NativeObject referent) {
        this.referencesPool.add(new NativeObjectReference(type, referent, this.referenceQueue, this.referencesPool.getFreeIndex()));
    }

    public synchronized void executeDelayedDisposal() {
        long nativePointer;
        int i;
        for (i = 0; i < this.abandonedTables.size(); ++i) {
            nativePointer = this.abandonedTables.get(i);
            Table.nativeClose(nativePointer);
        }
        this.abandonedTables.clear();
        for (i = 0; i < this.abandonedTableViews.size(); ++i) {
            nativePointer = this.abandonedTableViews.get(i);
            TableView.nativeClose(nativePointer);
        }
        this.abandonedTableViews.clear();
        for (i = 0; i < this.abandonedQueries.size(); ++i) {
            nativePointer = this.abandonedQueries.get(i);
            TableQuery.nativeClose(nativePointer);
        }
        this.abandonedQueries.clear();
        this.cleanNativeReferences();
    }

    private void cleanNativeReferences() {
        NativeObjectReference reference = (NativeObjectReference)this.referenceQueue.poll();
        while (reference != null) {
            reference.cleanup();
            this.referencesPool.freeIndexList.add(reference.refIndex);
            reference = (NativeObjectReference)this.referenceQueue.poll();
        }
    }

    public void asyncDisposeTable(long nativePointer, boolean isRoot) {
        if (isRoot || this.isFinalized) {
            Table.nativeClose(nativePointer);
        } else {
            this.abandonedTables.add(nativePointer);
        }
    }

    public void asyncDisposeTableView(long nativePointer) {
        if (this.isFinalized) {
            TableView.nativeClose(nativePointer);
        } else {
            this.abandonedTableViews.add(nativePointer);
        }
    }

    public void asyncDisposeQuery(long nativePointer) {
        if (this.isFinalized) {
            TableQuery.nativeClose(nativePointer);
        } else {
            this.abandonedQueries.add(nativePointer);
        }
    }

    public void asyncDisposeGroup(long nativePointer) {
        Group.nativeClose(nativePointer);
    }

    public void asyncDisposeSharedGroup(long nativePointer) {
        SharedGroup.nativeClose(nativePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Context context = this;
        synchronized (context) {
            this.isFinalized = true;
        }
        this.executeDelayedDisposal();
        super.finalize();
    }

    private static class ReferencesPool {
        ArrayList<NativeObjectReference> pool = new ArrayList();
        ArrayList<Integer> freeIndexList = new ArrayList();

        private ReferencesPool() {
        }

        void add(NativeObjectReference ref) {
            if (this.pool.size() <= ref.refIndex) {
                this.pool.add(ref);
            } else {
                this.pool.set(ref.refIndex, ref);
            }
        }

        Integer getFreeIndex() {
            int freeIndexListSize = this.freeIndexList.size();
            Integer index = freeIndexListSize == 0 ? Integer.valueOf(this.pool.size()) : this.freeIndexList.remove(freeIndexListSize - 1);
            return index;
        }
    }
}

