/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Context;
import io.realm.internal.Group;
import io.realm.internal.SharedGroup;
import io.realm.internal.async.BadVersionException;

public class ImplicitTransaction
extends Group {
    private final SharedGroup parent;

    public ImplicitTransaction(Context context, SharedGroup sharedGroup, long nativePtr) {
        super(context, nativePtr, true);
        this.parent = sharedGroup;
    }

    public void advanceRead() {
        this.assertNotClosed();
        this.parent.advanceRead();
    }

    public void advanceRead(SharedGroup.VersionID versionID) throws BadVersionException {
        this.assertNotClosed();
        this.parent.advanceRead(versionID);
    }

    public void promoteToWrite() {
        this.assertNotClosed();
        if (!this.immutable) {
            throw new IllegalStateException("Nested transactions are not allowed. Use commitTransaction() after each beginTransaction().");
        }
        this.immutable = false;
        this.parent.promoteToWrite();
    }

    public void commitAndContinueAsRead() {
        this.assertNotClosed();
        if (this.immutable) {
            throw new IllegalStateException("Not inside a transaction.");
        }
        this.parent.commitAndContinueAsRead();
        this.immutable = true;
    }

    public void endRead() {
        this.assertNotClosed();
        this.parent.endRead();
    }

    public void rollbackAndContinueAsRead() {
        this.assertNotClosed();
        if (this.immutable) {
            throw new IllegalStateException("Not inside a transaction.");
        }
        this.parent.rollbackAndContinueAsRead();
        this.immutable = true;
    }

    private void assertNotClosed() {
        if (this.isClosed() || this.parent.isClosed()) {
            throw new IllegalStateException("Cannot use ImplicitTransaction after it or its parent has been closed.");
        }
    }

    public String getPath() {
        return this.parent.getPath();
    }

    @Override
    protected void finalize() {
    }
}

