/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.LinkView;
import io.realm.internal.NativeObject;
import io.realm.internal.UncheckedRow;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;

public final class NativeObjectReference
extends PhantomReference<NativeObject> {
    public static final int TYPE_LINK_VIEW = 0;
    public static final int TYPE_ROW = 1;
    final long nativePointer;
    final int type;
    final Integer refIndex;

    NativeObjectReference(int type, NativeObject referent, ReferenceQueue<? super NativeObject> referenceQueue, Integer index) {
        super(referent, referenceQueue);
        this.type = type;
        this.nativePointer = referent.nativePointer;
        this.refIndex = index;
    }

    void cleanup() {
        switch (this.type) {
            case 0: {
                LinkView.nativeClose(this.nativePointer);
                break;
            }
            case 1: {
                UncheckedRow.nativeClose(this.nativePointer);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown native reference type " + this.type + ".");
            }
        }
    }
}

