/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

public class Version {
    static final int CORE_MIN_MAJOR = 0;
    static final int CORE_MIN_MINOR = 1;
    static final int CORE_MIN_PATCH = 6;
    static final int REQUIRED_JNI_VERSION = 23;

    public static String getCoreVersion() {
        return Version.nativeGetVersion();
    }

    public static String getVersion() {
        return Version.getCoreVersion();
    }

    public static boolean hasFeature(Feature feature) {
        return Version.nativeHasFeature(feature.ordinal());
    }

    public static boolean coreLibVersionCompatible(boolean throwIfNot) {
        boolean compatible = Version.nativeIsAtLeast(0, 1, 6);
        if (!compatible) {
            String errTxt = "Version mismatch between realm.jar (0.1.6) and native core library (" + Version.getCoreVersion() + ")";
            if (throwIfNot) {
                throw new RuntimeException(errTxt);
            }
            System.err.println(errTxt);
            return false;
        }
        boolean bl = compatible = Version.nativeGetAPIVersion() == 23;
        if (!compatible) {
            String errTxt = "Native lib API is version " + Version.nativeGetAPIVersion() + " != " + 23 + " which is expected by the jar.";
            if (throwIfNot) {
                throw new RuntimeException(errTxt);
            }
            System.err.println(errTxt);
        }
        return compatible;
    }

    static native String nativeGetVersion();

    static native boolean nativeHasFeature(int var0);

    static native boolean nativeIsAtLeast(int var0, int var1, int var2);

    static native int nativeGetAPIVersion();

    public static enum Feature {
        Feature_Debug(0),
        Feature_Replication(1);

        private final int nativeFeature;

        private Feature(int nativeValue) {
            this.nativeFeature = nativeValue;
        }
    }
}

