/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.async;

import android.os.Handler;
import io.realm.RealmConfiguration;
import io.realm.RealmModel;
import io.realm.RealmResults;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.SharedGroup;
import io.realm.internal.TableQuery;
import io.realm.internal.async.ArgumentsHolder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public class QueryUpdateTask
implements Runnable {
    private static final int MODE_UPDATE_REALM_RESULTS = 0;
    private static final int MODE_UPDATE_REALM_OBJECT = 1;
    private final int updateMode;
    private RealmConfiguration realmConfiguration;
    private List<Builder.QueryEntry> realmResultsEntries;
    private Builder.QueryEntry realmObjectEntry;
    private WeakReference<Handler> callerHandler;
    private int message;

    private QueryUpdateTask(int mode, RealmConfiguration realmConfiguration, List<Builder.QueryEntry> listOfRealmResults, Builder.QueryEntry realmObject, WeakReference<Handler> handler, int message) {
        this.updateMode = mode;
        this.realmConfiguration = realmConfiguration;
        this.realmResultsEntries = listOfRealmResults;
        this.realmObjectEntry = realmObject;
        this.callerHandler = handler;
        this.message = message;
    }

    public static Builder.RealmConfigurationStep newBuilder() {
        return new Builder.Steps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (SharedGroup sharedGroup = null;){
            boolean updateSuccessful;
            Result result;
            sharedGroup = new SharedGroup(this.realmConfiguration.getPath(), true, this.realmConfiguration.getDurability(), this.realmConfiguration.getEncryptionKey());
            if (this.updateMode == 0) {
                result = Result.newRealmResultsResponse();
                AlignedQueriesParameters alignedParameters = this.prepareQueriesParameters();
                long[] handoverTableViewPointer = TableQuery.nativeBatchUpdateQueries(sharedGroup.getNativePointer(), alignedParameters.handoverQueries, alignedParameters.queriesParameters, alignedParameters.multiSortColumnIndices, alignedParameters.multiSortOrder);
                this.swapPointers(result, handoverTableViewPointer);
                updateSuccessful = true;
                result.versionID = sharedGroup.getVersion();
            } else {
                result = Result.newRealmObjectResponse();
                updateSuccessful = this.updateRealmObjectQuery(sharedGroup, result);
                result.versionID = sharedGroup.getVersion();
            }
            Handler handler = (Handler)this.callerHandler.get();
            if (updateSuccessful && !this.isTaskCancelled() && this.isAliveHandler(handler)) {
                handler.obtainMessage(this.message, (Object)result).sendToTarget();
            }
        }
    }

    private AlignedQueriesParameters prepareQueriesParameters() {
        long[] handoverQueries = new long[this.realmResultsEntries.size()];
        long[][] queriesParameters = new long[this.realmResultsEntries.size()][6];
        long[][] multiSortColumnIndices = new long[this.realmResultsEntries.size()][];
        boolean[][] multiSortOrder = new boolean[this.realmResultsEntries.size()][];
        int i = 0;
        for (Builder.QueryEntry queryEntry : this.realmResultsEntries) {
            switch (queryEntry.queryArguments.type) {
                case 0: {
                    handoverQueries[i] = queryEntry.handoverQueryPointer;
                    queriesParameters[i][0] = 0L;
                    queriesParameters[i][1] = 0L;
                    queriesParameters[i][2] = -1L;
                    queriesParameters[i][3] = -1L;
                    break;
                }
                case 4: {
                    handoverQueries[i] = queryEntry.handoverQueryPointer;
                    queriesParameters[i][0] = 4L;
                    queriesParameters[i][1] = queryEntry.queryArguments.columnIndex;
                    break;
                }
                case 1: {
                    handoverQueries[i] = queryEntry.handoverQueryPointer;
                    queriesParameters[i][0] = 1L;
                    queriesParameters[i][1] = 0L;
                    queriesParameters[i][2] = -1L;
                    queriesParameters[i][3] = -1L;
                    queriesParameters[i][4] = queryEntry.queryArguments.columnIndex;
                    queriesParameters[i][5] = queryEntry.queryArguments.sortOrder.getValue() ? 1L : 0L;
                    break;
                }
                case 2: {
                    handoverQueries[i] = queryEntry.handoverQueryPointer;
                    queriesParameters[i][0] = 2L;
                    queriesParameters[i][1] = 0L;
                    queriesParameters[i][2] = -1L;
                    queriesParameters[i][3] = -1L;
                    multiSortColumnIndices[i] = queryEntry.queryArguments.columnIndices;
                    multiSortOrder[i] = TableQuery.getNativeSortOrderValues(queryEntry.queryArguments.sortOrders);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Query mode " + queryEntry.queryArguments.type + " not supported");
                }
            }
            ++i;
        }
        AlignedQueriesParameters alignedParameters = new AlignedQueriesParameters();
        alignedParameters.handoverQueries = handoverQueries;
        alignedParameters.multiSortColumnIndices = multiSortColumnIndices;
        alignedParameters.multiSortOrder = multiSortOrder;
        alignedParameters.queriesParameters = queriesParameters;
        return alignedParameters;
    }

    private void swapPointers(Result result, long[] handoverTableViewPointer) {
        int i = 0;
        for (Builder.QueryEntry queryEntry : this.realmResultsEntries) {
            result.updatedTableViews.put(queryEntry.element, handoverTableViewPointer[i++]);
        }
    }

    private boolean updateRealmObjectQuery(SharedGroup sharedGroup, Result result) {
        block4: {
            block3: {
                if (this.isTaskCancelled()) break block3;
                switch (this.realmObjectEntry.queryArguments.type) {
                    case 3: {
                        long handoverRowPointer = TableQuery.nativeFindWithHandover(sharedGroup.getNativePointer(), this.realmObjectEntry.handoverQueryPointer, 0L);
                        result.updatedRow.put(this.realmObjectEntry.element, handoverRowPointer);
                        break block4;
                    }
                    default: {
                        throw new IllegalArgumentException("Query mode " + this.realmObjectEntry.queryArguments.type + " not supported");
                    }
                }
            }
            TableQuery.nativeCloseQueryHandover(this.realmObjectEntry.handoverQueryPointer);
            return false;
        }
        return true;
    }

    private boolean isTaskCancelled() {
        return Thread.currentThread().isInterrupted();
    }

    private boolean isAliveHandler(Handler handler) {
        return handler != null && handler.getLooper().getThread().isAlive();
    }

    public static class Builder {

        private static class QueryEntry {
            final WeakReference element;
            long handoverQueryPointer;
            final ArgumentsHolder queryArguments;

            private QueryEntry(WeakReference element, long handoverQueryPointer, ArgumentsHolder queryArguments) {
                this.element = element;
                this.handoverQueryPointer = handoverQueryPointer;
                this.queryArguments = queryArguments;
            }
        }

        private static class Steps
        implements RealmConfigurationStep,
        UpdateQueryStep,
        RealmResultsQueryStep,
        HandlerStep,
        BuilderStep {
            private RealmConfiguration realmConfiguration;
            private List<QueryEntry> realmResultsEntries;
            private QueryEntry realmObjectEntry;
            private WeakReference<Handler> callerHandler;
            private int message;

            private Steps() {
            }

            @Override
            public UpdateQueryStep realmConfiguration(RealmConfiguration realmConfiguration) {
                this.realmConfiguration = realmConfiguration;
                return this;
            }

            public RealmResultsQueryStep add(WeakReference<RealmResults<?>> weakReference, long handoverQueryPointer, ArgumentsHolder queryArguments) {
                if (this.realmResultsEntries == null) {
                    this.realmResultsEntries = new ArrayList<QueryEntry>(1);
                }
                this.realmResultsEntries.add(new QueryEntry(weakReference, handoverQueryPointer, queryArguments));
                return this;
            }

            @Override
            public HandlerStep addObject(WeakReference<? extends RealmModel> weakReference, long handoverQueryPointer, ArgumentsHolder queryArguments) {
                this.realmObjectEntry = new QueryEntry(weakReference, handoverQueryPointer, queryArguments);
                return this;
            }

            @Override
            public BuilderStep sendToHandler(Handler handler, int message) {
                this.callerHandler = new WeakReference<Handler>(handler);
                this.message = message;
                return this;
            }

            @Override
            public QueryUpdateTask build() {
                return new QueryUpdateTask(this.realmResultsEntries != null ? 0 : 1, this.realmConfiguration, this.realmResultsEntries, this.realmObjectEntry, this.callerHandler, this.message);
            }
        }

        public static interface BuilderStep {
            public QueryUpdateTask build();
        }

        public static interface HandlerStep {
            public BuilderStep sendToHandler(Handler var1, int var2);
        }

        public static interface RealmResultsQueryStep {
            public RealmResultsQueryStep add(WeakReference<RealmResults<? extends RealmModel>> var1, long var2, ArgumentsHolder var4);

            public BuilderStep sendToHandler(Handler var1, int var2);
        }

        public static interface UpdateQueryStep {
            public RealmResultsQueryStep add(WeakReference<RealmResults<? extends RealmModel>> var1, long var2, ArgumentsHolder var4);

            public HandlerStep addObject(WeakReference<? extends RealmModel> var1, long var2, ArgumentsHolder var4);
        }

        public static interface RealmConfigurationStep {
            public UpdateQueryStep realmConfiguration(RealmConfiguration var1);
        }
    }

    private static class AlignedQueriesParameters {
        long[] handoverQueries;
        long[][] queriesParameters;
        long[][] multiSortColumnIndices;
        boolean[][] multiSortOrder;

        private AlignedQueriesParameters() {
        }
    }

    public static class Result {
        public IdentityHashMap<WeakReference<RealmResults<? extends RealmModel>>, Long> updatedTableViews;
        public IdentityHashMap<WeakReference<RealmObjectProxy>, Long> updatedRow;
        public SharedGroup.VersionID versionID;

        public static Result newRealmResultsResponse() {
            Result result = new Result();
            result.updatedTableViews = new IdentityHashMap(1);
            return result;
        }

        public static Result newRealmObjectResponse() {
            Result result = new Result();
            result.updatedRow = new IdentityHashMap(1);
            return result;
        }
    }
}

