/*
 * Decompiled with CFR 0.152.
 */
package io.realm.rx;

import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.rx.RxObservableFactory;
import java.util.IdentityHashMap;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class RealmObservableFactory
implements RxObservableFactory {
    ThreadLocal<StrongReferenceCounter<RealmResults>> resultsRefs = new ThreadLocal<StrongReferenceCounter<RealmResults>>(){

        @Override
        protected StrongReferenceCounter<RealmResults> initialValue() {
            return new StrongReferenceCounter<RealmResults>();
        }
    };
    ThreadLocal<StrongReferenceCounter<RealmModel>> objectRefs = new ThreadLocal<StrongReferenceCounter<RealmModel>>(){

        @Override
        protected StrongReferenceCounter<RealmModel> initialValue() {
            return new StrongReferenceCounter<RealmModel>();
        }
    };

    @Override
    public Observable<Realm> from(Realm realm) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Realm>(){

            public void call(final Subscriber<? super Realm> subscriber) {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)observableRealm);
                        }
                    }
                };
                observableRealm.addChangeListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        observableRealm.removeChangeListener(listener);
                        observableRealm.close();
                    }
                }));
                subscriber.onNext((Object)observableRealm);
            }
        });
    }

    @Override
    public Observable<DynamicRealm> from(DynamicRealm realm) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<DynamicRealm>(){

            public void call(final Subscriber<? super DynamicRealm> subscriber) {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)observableRealm);
                        }
                    }
                };
                observableRealm.addChangeListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        observableRealm.removeChangeListener(listener);
                        observableRealm.close();
                    }
                }));
                subscriber.onNext((Object)observableRealm);
            }
        });
    }

    @Override
    public <E extends RealmModel> Observable<RealmResults<E>> from(Realm realm, final RealmResults<E> results) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RealmResults<E>>(){

            public void call(final Subscriber<? super RealmResults<E>> subscriber) {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                RealmObservableFactory.this.resultsRefs.get().acquireReference(results);
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)results);
                        }
                    }
                };
                results.addChangeListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        results.removeChangeListener(listener);
                        observableRealm.close();
                        RealmObservableFactory.this.resultsRefs.get().releaseReference(results);
                    }
                }));
                subscriber.onNext((Object)results);
            }
        });
    }

    @Override
    public Observable<RealmResults<DynamicRealmObject>> from(DynamicRealm realm, final RealmResults<DynamicRealmObject> results) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RealmResults<DynamicRealmObject>>(){

            public void call(final Subscriber<? super RealmResults<DynamicRealmObject>> subscriber) {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                RealmObservableFactory.this.resultsRefs.get().acquireReference(results);
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)results);
                        }
                    }
                };
                results.addChangeListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        results.removeChangeListener(listener);
                        observableRealm.close();
                        RealmObservableFactory.this.resultsRefs.get().releaseReference(results);
                    }
                }));
                subscriber.onNext((Object)results);
            }
        });
    }

    @Override
    public <E extends RealmModel> Observable<RealmList<E>> from(Realm realm, RealmList<E> list) {
        return this.getRealmListObservable();
    }

    @Override
    public Observable<RealmList<DynamicRealmObject>> from(DynamicRealm realm, RealmList<DynamicRealmObject> list) {
        return this.getRealmListObservable();
    }

    private <E extends RealmModel> Observable<RealmList<E>> getRealmListObservable() {
        throw new RuntimeException("RealmList does not support change listeners yet, so cannot create an Observable");
    }

    @Override
    public <E extends RealmModel> Observable<E> from(Realm realm, final E object) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<E>(){

            public void call(final Subscriber<? super E> subscriber) {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                RealmObservableFactory.this.objectRefs.get().acquireReference(object);
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)object);
                        }
                    }
                };
                RealmObject.addChangeListener(object, listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        RealmObject.removeChangeListener(object, listener);
                        observableRealm.close();
                        RealmObservableFactory.this.objectRefs.get().releaseReference(object);
                    }
                }));
                subscriber.onNext((Object)object);
            }
        });
    }

    @Override
    public Observable<DynamicRealmObject> from(DynamicRealm realm, final DynamicRealmObject object) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<DynamicRealmObject>(){

            public void call(final Subscriber<? super DynamicRealmObject> subscriber) {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                RealmObservableFactory.this.objectRefs.get().acquireReference(object);
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)object);
                        }
                    }
                };
                RealmObject.addChangeListener(object, listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        RealmObject.removeChangeListener(object, listener);
                        observableRealm.close();
                        RealmObservableFactory.this.objectRefs.get().releaseReference(object);
                    }
                }));
                subscriber.onNext((Object)object);
            }
        });
    }

    @Override
    public <E extends RealmModel> Observable<RealmQuery<E>> from(Realm realm, RealmQuery<E> query) {
        throw new RuntimeException("RealmQuery not supported yet.");
    }

    @Override
    public Observable<RealmQuery<DynamicRealmObject>> from(DynamicRealm realm, RealmQuery<DynamicRealmObject> query) {
        throw new RuntimeException("RealmQuery not supported yet.");
    }

    public boolean equals(Object o) {
        return o instanceof RealmObservableFactory;
    }

    public int hashCode() {
        return 37;
    }

    private static class StrongReferenceCounter<K> {
        private final Map<K, Integer> references = new IdentityHashMap<K, Integer>();

        private StrongReferenceCounter() {
        }

        public void acquireReference(K object) {
            Integer count = this.references.get(object);
            if (count == null) {
                this.references.put(object, 1);
            } else {
                this.references.put(object, count + 1);
            }
        }

        public void releaseReference(K object) {
            Integer count = this.references.get(object);
            if (count == null) {
                throw new IllegalStateException("Object does not have any references: " + object);
            }
            if (count > 0) {
                this.references.put(object, count - 1);
            } else {
                this.references.remove(object);
            }
        }
    }
}

