/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.reactivex.Flowable;
import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.MutableRealmSchema;
import io.realm.RealmAsyncTask;
import io.realm.RealmCache;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmQuery;
import io.realm.RealmSchema;
import io.realm.exceptions.RealmException;
import io.realm.internal.CheckedRow;
import io.realm.internal.OsObject;
import io.realm.internal.OsObjectStore;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.Table;
import io.realm.log.RealmLog;
import java.util.Locale;

public class DynamicRealm
extends BaseRealm {
    private final RealmSchema schema;

    private DynamicRealm(final RealmCache cache) {
        super(cache, null);
        RealmCache.invokeWithGlobalRefCount(cache.getConfiguration(), new RealmCache.Callback(){

            @Override
            public void onResult(int count) {
                if (count > 0) {
                    return;
                }
                if (cache.getConfiguration().isReadOnly()) {
                    return;
                }
                if (OsObjectStore.getSchemaVersion(DynamicRealm.this.sharedRealm) != -1L) {
                    return;
                }
                DynamicRealm.this.sharedRealm.beginTransaction();
                if (OsObjectStore.getSchemaVersion(DynamicRealm.this.sharedRealm) == -1L) {
                    OsObjectStore.setSchemaVersion(DynamicRealm.this.sharedRealm, -1L);
                }
                DynamicRealm.this.sharedRealm.commitTransaction();
            }
        });
        this.schema = new MutableRealmSchema(this);
    }

    private DynamicRealm(OsSharedRealm sharedRealm) {
        super(sharedRealm);
        this.schema = new MutableRealmSchema(this);
    }

    public static DynamicRealm getInstance(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return RealmCache.createRealmOrGetFromCache(configuration, DynamicRealm.class);
    }

    public static RealmAsyncTask getInstanceAsync(RealmConfiguration configuration, Callback callback) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return RealmCache.createRealmOrGetFromCacheAsync(configuration, callback, DynamicRealm.class);
    }

    public DynamicRealmObject createObject(String className) {
        this.checkIfValid();
        Table table = this.schema.getTable(className);
        String pkField = OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, className);
        if (pkField != null) {
            throw new RealmException(String.format(Locale.US, "'%s' has a primary key field '%s', use  'createObject(String, Object)' instead.", className, pkField));
        }
        return new DynamicRealmObject(this, CheckedRow.getFromRow(OsObject.create(table)));
    }

    public DynamicRealmObject createObject(String className, Object primaryKeyValue) {
        Table table = this.schema.getTable(className);
        return new DynamicRealmObject(this, CheckedRow.getFromRow(OsObject.createWithPrimaryKey(table, primaryKeyValue)));
    }

    public RealmQuery<DynamicRealmObject> where(String className) {
        this.checkIfValid();
        if (!this.sharedRealm.hasTable(Table.getTableNameForClass(className))) {
            throw new IllegalArgumentException("Class does not exist in the Realm and cannot be queried: " + className);
        }
        return RealmQuery.createDynamicQuery(this, className);
    }

    public void addChangeListener(RealmChangeListener<DynamicRealm> listener) {
        this.addListener(listener);
    }

    public void removeChangeListener(RealmChangeListener<DynamicRealm> listener) {
        this.removeListener(listener);
    }

    public void removeAllChangeListeners() {
        this.removeAllListeners();
    }

    public void delete(String className) {
        this.checkIfValid();
        this.checkIfInTransaction();
        this.schema.getTable(className).clear();
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (RuntimeException e) {
            if (this.isInTransaction()) {
                this.cancelTransaction();
            } else {
                RealmLog.warn("Could not cancel transaction, not currently in a transaction.", new Object[0]);
            }
            throw e;
        }
    }

    static DynamicRealm createInstance(RealmCache cache) {
        return new DynamicRealm(cache);
    }

    static DynamicRealm createInstance(OsSharedRealm sharedRealm) {
        return new DynamicRealm(sharedRealm);
    }

    public Flowable<DynamicRealm> asFlowable() {
        return this.configuration.getRxFactory().from(this);
    }

    @Override
    public RealmSchema getSchema() {
        return this.schema;
    }

    void setVersion(long version) {
        OsObjectStore.setSchemaVersion(this.sharedRealm, version);
    }

    public static abstract class Callback
    extends BaseRealm.InstanceCallback<DynamicRealm> {
        @Override
        public abstract void onSuccess(DynamicRealm var1);

        @Override
        public void onError(Throwable exception) {
            super.onError(exception);
        }
    }

    public static interface Transaction {
        public void execute(DynamicRealm var1);
    }
}

