/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.BinaryListOperator;
import io.realm.BooleanListOperator;
import io.realm.DateListOperator;
import io.realm.DoubleListOperator;
import io.realm.DynamicRealm;
import io.realm.FloatListOperator;
import io.realm.LongListOperator;
import io.realm.ManagedListOperator;
import io.realm.ProxyState;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmObjectSchema;
import io.realm.RealmResults;
import io.realm.RealmSchema;
import io.realm.StringListOperator;
import io.realm.internal.CheckedRow;
import io.realm.internal.OsList;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.android.JsonUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nullable;

public class DynamicRealmObject
extends RealmObject
implements RealmObjectProxy {
    static final String MSG_LINK_QUERY_NOT_SUPPORTED = "Queries across relationships are not supported";
    private final ProxyState<DynamicRealmObject> proxyState = new ProxyState<DynamicRealmObject>(this);

    public DynamicRealmObject(RealmModel obj) {
        if (obj == null) {
            throw new IllegalArgumentException("A non-null object must be provided.");
        }
        if (obj instanceof DynamicRealmObject) {
            throw new IllegalArgumentException("The object is already a DynamicRealmObject: " + obj);
        }
        if (!RealmObject.isManaged(obj)) {
            throw new IllegalArgumentException("An object managed by Realm must be provided. This is an unmanaged object.");
        }
        if (!RealmObject.isValid(obj)) {
            throw new IllegalArgumentException("A valid object managed by Realm must be provided. This object was deleted.");
        }
        RealmObjectProxy proxy = (RealmObjectProxy)obj;
        Row row = proxy.realmGet$proxyState().getRow$realm();
        this.proxyState.setRealm$realm(proxy.realmGet$proxyState().getRealm$realm());
        this.proxyState.setRow$realm(((UncheckedRow)row).convertToChecked());
        this.proxyState.setConstructionFinished();
    }

    DynamicRealmObject(BaseRealm realm, Row row) {
        this.proxyState.setRealm$realm(realm);
        this.proxyState.setRow$realm(row);
        this.proxyState.setConstructionFinished();
    }

    public <E> E get(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
        switch (type) {
            case BOOLEAN: {
                return (E)Boolean.valueOf(this.proxyState.getRow$realm().getBoolean(columnIndex));
            }
            case INTEGER: {
                return (E)Long.valueOf(this.proxyState.getRow$realm().getLong(columnIndex));
            }
            case FLOAT: {
                return (E)Float.valueOf(this.proxyState.getRow$realm().getFloat(columnIndex));
            }
            case DOUBLE: {
                return (E)Double.valueOf(this.proxyState.getRow$realm().getDouble(columnIndex));
            }
            case STRING: {
                return (E)this.proxyState.getRow$realm().getString(columnIndex);
            }
            case BINARY: {
                return (E)this.proxyState.getRow$realm().getBinaryByteArray(columnIndex);
            }
            case DATE: {
                return (E)this.proxyState.getRow$realm().getDate(columnIndex);
            }
            case OBJECT: {
                return (E)this.getObject(fieldName);
            }
            case LIST: {
                return (E)this.getList(fieldName);
            }
        }
        throw new IllegalStateException("Field type not supported: " + (Object)((Object)type));
    }

    public boolean getBoolean(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        try {
            return this.proxyState.getRow$realm().getBoolean(columnIndex);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnIndex, RealmFieldType.BOOLEAN);
            throw e;
        }
    }

    public int getInt(String fieldName) {
        return (int)this.getLong(fieldName);
    }

    public short getShort(String fieldName) {
        return (short)this.getLong(fieldName);
    }

    public long getLong(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        try {
            return this.proxyState.getRow$realm().getLong(columnIndex);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnIndex, RealmFieldType.INTEGER);
            throw e;
        }
    }

    public byte getByte(String fieldName) {
        return (byte)this.getLong(fieldName);
    }

    public float getFloat(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        try {
            return this.proxyState.getRow$realm().getFloat(columnIndex);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnIndex, RealmFieldType.FLOAT);
            throw e;
        }
    }

    public double getDouble(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        try {
            return this.proxyState.getRow$realm().getDouble(columnIndex);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnIndex, RealmFieldType.DOUBLE);
            throw e;
        }
    }

    public byte[] getBlob(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        try {
            return this.proxyState.getRow$realm().getBinaryByteArray(columnIndex);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnIndex, RealmFieldType.BINARY);
            throw e;
        }
    }

    public String getString(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        try {
            return this.proxyState.getRow$realm().getString(columnIndex);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnIndex, RealmFieldType.STRING);
            throw e;
        }
    }

    public Date getDate(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.checkFieldType(fieldName, columnIndex, RealmFieldType.DATE);
        if (this.proxyState.getRow$realm().isNull(columnIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(columnIndex);
    }

    @Nullable
    public DynamicRealmObject getObject(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.checkFieldType(fieldName, columnIndex, RealmFieldType.OBJECT);
        if (this.proxyState.getRow$realm().isNullLink(columnIndex)) {
            return null;
        }
        long linkRowIndex = this.proxyState.getRow$realm().getLink(columnIndex);
        CheckedRow linkRow = this.proxyState.getRow$realm().getTable().getLinkTarget(columnIndex).getCheckedRow(linkRowIndex);
        return new DynamicRealmObject(this.proxyState.getRealm$realm(), linkRow);
    }

    public RealmList<DynamicRealmObject> getList(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        try {
            OsList osList = this.proxyState.getRow$realm().getModelList(columnIndex);
            String className = osList.getTargetTable().getClassName();
            return new RealmList<DynamicRealmObject>(className, osList, this.proxyState.getRealm$realm());
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnIndex, RealmFieldType.LIST);
            throw e;
        }
    }

    public <E> RealmList<E> getList(String fieldName, Class<E> primitiveType) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (primitiveType == null) {
            throw new IllegalArgumentException("Non-null 'primitiveType' required.");
        }
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType realmType = this.classToRealmType(primitiveType);
        try {
            OsList osList = this.proxyState.getRow$realm().getValueList(columnIndex, realmType);
            return new RealmList<E>(primitiveType, osList, this.proxyState.getRealm$realm());
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnIndex, realmType);
            throw e;
        }
    }

    private <E> RealmFieldType classToRealmType(Class<E> primitiveType) {
        if (primitiveType.equals(Integer.class) || primitiveType.equals(Long.class) || primitiveType.equals(Short.class) || primitiveType.equals(Byte.class)) {
            return RealmFieldType.INTEGER_LIST;
        }
        if (primitiveType.equals(Boolean.class)) {
            return RealmFieldType.BOOLEAN_LIST;
        }
        if (primitiveType.equals(String.class)) {
            return RealmFieldType.STRING_LIST;
        }
        if (primitiveType.equals(byte[].class)) {
            return RealmFieldType.BINARY_LIST;
        }
        if (primitiveType.equals(Date.class)) {
            return RealmFieldType.DATE_LIST;
        }
        if (primitiveType.equals(Float.class)) {
            return RealmFieldType.FLOAT_LIST;
        }
        if (primitiveType.equals(Double.class)) {
            return RealmFieldType.DOUBLE_LIST;
        }
        throw new IllegalArgumentException("Unsupported element type. Only primitive types supported. Yours was: " + primitiveType);
    }

    public boolean isNull(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
        switch (type) {
            case OBJECT: {
                return this.proxyState.getRow$realm().isNullLink(columnIndex);
            }
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BINARY: 
            case DATE: {
                return this.proxyState.getRow$realm().isNull(columnIndex);
            }
        }
        return false;
    }

    public boolean hasField(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        return this.proxyState.getRow$realm().hasColumn(fieldName);
    }

    public String[] getFieldNames() {
        this.proxyState.getRealm$realm().checkIfValid();
        String[] keys = new String[(int)this.proxyState.getRow$realm().getColumnCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.proxyState.getRow$realm().getColumnName(i);
        }
        return keys;
    }

    public void set(String fieldName, Object value) {
        this.proxyState.getRealm$realm().checkIfValid();
        boolean isString = value instanceof String;
        String strValue = isString ? (String)value : null;
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
        if (isString && type != RealmFieldType.STRING) {
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.parseBoolean(strValue);
                    break;
                }
                case INTEGER: {
                    value = Long.parseLong(strValue);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(Float.parseFloat(strValue));
                    break;
                }
                case DOUBLE: {
                    value = Double.parseDouble(strValue);
                    break;
                }
                case DATE: {
                    value = JsonUtils.stringToDate(strValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.US, "Field %s is not a String field, and the provide value could not be automatically converted: %s. Use a typedsetter instead", fieldName, value));
                }
            }
        }
        if (value == null) {
            this.setNull(fieldName);
        } else {
            this.setValue(fieldName, value);
        }
    }

    private void setValue(String fieldName, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass == Boolean.class) {
            this.setBoolean(fieldName, (Boolean)value);
        } else if (valueClass == Short.class) {
            this.setShort(fieldName, (Short)value);
        } else if (valueClass == Integer.class) {
            this.setInt(fieldName, (Integer)value);
        } else if (valueClass == Long.class) {
            this.setLong(fieldName, (Long)value);
        } else if (valueClass == Byte.class) {
            this.setByte(fieldName, (Byte)value);
        } else if (valueClass == Float.class) {
            this.setFloat(fieldName, ((Float)value).floatValue());
        } else if (valueClass == Double.class) {
            this.setDouble(fieldName, (Double)value);
        } else if (valueClass == String.class) {
            this.setString(fieldName, (String)value);
        } else if (value instanceof Date) {
            this.setDate(fieldName, (Date)value);
        } else if (value instanceof byte[]) {
            this.setBlob(fieldName, (byte[])value);
        } else if (valueClass == DynamicRealmObject.class) {
            this.setObject(fieldName, (DynamicRealmObject)value);
        } else if (valueClass == RealmList.class) {
            RealmList list = (RealmList)value;
            this.setList(fieldName, list);
        } else {
            throw new IllegalArgumentException("Value is of an type not supported: " + value.getClass());
        }
    }

    public void setBoolean(String fieldName, boolean value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setBoolean(columnIndex, value);
    }

    public void setShort(String fieldName, short value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setLong(columnIndex, value);
    }

    public void setInt(String fieldName, int value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setLong(columnIndex, value);
    }

    public void setLong(String fieldName, long value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setLong(columnIndex, value);
    }

    public void setByte(String fieldName, byte value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setLong(columnIndex, value);
    }

    public void setFloat(String fieldName, float value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setFloat(columnIndex, value);
    }

    public void setDouble(String fieldName, double value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setDouble(columnIndex, value);
    }

    public void setString(String fieldName, @Nullable String value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setString(columnIndex, value);
    }

    public void setBlob(String fieldName, @Nullable byte[] value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        this.proxyState.getRow$realm().setBinaryByteArray(columnIndex, value);
    }

    public void setDate(String fieldName, @Nullable Date value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnIndex);
        } else {
            this.proxyState.getRow$realm().setDate(columnIndex, value);
        }
    }

    public void setObject(String fieldName, @Nullable DynamicRealmObject value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().nullifyLink(columnIndex);
        } else {
            Table inputTable;
            if (value.proxyState.getRealm$realm() == null || value.proxyState.getRow$realm() == null) {
                throw new IllegalArgumentException("Cannot link to objects that are not part of the Realm.");
            }
            if (this.proxyState.getRealm$realm() != value.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Cannot add an object from another Realm instance.");
            }
            Table table = this.proxyState.getRow$realm().getTable().getLinkTarget(columnIndex);
            if (!table.hasSameSchema(inputTable = value.proxyState.getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.US, "Type of object is wrong. Was %s, expected %s", inputTable.getName(), table.getName()));
            }
            this.proxyState.getRow$realm().setLink(columnIndex, value.proxyState.getRow$realm().getIndex());
        }
    }

    public <E> void setList(String fieldName, RealmList<E> list) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (list == null) {
            throw new IllegalArgumentException("Non-null 'list' required");
        }
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType columnType = this.proxyState.getRow$realm().getColumnType(columnIndex);
        switch (columnType) {
            case LIST: {
                E element;
                if (!list.isEmpty() && !((element = list.first()) instanceof DynamicRealmObject) && RealmModel.class.isAssignableFrom(element.getClass())) {
                    throw new IllegalArgumentException("RealmList must contain `DynamicRealmObject's, not Java model classes.");
                }
                this.setModelList(fieldName, list);
                break;
            }
            case INTEGER_LIST: 
            case BOOLEAN_LIST: 
            case STRING_LIST: 
            case BINARY_LIST: 
            case DATE_LIST: 
            case FLOAT_LIST: 
            case DOUBLE_LIST: {
                this.setValueList(fieldName, list, columnType);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Field '%s' is not a list but a %s", new Object[]{fieldName, columnType}));
            }
        }
    }

    private void setModelList(String fieldName, RealmList<DynamicRealmObject> list) {
        int i;
        boolean typeValidated;
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        OsList osList = this.proxyState.getRow$realm().getModelList(columnIndex);
        Table linkTargetTable = osList.getTargetTable();
        String linkTargetTableName = linkTargetTable.getClassName();
        if (list.className == null && list.clazz == null) {
            typeValidated = false;
        } else {
            String listType;
            String string = listType = list.className != null ? list.className : this.proxyState.getRealm$realm().getSchema().getTable(list.clazz).getClassName();
            if (!linkTargetTableName.equals(listType)) {
                throw new IllegalArgumentException(String.format(Locale.US, "The elements in the list are not the proper type. Was %s expected %s.", listType, linkTargetTableName));
            }
            typeValidated = true;
        }
        int listLength = list.size();
        long[] indices = new long[listLength];
        for (i = 0; i < listLength; ++i) {
            RealmObjectProxy obj = list.get(i);
            if (obj.realmGet$proxyState().getRealm$realm() != this.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Each element in 'list' must belong to the same Realm instance.");
            }
            if (!typeValidated && !linkTargetTable.hasSameSchema(obj.realmGet$proxyState().getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.US, "Element at index %d is not the proper type. Was '%s' expected '%s'.", i, obj.realmGet$proxyState().getRow$realm().getTable().getClassName(), linkTargetTableName));
            }
            indices[i] = obj.realmGet$proxyState().getRow$realm().getIndex();
        }
        osList.removeAll();
        for (i = 0; i < listLength; ++i) {
            osList.addRow(indices[i]);
        }
    }

    private <E> void setValueList(String fieldName, RealmList<E> list, RealmFieldType primitiveType) {
        Class elementClass;
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        OsList osList = this.proxyState.getRow$realm().getValueList(columnIndex, primitiveType);
        switch (primitiveType) {
            case INTEGER_LIST: {
                elementClass = Long.class;
                break;
            }
            case BOOLEAN_LIST: {
                elementClass = Boolean.class;
                break;
            }
            case STRING_LIST: {
                elementClass = String.class;
                break;
            }
            case BINARY_LIST: {
                elementClass = byte[].class;
                break;
            }
            case DATE_LIST: {
                elementClass = Date.class;
                break;
            }
            case FLOAT_LIST: {
                elementClass = Float.class;
                break;
            }
            case DOUBLE_LIST: {
                elementClass = Double.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)primitiveType));
            }
        }
        ManagedListOperator<Long> operator = this.getOperator(this.proxyState.getRealm$realm(), osList, primitiveType, elementClass);
        if (list.isManaged() && osList.size() == (long)list.size()) {
            int size = list.size();
            Iterator<E> iterator = list.iterator();
            for (int i = 0; i < size; ++i) {
                E value = iterator.next();
                operator.set(i, value);
            }
        } else {
            osList.removeAll();
            for (E value : list) {
                operator.append(value);
            }
        }
    }

    private <E> ManagedListOperator<E> getOperator(BaseRealm realm, OsList osList, RealmFieldType valueListType, Class<E> valueClass) {
        if (valueListType == RealmFieldType.STRING_LIST) {
            return new StringListOperator(realm, osList, valueClass);
        }
        if (valueListType == RealmFieldType.INTEGER_LIST) {
            return new LongListOperator<String>(realm, osList, valueClass);
        }
        if (valueListType == RealmFieldType.BOOLEAN_LIST) {
            return new BooleanListOperator(realm, osList, (Class<Boolean>)valueClass);
        }
        if (valueListType == RealmFieldType.BINARY_LIST) {
            return new BinaryListOperator(realm, osList, (Class<byte[]>)valueClass);
        }
        if (valueListType == RealmFieldType.DOUBLE_LIST) {
            return new DoubleListOperator(realm, osList, (Class<Double>)valueClass);
        }
        if (valueListType == RealmFieldType.FLOAT_LIST) {
            return new FloatListOperator(realm, osList, (Class<Float>)valueClass);
        }
        if (valueListType == RealmFieldType.DATE_LIST) {
            return new DateListOperator(realm, osList, (Class<Date>)valueClass);
        }
        throw new IllegalArgumentException("Unexpected list type: " + valueListType.name());
    }

    public void setNull(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
        if (type == RealmFieldType.OBJECT) {
            this.proxyState.getRow$realm().nullifyLink(columnIndex);
        } else {
            this.checkIsPrimaryKey(fieldName);
            this.proxyState.getRow$realm().setNull(columnIndex);
        }
    }

    public String getType() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getTable().getClassName();
    }

    public RealmFieldType getFieldType(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnIndex = this.proxyState.getRow$realm().getColumnIndex(fieldName);
        return this.proxyState.getRow$realm().getColumnType(columnIndex);
    }

    private void checkFieldType(String fieldName, long columnIndex, RealmFieldType expectedType) {
        RealmFieldType columnType = this.proxyState.getRow$realm().getColumnType(columnIndex);
        if (columnType != expectedType) {
            String expectedIndefiniteVowel = "";
            if (expectedType == RealmFieldType.INTEGER || expectedType == RealmFieldType.OBJECT) {
                expectedIndefiniteVowel = "n";
            }
            String columnTypeIndefiniteVowel = "";
            if (columnType == RealmFieldType.INTEGER || columnType == RealmFieldType.OBJECT) {
                columnTypeIndefiniteVowel = "n";
            }
            throw new IllegalArgumentException(String.format(Locale.US, "'%s' is not a%s '%s', but a%s '%s'.", new Object[]{fieldName, expectedIndefiniteVowel, expectedType, columnTypeIndefiniteVowel, columnType}));
        }
    }

    public int hashCode() {
        this.proxyState.getRealm$realm().checkIfValid();
        String realmName = this.proxyState.getRealm$realm().getPath();
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        long rowIndex = this.proxyState.getRow$realm().getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicRealmObject other = (DynamicRealmObject)o;
        String path = this.proxyState.getRealm$realm().getPath();
        String otherPath = other.proxyState.getRealm$realm().getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        String otherTableName = other.proxyState.getRow$realm().getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.proxyState.getRow$realm().getIndex() == other.proxyState.getRow$realm().getIndex();
    }

    public String toString() {
        String[] fields;
        this.proxyState.getRealm$realm().checkIfValid();
        if (!this.proxyState.getRow$realm().isAttached()) {
            return "Invalid object";
        }
        String className = this.proxyState.getRow$realm().getTable().getClassName();
        StringBuilder sb = new StringBuilder(className + " = dynamic[");
        for (String field : fields = this.getFieldNames()) {
            long columnIndex = this.proxyState.getRow$realm().getColumnIndex(field);
            RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnIndex);
            sb.append("{");
            sb.append(field).append(":");
            switch (type) {
                case BOOLEAN: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : Boolean.valueOf(this.proxyState.getRow$realm().getBoolean(columnIndex)));
                    break;
                }
                case INTEGER: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : Long.valueOf(this.proxyState.getRow$realm().getLong(columnIndex)));
                    break;
                }
                case FLOAT: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : Float.valueOf(this.proxyState.getRow$realm().getFloat(columnIndex)));
                    break;
                }
                case DOUBLE: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : Double.valueOf(this.proxyState.getRow$realm().getDouble(columnIndex)));
                    break;
                }
                case STRING: {
                    sb.append(this.proxyState.getRow$realm().getString(columnIndex));
                    break;
                }
                case BINARY: {
                    sb.append(Arrays.toString(this.proxyState.getRow$realm().getBinaryByteArray(columnIndex)));
                    break;
                }
                case DATE: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnIndex) ? "null" : this.proxyState.getRow$realm().getDate(columnIndex));
                    break;
                }
                case OBJECT: {
                    sb.append(this.proxyState.getRow$realm().isNullLink(columnIndex) ? "null" : this.proxyState.getRow$realm().getTable().getLinkTarget(columnIndex).getClassName());
                    break;
                }
                case LIST: {
                    String targetClassName = this.proxyState.getRow$realm().getTable().getLinkTarget(columnIndex).getClassName();
                    sb.append(String.format(Locale.US, "RealmList<%s>[%s]", targetClassName, this.proxyState.getRow$realm().getModelList(columnIndex).size()));
                    break;
                }
                case INTEGER_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Long>[%s]", this.proxyState.getRow$realm().getValueList(columnIndex, type).size()));
                    break;
                }
                case BOOLEAN_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Boolean>[%s]", this.proxyState.getRow$realm().getValueList(columnIndex, type).size()));
                    break;
                }
                case STRING_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<String>[%s]", this.proxyState.getRow$realm().getValueList(columnIndex, type).size()));
                    break;
                }
                case BINARY_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<byte[]>[%s]", this.proxyState.getRow$realm().getValueList(columnIndex, type).size()));
                    break;
                }
                case DATE_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Date>[%s]", this.proxyState.getRow$realm().getValueList(columnIndex, type).size()));
                    break;
                }
                case FLOAT_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Float>[%s]", this.proxyState.getRow$realm().getValueList(columnIndex, type).size()));
                    break;
                }
                case DOUBLE_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Double>[%s]", this.proxyState.getRow$realm().getValueList(columnIndex, type).size()));
                    break;
                }
                default: {
                    sb.append("?");
                }
            }
            sb.append("},");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        sb.append("]");
        return sb.toString();
    }

    public RealmResults<DynamicRealmObject> linkingObjects(String srcClassName, String srcFieldName) {
        DynamicRealm realm = (DynamicRealm)this.proxyState.getRealm$realm();
        realm.checkIfValid();
        this.proxyState.getRow$realm().checkIfAttached();
        RealmSchema schema = realm.getSchema();
        RealmObjectSchema realmObjectSchema = schema.get(srcClassName);
        if (realmObjectSchema == null) {
            throw new IllegalArgumentException("Class not found: " + srcClassName);
        }
        if (srcFieldName == null) {
            throw new IllegalArgumentException("Non-null 'srcFieldName' required.");
        }
        if (srcFieldName.contains(".")) {
            throw new IllegalArgumentException(MSG_LINK_QUERY_NOT_SUPPORTED);
        }
        RealmFieldType fieldType = realmObjectSchema.getFieldType(srcFieldName);
        if (fieldType != RealmFieldType.OBJECT && fieldType != RealmFieldType.LIST) {
            throw new IllegalArgumentException(String.format(Locale.US, "Unexpected field type: %1$s. Field type should be either %2$s.%3$s or %2$s.%4$s.", fieldType.name(), RealmFieldType.class.getSimpleName(), RealmFieldType.OBJECT.name(), RealmFieldType.LIST.name()));
        }
        return RealmResults.createDynamicBacklinkResults(realm, (CheckedRow)this.proxyState.getRow$realm(), realmObjectSchema.getTable(), srcFieldName);
    }

    public DynamicRealm getDynamicRealm() {
        BaseRealm realm = this.realmGet$proxyState().getRealm$realm();
        realm.checkIfValid();
        if (!this.isValid()) {
            throw new IllegalStateException("the object is already deleted.");
        }
        return (DynamicRealm)realm;
    }

    @Override
    public void realm$injectObjectContext() {
    }

    @Override
    public ProxyState realmGet$proxyState() {
        return this.proxyState;
    }

    private void checkIsPrimaryKey(String fieldName) {
        RealmObjectSchema objectSchema = this.proxyState.getRealm$realm().getSchema().getSchemaForClass(this.getType());
        if (objectSchema.hasPrimaryKey() && objectSchema.getPrimaryKey().equals(fieldName)) {
            throw new IllegalArgumentException(String.format(Locale.US, "Primary key field '%s' cannot be changed after object was created.", fieldName));
        }
    }
}

