/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.FieldAttribute;
import io.realm.RealmFieldType;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.RealmSchema;
import io.realm.internal.OsObjectStore;
import io.realm.internal.Table;
import java.util.Locale;

class MutableRealmObjectSchema
extends RealmObjectSchema {
    MutableRealmObjectSchema(BaseRealm realm, RealmSchema schema, Table table) {
        super(realm, schema, table, new RealmObjectSchema.DynamicColumnIndices(table));
    }

    @Override
    public RealmObjectSchema setClassName(String className) {
        this.realm.checkNotInSync();
        this.checkEmpty(className);
        String internalTableName = Table.getTableNameForClass(className);
        if (className.length() > Table.CLASS_NAME_MAX_LENGTH) {
            throw new IllegalArgumentException(String.format(Locale.US, "Class name is too long. Limit is %1$d characters: '%2$s' (%3$d)", Table.CLASS_NAME_MAX_LENGTH, className, className.length()));
        }
        if (this.realm.sharedRealm.hasTable(internalTableName)) {
            throw new IllegalArgumentException("Class already exists: " + className);
        }
        String oldTableName = this.table.getName();
        String oldClassName = this.table.getClassName();
        String pkField = OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, oldClassName);
        if (pkField != null) {
            OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, oldClassName, null);
        }
        this.realm.sharedRealm.renameTable(oldTableName, internalTableName);
        if (pkField != null) {
            try {
                OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, className, pkField);
            }
            catch (Exception e) {
                this.realm.sharedRealm.renameTable(this.table.getName(), oldTableName);
                throw e;
            }
        }
        return this;
    }

    private void checkEmpty(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("Null or empty class names are not allowed");
        }
    }

    @Override
    public RealmObjectSchema addField(String fieldName, Class<?> fieldType, FieldAttribute ... attributes) {
        RealmObjectSchema.FieldMetaData metadata = (RealmObjectSchema.FieldMetaData)SUPPORTED_SIMPLE_FIELDS.get(fieldType);
        if (metadata == null) {
            if (SUPPORTED_LINKED_FIELDS.containsKey(fieldType)) {
                throw new IllegalArgumentException("Use addRealmObjectField() instead to add fields that link to other RealmObjects: " + fieldName);
            }
            throw new IllegalArgumentException(String.format(Locale.US, "Realm doesn't support this field type: %s(%s)", fieldName, fieldType));
        }
        if (MutableRealmObjectSchema.containsAttribute(attributes, FieldAttribute.PRIMARY_KEY)) {
            this.checkAddPrimaryKeyForSync();
        }
        this.checkNewFieldName(fieldName);
        boolean nullable = metadata.defaultNullable;
        if (MutableRealmObjectSchema.containsAttribute(attributes, FieldAttribute.REQUIRED)) {
            nullable = false;
        }
        long columnIndex = this.table.addColumn(metadata.fieldType, fieldName, nullable);
        try {
            this.addModifiers(fieldName, attributes);
        }
        catch (Exception e) {
            this.table.removeColumn(columnIndex);
            throw e;
        }
        return this;
    }

    @Override
    public RealmObjectSchema addRealmObjectField(String fieldName, RealmObjectSchema objectSchema) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        this.table.addColumnLink(RealmFieldType.OBJECT, fieldName, this.realm.sharedRealm.getTable(Table.getTableNameForClass(objectSchema.getClassName())));
        return this;
    }

    @Override
    public RealmObjectSchema addRealmListField(String fieldName, RealmObjectSchema objectSchema) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        this.table.addColumnLink(RealmFieldType.LIST, fieldName, this.realm.sharedRealm.getTable(Table.getTableNameForClass(objectSchema.getClassName())));
        return this;
    }

    @Override
    public RealmObjectSchema addRealmListField(String fieldName, Class<?> primitiveType) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        RealmObjectSchema.FieldMetaData metadata = (RealmObjectSchema.FieldMetaData)SUPPORTED_SIMPLE_FIELDS.get(primitiveType);
        if (metadata == null) {
            if (primitiveType.equals(RealmObjectSchema.class) || RealmModel.class.isAssignableFrom(primitiveType)) {
                throw new IllegalArgumentException("Use 'addRealmListField(String name, RealmObjectSchema schema)' instead to add lists that link to other RealmObjects: " + fieldName);
            }
            throw new IllegalArgumentException(String.format(Locale.US, "RealmList does not support lists with this type: %s(%s)", fieldName, primitiveType));
        }
        this.table.addColumn(metadata.listType, fieldName, metadata.defaultNullable);
        return this;
    }

    @Override
    public RealmObjectSchema removeField(String fieldName) {
        this.realm.checkNotInSync();
        MutableRealmObjectSchema.checkLegalName(fieldName);
        if (!this.hasField(fieldName)) {
            throw new IllegalStateException(fieldName + " does not exist.");
        }
        long columnIndex = this.getColumnIndex(fieldName);
        String className = this.getClassName();
        if (fieldName.equals(OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, className))) {
            OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, className, fieldName);
        }
        this.table.removeColumn(columnIndex);
        return this;
    }

    @Override
    public RealmObjectSchema renameField(String currentFieldName, String newFieldName) {
        this.realm.checkNotInSync();
        MutableRealmObjectSchema.checkLegalName(currentFieldName);
        this.checkFieldExists(currentFieldName);
        MutableRealmObjectSchema.checkLegalName(newFieldName);
        this.checkFieldNameIsAvailable(newFieldName);
        long columnIndex = this.getColumnIndex(currentFieldName);
        this.table.renameColumn(columnIndex, newFieldName);
        return this;
    }

    @Override
    public RealmObjectSchema addIndex(String fieldName) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        long columnIndex = this.getColumnIndex(fieldName);
        if (this.table.hasSearchIndex(columnIndex)) {
            throw new IllegalStateException(fieldName + " already has an index.");
        }
        this.table.addSearchIndex(columnIndex);
        return this;
    }

    @Override
    public RealmObjectSchema removeIndex(String fieldName) {
        this.realm.checkNotInSync();
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        long columnIndex = this.getColumnIndex(fieldName);
        if (!this.table.hasSearchIndex(columnIndex)) {
            throw new IllegalStateException("Field is not indexed: " + fieldName);
        }
        this.table.removeSearchIndex(columnIndex);
        return this;
    }

    @Override
    public RealmObjectSchema addPrimaryKey(String fieldName) {
        this.checkAddPrimaryKeyForSync();
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        String currentPKField = OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName());
        if (currentPKField != null) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Field '%s' has been already defined as primary key.", currentPKField));
        }
        long columnIndex = this.getColumnIndex(fieldName);
        if (!this.table.hasSearchIndex(columnIndex)) {
            this.table.addSearchIndex(columnIndex);
        }
        OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName(), fieldName);
        return this;
    }

    @Override
    public RealmObjectSchema removePrimaryKey() {
        this.realm.checkNotInSync();
        String pkField = OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName());
        if (pkField == null) {
            throw new IllegalStateException(this.getClassName() + " doesn't have a primary key.");
        }
        long columnIndex = this.table.getColumnIndex(pkField);
        if (this.table.hasSearchIndex(columnIndex)) {
            this.table.removeSearchIndex(columnIndex);
        }
        OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName(), null);
        return this;
    }

    @Override
    public RealmObjectSchema setRequired(String fieldName, boolean required) {
        long columnIndex = this.table.getColumnIndex(fieldName);
        boolean currentColumnRequired = this.isRequired(fieldName);
        RealmFieldType type = this.table.getColumnType(columnIndex);
        if (type == RealmFieldType.OBJECT) {
            throw new IllegalArgumentException("Cannot modify the required state for RealmObject references: " + fieldName);
        }
        if (type == RealmFieldType.LIST) {
            throw new IllegalArgumentException("Cannot modify the required state for RealmList references: " + fieldName);
        }
        if (required && currentColumnRequired) {
            throw new IllegalStateException("Field is already required: " + fieldName);
        }
        if (!required && !currentColumnRequired) {
            throw new IllegalStateException("Field is already nullable: " + fieldName);
        }
        if (required) {
            this.table.convertColumnToNotNullable(columnIndex);
        } else {
            this.table.convertColumnToNullable(columnIndex);
        }
        return this;
    }

    @Override
    public RealmObjectSchema setNullable(String fieldName, boolean nullable) {
        this.setRequired(fieldName, !nullable);
        return this;
    }

    @Override
    public RealmObjectSchema transform(RealmObjectSchema.Function function) {
        if (function != null) {
            long size = this.table.size();
            for (long i = 0L; i < size; ++i) {
                function.apply(new DynamicRealmObject(this.realm, this.table.getCheckedRow(i)));
            }
        }
        return this;
    }

    private void addModifiers(String fieldName, FieldAttribute[] attributes) {
        boolean indexAdded = false;
        try {
            if (attributes != null && attributes.length > 0) {
                if (MutableRealmObjectSchema.containsAttribute(attributes, FieldAttribute.INDEXED)) {
                    this.addIndex(fieldName);
                    indexAdded = true;
                }
                if (MutableRealmObjectSchema.containsAttribute(attributes, FieldAttribute.PRIMARY_KEY)) {
                    this.addPrimaryKey(fieldName);
                    indexAdded = true;
                }
            }
        }
        catch (Exception e) {
            long columnIndex = this.getColumnIndex(fieldName);
            if (indexAdded) {
                this.table.removeSearchIndex(columnIndex);
            }
            throw (RuntimeException)e;
        }
    }

    static boolean containsAttribute(FieldAttribute[] attributeList, FieldAttribute attribute) {
        if (attributeList == null || attributeList.length == 0) {
            return false;
        }
        for (FieldAttribute anAttributeList : attributeList) {
            if (anAttributeList != attribute) continue;
            return true;
        }
        return false;
    }

    private void checkNewFieldName(String fieldName) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
    }

    private void checkFieldNameIsAvailable(String fieldName) {
        if (this.table.getColumnIndex(fieldName) != -1L) {
            throw new IllegalArgumentException("Field already exists in '" + this.getClassName() + "': " + fieldName);
        }
    }

    private void checkAddPrimaryKeyForSync() {
        if (this.realm.configuration.isSyncConfiguration()) {
            throw new UnsupportedOperationException("'addPrimaryKey' is not supported by synced Realms.");
        }
    }
}

