/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.realm.BaseRealm;
import io.realm.BinaryListOperator;
import io.realm.BooleanListOperator;
import io.realm.DateListOperator;
import io.realm.DoubleListOperator;
import io.realm.DynamicRealm;
import io.realm.FloatListOperator;
import io.realm.LongListOperator;
import io.realm.ManagedListOperator;
import io.realm.OrderedRealmCollection;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.OrderedRealmCollectionSnapshot;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmModel;
import io.realm.RealmModelListOperator;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.StringListOperator;
import io.realm.internal.InvalidRow;
import io.realm.internal.OsList;
import io.realm.internal.OsResults;
import io.realm.internal.RealmObjectProxy;
import io.realm.rx.CollectionChange;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RealmList<E>
extends AbstractList<E>
implements OrderedRealmCollection<E> {
    private static final String ONLY_IN_MANAGED_MODE_MESSAGE = "This method is only available in managed mode.";
    static final String ALLOWED_ONLY_FOR_REALM_MODEL_ELEMENT_MESSAGE = "This feature is available only when the element type is implementing RealmModel.";
    public static final String REMOVE_OUTSIDE_TRANSACTION_ERROR = "Objects can only be removed from inside a write transaction.";
    @Nullable
    protected Class<E> clazz;
    @Nullable
    protected String className;
    final ManagedListOperator<E> osListOperator;
    protected final BaseRealm realm;
    private List<E> unmanagedList;
    private OsResults osResults;

    public RealmList() {
        this.realm = null;
        this.osListOperator = null;
        this.unmanagedList = new ArrayList();
    }

    public RealmList(E ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException("The objects argument cannot be null");
        }
        this.realm = null;
        this.osListOperator = null;
        this.unmanagedList = new ArrayList(objects.length);
        Collections.addAll(this.unmanagedList, objects);
    }

    RealmList(Class<E> clazz, OsList osList, BaseRealm realm) {
        this.clazz = clazz;
        this.osListOperator = this.getOperator(realm, osList, clazz, null);
        this.realm = realm;
    }

    RealmList(String className, OsList osList, BaseRealm realm) {
        this.realm = realm;
        this.className = className;
        this.osListOperator = this.getOperator(realm, osList, null, className);
    }

    OsList getOsList() {
        return this.osListOperator.getOsList();
    }

    @Override
    public boolean isValid() {
        if (this.realm == null) {
            return true;
        }
        if (this.realm.isClosed()) {
            return false;
        }
        return this.isAttached();
    }

    @Override
    public boolean isManaged() {
        return this.realm != null;
    }

    private boolean isAttached() {
        return this.osListOperator != null && this.osListOperator.isValid();
    }

    @Override
    public void add(int location, @Nullable E element) {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.insert(location, element);
        } else {
            this.unmanagedList.add(location, element);
        }
        ++this.modCount;
    }

    @Override
    public boolean add(@Nullable E object) {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.append(object);
        } else {
            this.unmanagedList.add(object);
        }
        ++this.modCount;
        return true;
    }

    @Override
    public E set(int location, @Nullable E object) {
        E oldObject;
        if (this.isManaged()) {
            this.checkValidRealm();
            oldObject = this.osListOperator.set(location, object);
        } else {
            oldObject = this.unmanagedList.set(location, object);
        }
        return oldObject;
    }

    public void move(int oldPos, int newPos) {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.move(oldPos, newPos);
        } else {
            int listSize = this.unmanagedList.size();
            if (oldPos < 0 || listSize <= oldPos) {
                throw new IndexOutOfBoundsException("Invalid index " + oldPos + ", size is " + listSize);
            }
            if (newPos < 0 || listSize <= newPos) {
                throw new IndexOutOfBoundsException("Invalid index " + newPos + ", size is " + listSize);
            }
            E object = this.unmanagedList.remove(oldPos);
            if (newPos > oldPos) {
                this.unmanagedList.add(newPos - 1, object);
            } else {
                this.unmanagedList.add(newPos, object);
            }
        }
    }

    @Override
    public void clear() {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.removeAll();
        } else {
            this.unmanagedList.clear();
        }
        ++this.modCount;
    }

    @Override
    public E remove(int location) {
        E removedItem;
        if (this.isManaged()) {
            this.checkValidRealm();
            removedItem = this.get(location);
            this.osListOperator.remove(location);
        } else {
            removedItem = this.unmanagedList.remove(location);
        }
        ++this.modCount;
        return removedItem;
    }

    @Override
    public boolean remove(@Nullable Object object) {
        if (this.isManaged() && !this.realm.isInTransaction()) {
            throw new IllegalStateException(REMOVE_OUTSIDE_TRANSACTION_ERROR);
        }
        return super.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.isManaged() && !this.realm.isInTransaction()) {
            throw new IllegalStateException(REMOVE_OUTSIDE_TRANSACTION_ERROR);
        }
        return super.removeAll(collection);
    }

    @Override
    public boolean deleteFirstFromRealm() {
        if (this.isManaged()) {
            if (!this.osListOperator.isEmpty()) {
                this.deleteFromRealm(0);
                ++this.modCount;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public boolean deleteLastFromRealm() {
        if (this.isManaged()) {
            if (!this.osListOperator.isEmpty()) {
                this.osListOperator.deleteLast();
                ++this.modCount;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    @Nullable
    public E get(int location) {
        if (this.isManaged()) {
            this.checkValidRealm();
            return this.osListOperator.get(location);
        }
        return this.unmanagedList.get(location);
    }

    @Override
    @Nullable
    public E first() {
        return this.firstImpl(true, null);
    }

    @Override
    @Nullable
    public E first(@Nullable E defaultValue) {
        return this.firstImpl(false, defaultValue);
    }

    @Nullable
    private E firstImpl(boolean shouldThrow, @Nullable E defaultValue) {
        if (this.isManaged()) {
            this.checkValidRealm();
            if (!this.osListOperator.isEmpty()) {
                return this.get(0);
            }
        } else if (this.unmanagedList != null && !this.unmanagedList.isEmpty()) {
            return this.unmanagedList.get(0);
        }
        if (shouldThrow) {
            throw new IndexOutOfBoundsException("The list is empty.");
        }
        return defaultValue;
    }

    @Override
    @Nullable
    public E last() {
        return this.lastImpl(true, null);
    }

    @Override
    @Nullable
    public E last(@Nullable E defaultValue) {
        return this.lastImpl(false, defaultValue);
    }

    @Nullable
    private E lastImpl(boolean shouldThrow, @Nullable E defaultValue) {
        if (this.isManaged()) {
            this.checkValidRealm();
            if (!this.osListOperator.isEmpty()) {
                return this.get(this.osListOperator.size() - 1);
            }
        } else if (this.unmanagedList != null && !this.unmanagedList.isEmpty()) {
            return this.unmanagedList.get(this.unmanagedList.size() - 1);
        }
        if (shouldThrow) {
            throw new IndexOutOfBoundsException("The list is empty.");
        }
        return defaultValue;
    }

    @Override
    public RealmResults<E> sort(String fieldName) {
        return this.sort(fieldName, Sort.ASCENDING);
    }

    @Override
    public RealmResults<E> sort(String fieldName, Sort sortOrder) {
        if (this.isManaged()) {
            return this.where().findAllSorted(fieldName, sortOrder);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public RealmResults<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    @Override
    public RealmResults<E> sort(String[] fieldNames, Sort[] sortOrders) {
        if (this.isManaged()) {
            return this.where().findAllSorted(fieldNames, sortOrders);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public void deleteFromRealm(int location) {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.delete(location);
            ++this.modCount;
        } else {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }
    }

    @Override
    public int size() {
        if (this.isManaged()) {
            this.checkValidRealm();
            return this.osListOperator.size();
        }
        return this.unmanagedList.size();
    }

    @Override
    public RealmQuery<E> where() {
        if (this.isManaged()) {
            this.checkValidRealm();
            if (!this.osListOperator.forRealmModel()) {
                throw new UnsupportedOperationException(ALLOWED_ONLY_FOR_REALM_MODEL_ELEMENT_MESSAGE);
            }
            return RealmQuery.createQueryFromList(this);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    @Nullable
    public Number min(String fieldName) {
        return this.where().min(fieldName);
    }

    @Override
    @Nullable
    public Number max(String fieldName) {
        return this.where().max(fieldName);
    }

    @Override
    public Number sum(String fieldName) {
        return this.where().sum(fieldName);
    }

    @Override
    public double average(String fieldName) {
        return this.where().average(fieldName);
    }

    @Override
    @Nullable
    public Date maxDate(String fieldName) {
        return this.where().maximumDate(fieldName);
    }

    @Override
    @Nullable
    public Date minDate(String fieldName) {
        return this.where().minimumDate(fieldName);
    }

    @Override
    public boolean deleteAllFromRealm() {
        if (this.isManaged()) {
            this.checkValidRealm();
            if (!this.osListOperator.isEmpty()) {
                this.osListOperator.deleteAll();
                ++this.modCount;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public boolean load() {
        return true;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        if (this.isManaged()) {
            RealmObjectProxy proxy;
            this.realm.checkIfValid();
            if (object instanceof RealmObjectProxy && (proxy = (RealmObjectProxy)object).realmGet$proxyState().getRow$realm() == InvalidRow.INSTANCE) {
                return false;
            }
            return super.contains(object);
        }
        return this.unmanagedList.contains(object);
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        if (this.isManaged()) {
            return new RealmItr();
        }
        return super.iterator();
    }

    @Override
    @Nonnull
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @Nonnull
    public ListIterator<E> listIterator(int location) {
        if (this.isManaged()) {
            return new RealmListItr(location);
        }
        return super.listIterator(location);
    }

    private void checkValidRealm() {
        this.realm.checkIfValid();
    }

    @Override
    public OrderedRealmCollectionSnapshot<E> createSnapshot() {
        if (!this.isManaged()) {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }
        this.checkValidRealm();
        if (!this.osListOperator.forRealmModel()) {
            throw new UnsupportedOperationException(ALLOWED_ONLY_FOR_REALM_MODEL_ELEMENT_MESSAGE);
        }
        if (this.className != null) {
            return new OrderedRealmCollectionSnapshot(this.realm, new OsResults(this.realm.sharedRealm, this.osListOperator.getOsList(), null), this.className);
        }
        return new OrderedRealmCollectionSnapshot<E>(this.realm, new OsResults(this.realm.sharedRealm, this.osListOperator.getOsList(), null), this.clazz);
    }

    @Override
    public String toString() {
        String separator = ",";
        StringBuilder sb = new StringBuilder();
        if (!this.isManaged()) {
            sb.append("RealmList<?>@[");
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                E value = this.get(i);
                if (value instanceof RealmModel) {
                    sb.append(System.identityHashCode(value));
                } else if (value instanceof byte[]) {
                    sb.append("byte[").append(((byte[])value).length).append("]");
                } else {
                    sb.append(value);
                }
                sb.append(",");
            }
            if (0 < this.size()) {
                sb.setLength(sb.length() - ",".length());
            }
            sb.append("]");
        } else {
            sb.append("RealmList<");
            if (this.className != null) {
                sb.append(this.className);
            } else if (RealmList.isClassForRealmModel(this.clazz)) {
                sb.append(this.realm.getSchema().getSchemaForClass(this.clazz).getClassName());
            } else if (this.clazz == byte[].class) {
                sb.append(this.clazz.getSimpleName());
            } else {
                sb.append(this.clazz.getName());
            }
            sb.append(">@[");
            if (!this.isAttached()) {
                sb.append("invalid");
            } else if (RealmList.isClassForRealmModel(this.clazz)) {
                for (int i = 0; i < this.size(); ++i) {
                    sb.append(((RealmObjectProxy)this.get(i)).realmGet$proxyState().getRow$realm().getIndex());
                    sb.append(",");
                }
                if (0 < this.size()) {
                    sb.setLength(sb.length() - ",".length());
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    E value = this.get(i);
                    if (value instanceof byte[]) {
                        sb.append("byte[").append(((byte[])value).length).append("]");
                    } else {
                        sb.append(value);
                    }
                    sb.append(",");
                }
                if (0 < this.size()) {
                    sb.setLength(sb.length() - ",".length());
                }
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public Flowable<RealmList<E>> asFlowable() {
        if (this.realm instanceof Realm) {
            return this.realm.configuration.getRxFactory().from((Realm)this.realm, this);
        }
        if (this.realm instanceof DynamicRealm) {
            Flowable results = this.realm.configuration.getRxFactory().from((DynamicRealm)this.realm, this);
            return results;
        }
        throw new UnsupportedOperationException(this.realm.getClass() + " does not support RxJava2.");
    }

    public Observable<CollectionChange<RealmList<E>>> asChangesetObservable() {
        if (this.realm instanceof Realm) {
            return this.realm.configuration.getRxFactory().changesetsFrom((Realm)this.realm, this);
        }
        if (this.realm instanceof DynamicRealm) {
            DynamicRealm dynamicRealm = (DynamicRealm)this.realm;
            RealmList dynamicResults = this;
            return this.realm.configuration.getRxFactory().changesetsFrom(dynamicRealm, dynamicResults);
        }
        throw new UnsupportedOperationException(this.realm.getClass() + " does not support RxJava2.");
    }

    private void checkForAddRemoveListener(@Nullable Object listener, boolean checkListener) {
        if (checkListener && listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        this.realm.checkIfValid();
        this.realm.sharedRealm.capabilities.checkCanDeliverNotification("Listeners cannot be used on current thread.");
    }

    public void addChangeListener(OrderedRealmCollectionChangeListener<RealmList<E>> listener) {
        this.checkForAddRemoveListener(listener, true);
        if (this.osListOperator.forRealmModel()) {
            this.getOrCreateOsResultsForListener().addListener(this, listener);
        } else {
            this.osListOperator.getOsList().addListener(this, listener);
        }
    }

    public void removeChangeListener(OrderedRealmCollectionChangeListener<RealmList<E>> listener) {
        this.checkForAddRemoveListener(listener, true);
        if (this.osListOperator.forRealmModel()) {
            this.getOrCreateOsResultsForListener().removeListener(this, listener);
        } else {
            this.osListOperator.getOsList().removeListener(this, listener);
        }
    }

    public void addChangeListener(RealmChangeListener<RealmList<E>> listener) {
        this.checkForAddRemoveListener(listener, true);
        if (this.osListOperator.forRealmModel()) {
            this.getOrCreateOsResultsForListener().addListener(this, listener);
        } else {
            this.osListOperator.getOsList().addListener(this, listener);
        }
    }

    public void removeChangeListener(RealmChangeListener<RealmList<E>> listener) {
        this.checkForAddRemoveListener(listener, true);
        if (this.osListOperator.forRealmModel()) {
            this.getOrCreateOsResultsForListener().removeListener(this, listener);
        } else {
            this.osListOperator.getOsList().removeListener(this, listener);
        }
    }

    public void removeAllChangeListeners() {
        this.checkForAddRemoveListener(null, false);
        if (this.osListOperator.forRealmModel()) {
            this.getOrCreateOsResultsForListener().removeAllListeners();
        } else {
            this.osListOperator.getOsList().removeAllListeners();
        }
    }

    private static boolean isClassForRealmModel(Class<?> clazz) {
        return RealmModel.class.isAssignableFrom(clazz);
    }

    private ManagedListOperator<E> getOperator(BaseRealm realm, OsList osList, @Nullable Class<E> clazz, @Nullable String className) {
        if (clazz == null || RealmList.isClassForRealmModel(clazz)) {
            return new RealmModelListOperator<E>(realm, osList, clazz, className);
        }
        if (clazz == String.class) {
            return new StringListOperator(realm, osList, clazz);
        }
        if (clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class) {
            return new LongListOperator<String>(realm, osList, clazz);
        }
        if (clazz == Boolean.class) {
            return new BooleanListOperator(realm, osList, (Class<Boolean>)clazz);
        }
        if (clazz == byte[].class) {
            return new BinaryListOperator(realm, osList, (Class<byte[]>)clazz);
        }
        if (clazz == Double.class) {
            return new DoubleListOperator(realm, osList, (Class<Double>)clazz);
        }
        if (clazz == Float.class) {
            return new FloatListOperator(realm, osList, (Class<Float>)clazz);
        }
        if (clazz == Date.class) {
            return new DateListOperator(realm, osList, (Class<Date>)clazz);
        }
        throw new IllegalArgumentException("Unexpected value class: " + clazz.getName());
    }

    private OsResults getOrCreateOsResultsForListener() {
        if (this.osResults == null) {
            this.osResults = new OsResults(this.realm.sharedRealm, this.osListOperator.getOsList(), null);
        }
        return this.osResults;
    }

    static /* synthetic */ int access$100(RealmList x0) {
        return x0.modCount;
    }

    private class RealmListItr
    extends RealmItr
    implements ListIterator<E> {
        RealmListItr(int index) {
            if (index < 0 || index > RealmList.this.size()) {
                throw new IndexOutOfBoundsException("Starting location must be a valid index: [0, " + (RealmList.this.size() - 1) + "]. Index was " + index);
            }
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        @Nullable
        public E previous() {
            this.checkConcurrentModification();
            int i = this.cursor - 1;
            try {
                Object previous = RealmList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkConcurrentModification();
                throw new NoSuchElementException("Cannot access index less than zero. This was " + i + ". Remember to check hasPrevious() before using previous().");
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(@Nullable E e) {
            RealmList.this.realm.checkIfValid();
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkConcurrentModification();
            try {
                RealmList.this.set(this.lastRet, e);
                this.expectedModCount = RealmList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(@Nullable E e) {
            RealmList.this.realm.checkIfValid();
            this.checkConcurrentModification();
            try {
                int i = this.cursor;
                RealmList.this.add(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
                this.expectedModCount = RealmList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class RealmItr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = RealmList.access$100(RealmList.this);

        private RealmItr() {
        }

        @Override
        public boolean hasNext() {
            RealmList.this.checkValidRealm();
            this.checkConcurrentModification();
            return this.cursor != RealmList.this.size();
        }

        @Override
        @Nullable
        public E next() {
            RealmList.this.checkValidRealm();
            this.checkConcurrentModification();
            int i = this.cursor;
            try {
                Object next = RealmList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkConcurrentModification();
                throw new NoSuchElementException("Cannot access index " + i + " when size is " + RealmList.this.size() + ". Remember to check hasNext() before using next().");
            }
        }

        @Override
        public void remove() {
            RealmList.this.checkValidRealm();
            if (this.lastRet < 0) {
                throw new IllegalStateException("Cannot call remove() twice. Must call next() in between.");
            }
            this.checkConcurrentModification();
            try {
                RealmList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = RealmList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkConcurrentModification() {
            if (RealmList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

