/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.SuppressLint;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.realm.BaseRealm;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.OrderedRealmCollectionImpl;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.Sort;
import io.realm.internal.CheckedRow;
import io.realm.internal.OsResults;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.rx.CollectionChange;
import javax.annotation.Nullable;

public class RealmResults<E>
extends OrderedRealmCollectionImpl<E> {
    @SuppressLint(value={"unused"})
    static <T extends RealmModel> RealmResults<T> createBacklinkResults(BaseRealm realm, Row row, Class<T> srcTableType, String srcFieldName) {
        UncheckedRow uncheckedRow = (UncheckedRow)row;
        Table srcTable = realm.getSchema().getTable(srcTableType);
        return new RealmResults<T>(realm, OsResults.createBacklinksCollection(realm.sharedRealm, uncheckedRow, srcTable, srcFieldName), srcTableType);
    }

    static RealmResults<DynamicRealmObject> createDynamicBacklinkResults(DynamicRealm realm, CheckedRow row, Table srcTable, String srcFieldName) {
        String srcClassName = Table.getClassNameForTable(srcTable.getName());
        return new RealmResults<DynamicRealmObject>((BaseRealm)realm, OsResults.createBacklinksCollection(realm.sharedRealm, row, srcTable, srcFieldName), srcClassName);
    }

    RealmResults(BaseRealm realm, OsResults osResults, Class<E> clazz) {
        super(realm, osResults, clazz);
    }

    RealmResults(BaseRealm realm, OsResults osResults, String className) {
        super(realm, osResults, className);
    }

    @Override
    public RealmQuery<E> where() {
        this.realm.checkIfValid();
        return RealmQuery.createQueryFromResult(this);
    }

    @Override
    public RealmResults<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    @Override
    public boolean isLoaded() {
        this.realm.checkIfValid();
        return this.osResults.isLoaded();
    }

    @Override
    public boolean load() {
        this.realm.checkIfValid();
        this.osResults.load();
        return true;
    }

    public void addChangeListener(RealmChangeListener<RealmResults<E>> listener) {
        this.checkForAddRemoveListener(listener, true);
        this.osResults.addListener(this, listener);
    }

    public void addChangeListener(OrderedRealmCollectionChangeListener<RealmResults<E>> listener) {
        this.checkForAddRemoveListener(listener, true);
        this.osResults.addListener(this, listener);
    }

    private void checkForAddRemoveListener(@Nullable Object listener, boolean checkListener) {
        if (checkListener && listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        this.realm.checkIfValid();
        this.realm.sharedRealm.capabilities.checkCanDeliverNotification("Listeners cannot be used on current thread.");
    }

    public void removeAllChangeListeners() {
        this.checkForAddRemoveListener(null, false);
        this.osResults.removeAllListeners();
    }

    public void removeChangeListener(RealmChangeListener<RealmResults<E>> listener) {
        this.checkForAddRemoveListener(listener, true);
        this.osResults.removeListener(this, listener);
    }

    public void removeChangeListener(OrderedRealmCollectionChangeListener<RealmResults<E>> listener) {
        this.checkForAddRemoveListener(listener, true);
        this.osResults.removeListener(this, listener);
    }

    public Flowable<RealmResults<E>> asFlowable() {
        if (this.realm instanceof Realm) {
            return this.realm.configuration.getRxFactory().from((Realm)this.realm, this);
        }
        if (this.realm instanceof DynamicRealm) {
            DynamicRealm dynamicRealm = (DynamicRealm)this.realm;
            RealmResults dynamicResults = this;
            Flowable results = this.realm.configuration.getRxFactory().from(dynamicRealm, dynamicResults);
            return results;
        }
        throw new UnsupportedOperationException(this.realm.getClass() + " does not support RxJava2.");
    }

    public Observable<CollectionChange<RealmResults<E>>> asChangesetObservable() {
        if (this.realm instanceof Realm) {
            return this.realm.configuration.getRxFactory().changesetsFrom((Realm)this.realm, this);
        }
        if (this.realm instanceof DynamicRealm) {
            DynamicRealm dynamicRealm = (DynamicRealm)this.realm;
            RealmResults dynamicResults = this;
            return this.realm.configuration.getRxFactory().changesetsFrom(dynamicRealm, dynamicResults);
        }
        throw new UnsupportedOperationException(this.realm.getClass() + " does not support RxJava2.");
    }
}

