/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.FieldAttribute;
import io.realm.ImmutableRealmObjectSchema;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.internal.ColumnIndices;
import io.realm.internal.ColumnInfo;
import io.realm.internal.Table;
import io.realm.internal.Util;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class RealmSchema {
    static final String EMPTY_STRING_MSG = "Null or empty class names are not allowed";
    private final Map<String, Table> dynamicClassToTable = new HashMap<String, Table>();
    private final Map<Class<? extends RealmModel>, Table> classToTable = new HashMap<Class<? extends RealmModel>, Table>();
    private final Map<Class<? extends RealmModel>, RealmObjectSchema> classToSchema = new HashMap<Class<? extends RealmModel>, RealmObjectSchema>();
    private final Map<String, RealmObjectSchema> dynamicClassToSchema = new HashMap<String, RealmObjectSchema>();
    final BaseRealm realm;
    private final ColumnIndices columnIndices;

    RealmSchema(BaseRealm realm, @Nullable ColumnIndices columnIndices) {
        this.realm = realm;
        this.columnIndices = columnIndices;
    }

    @Nullable
    public abstract RealmObjectSchema get(String var1);

    public Set<RealmObjectSchema> getAll() {
        int tableCount = (int)this.realm.getSharedRealm().size();
        LinkedHashSet<RealmObjectSchema> schemas = new LinkedHashSet<RealmObjectSchema>(tableCount);
        for (int i = 0; i < tableCount; ++i) {
            RealmObjectSchema objectSchema = this.get(Table.getClassNameForTable(this.realm.getSharedRealm().getTableName(i)));
            if (objectSchema == null) continue;
            schemas.add(objectSchema);
        }
        return schemas;
    }

    public abstract RealmObjectSchema create(String var1);

    public abstract RealmObjectSchema createWithPrimaryKeyField(String var1, String var2, Class<?> var3, FieldAttribute ... var4);

    public abstract void remove(String var1);

    public abstract RealmObjectSchema rename(String var1, String var2);

    public boolean contains(String className) {
        return this.realm.getSharedRealm().hasTable(Table.getTableNameForClass(className));
    }

    void checkNotEmpty(String str, String error) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException(error);
        }
    }

    void checkHasTable(String className, String errorMsg) {
        String internalTableName = Table.getTableNameForClass(className);
        if (!this.realm.getSharedRealm().hasTable(internalTableName)) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    Table getTable(String className) {
        String tableName = Table.getTableNameForClass(className);
        Table table = this.dynamicClassToTable.get(tableName);
        if (table != null) {
            return table;
        }
        table = this.realm.getSharedRealm().getTable(tableName);
        this.dynamicClassToTable.put(tableName, table);
        return table;
    }

    Table getTable(Class<? extends RealmModel> clazz) {
        Table table = this.classToTable.get(clazz);
        if (table != null) {
            return table;
        }
        Class<? extends RealmModel> originalClass = Util.getOriginalModelClass(clazz);
        if (this.isProxyClass(originalClass, clazz)) {
            table = this.classToTable.get(originalClass);
        }
        if (table == null) {
            String tableName = Table.getTableNameForClass(this.realm.getConfiguration().getSchemaMediator().getSimpleClassName(originalClass));
            table = this.realm.getSharedRealm().getTable(tableName);
            this.classToTable.put(originalClass, table);
        }
        if (this.isProxyClass(originalClass, clazz)) {
            this.classToTable.put(clazz, table);
        }
        return table;
    }

    RealmObjectSchema getSchemaForClass(Class<? extends RealmModel> clazz) {
        RealmObjectSchema classSchema = this.classToSchema.get(clazz);
        if (classSchema != null) {
            return classSchema;
        }
        Class<? extends RealmModel> originalClass = Util.getOriginalModelClass(clazz);
        if (this.isProxyClass(originalClass, clazz)) {
            classSchema = this.classToSchema.get(originalClass);
        }
        if (classSchema == null) {
            Table table = this.getTable(clazz);
            classSchema = new ImmutableRealmObjectSchema(this.realm, this, table, this.getColumnInfo(originalClass));
            this.classToSchema.put(originalClass, classSchema);
        }
        if (this.isProxyClass(originalClass, clazz)) {
            this.classToSchema.put(clazz, classSchema);
        }
        return classSchema;
    }

    RealmObjectSchema getSchemaForClass(String className) {
        String tableName = Table.getTableNameForClass(className);
        RealmObjectSchema dynamicSchema = this.dynamicClassToSchema.get(tableName);
        if (dynamicSchema == null || !dynamicSchema.getTable().isValid() || !dynamicSchema.getClassName().equals(className)) {
            if (!this.realm.getSharedRealm().hasTable(tableName)) {
                throw new IllegalArgumentException("The class " + className + " doesn't exist in this Realm.");
            }
            dynamicSchema = new ImmutableRealmObjectSchema(this.realm, this, this.realm.getSharedRealm().getTable(tableName));
            this.dynamicClassToSchema.put(tableName, dynamicSchema);
        }
        return dynamicSchema;
    }

    private boolean isProxyClass(Class<? extends RealmModel> modelClass, Class<? extends RealmModel> testee) {
        return modelClass.equals(testee);
    }

    final boolean haveColumnInfo() {
        return this.columnIndices != null;
    }

    final ColumnInfo getColumnInfo(Class<? extends RealmModel> clazz) {
        this.checkIndices();
        return this.columnIndices.getColumnInfo(clazz);
    }

    protected final ColumnInfo getColumnInfo(String className) {
        this.checkIndices();
        return this.columnIndices.getColumnInfo(className);
    }

    final void putToClassNameToSchemaMap(String name, RealmObjectSchema objectSchema) {
        this.dynamicClassToSchema.put(name, objectSchema);
    }

    final RealmObjectSchema removeFromClassNameToSchemaMap(String name) {
        return this.dynamicClassToSchema.remove(name);
    }

    private void checkIndices() {
        if (!this.haveColumnInfo()) {
            throw new IllegalStateException("Attempt to use column index before set.");
        }
    }

    void refresh() {
        if (this.columnIndices != null) {
            this.columnIndices.refresh();
        }
        this.dynamicClassToTable.clear();
        this.classToTable.clear();
        this.classToSchema.clear();
        this.dynamicClassToSchema.clear();
    }
}

