/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.NativeContext;
import io.realm.internal.OsList;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import java.util.Locale;

public class CheckedRow
extends UncheckedRow {
    private UncheckedRow originalRow;

    private CheckedRow(NativeContext context, Table parent, long nativePtr) {
        super(context, parent, nativePtr);
    }

    private CheckedRow(UncheckedRow row) {
        super(row);
        this.originalRow = row;
    }

    public static CheckedRow get(NativeContext context, Table table, long index) {
        long nativeRowPointer = table.nativeGetRowPtr(table.getNativePtr(), index);
        return new CheckedRow(context, table, nativeRowPointer);
    }

    public static CheckedRow getFromRow(UncheckedRow row) {
        return new CheckedRow(row);
    }

    @Override
    public boolean isNullLink(long columnIndex) {
        RealmFieldType columnType = this.getColumnType(columnIndex);
        if (columnType == RealmFieldType.OBJECT || columnType == RealmFieldType.LIST) {
            return super.isNullLink(columnIndex);
        }
        return false;
    }

    @Override
    public boolean isNull(long columnIndex) {
        return super.isNull(columnIndex);
    }

    @Override
    public void setNull(long columnIndex) {
        RealmFieldType columnType = this.getColumnType(columnIndex);
        if (columnType == RealmFieldType.BINARY) {
            super.setBinaryByteArray(columnIndex, null);
        } else {
            super.setNull(columnIndex);
        }
    }

    @Override
    public OsList getModelList(long columnIndex) {
        RealmFieldType fieldType = this.getTable().getColumnType(columnIndex);
        if (fieldType != RealmFieldType.LIST) {
            throw new IllegalArgumentException(String.format(Locale.US, "Field '%s' is not a 'RealmList'.", this.getTable().getColumnName(columnIndex)));
        }
        return super.getModelList(columnIndex);
    }

    @Override
    public OsList getValueList(long columnIndex, RealmFieldType fieldType) {
        RealmFieldType actualFieldType = this.getTable().getColumnType(columnIndex);
        if (fieldType != actualFieldType) {
            throw new IllegalArgumentException(String.format(Locale.US, "The type of field '%1$s' is not 'RealmFieldType.%2$s'.", this.getTable().getColumnName(columnIndex), fieldType.name()));
        }
        return super.getValueList(columnIndex, fieldType);
    }

    @Override
    protected native long nativeGetColumnCount(long var1);

    @Override
    protected native String nativeGetColumnName(long var1, long var3);

    @Override
    protected native long nativeGetColumnIndex(long var1, String var3);

    @Override
    protected native int nativeGetColumnType(long var1, long var3);

    @Override
    protected native long nativeGetLong(long var1, long var3);

    @Override
    protected native boolean nativeGetBoolean(long var1, long var3);

    @Override
    protected native float nativeGetFloat(long var1, long var3);

    @Override
    protected native double nativeGetDouble(long var1, long var3);

    @Override
    protected native long nativeGetTimestamp(long var1, long var3);

    @Override
    protected native String nativeGetString(long var1, long var3);

    @Override
    protected native boolean nativeIsNullLink(long var1, long var3);

    @Override
    protected native byte[] nativeGetByteArray(long var1, long var3);

    @Override
    protected native void nativeSetLong(long var1, long var3, long var5);

    @Override
    protected native void nativeSetBoolean(long var1, long var3, boolean var5);

    @Override
    protected native void nativeSetFloat(long var1, long var3, float var5);

    @Override
    protected native long nativeGetLink(long var1, long var3);

    @Override
    protected native void nativeSetDouble(long var1, long var3, double var5);

    @Override
    protected native void nativeSetTimestamp(long var1, long var3, long var5);

    @Override
    protected native void nativeSetString(long var1, long var3, String var5);

    @Override
    protected native void nativeSetByteArray(long var1, long var3, byte[] var5);

    @Override
    protected native void nativeSetLink(long var1, long var3, long var5);

    @Override
    protected native void nativeNullifyLink(long var1, long var3);
}

