/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.OsObjectSchemaInfo;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.Property;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ColumnInfo {
    private final Map<String, ColumnDetails> indicesMap;
    private final boolean mutable;

    protected ColumnInfo(int mapSize) {
        this(mapSize, true);
    }

    protected ColumnInfo(@Nullable ColumnInfo src, boolean mutable) {
        this(src == null ? 0 : src.indicesMap.size(), mutable);
        if (src != null) {
            this.indicesMap.putAll(src.indicesMap);
        }
    }

    private ColumnInfo(int mapSize, boolean mutable) {
        this.indicesMap = new HashMap<String, ColumnDetails>(mapSize);
        this.mutable = mutable;
    }

    public final boolean isMutable() {
        return this.mutable;
    }

    public long getColumnIndex(String columnName) {
        ColumnDetails details = this.indicesMap.get(columnName);
        return details == null ? -1L : details.columnIndex;
    }

    @Nullable
    public ColumnDetails getColumnDetails(String columnName) {
        return this.indicesMap.get(columnName);
    }

    public void copyFrom(ColumnInfo src) {
        if (!this.mutable) {
            throw new UnsupportedOperationException("Attempt to modify an immutable ColumnInfo");
        }
        if (null == src) {
            throw new NullPointerException("Attempt to copy null ColumnInfo");
        }
        this.indicesMap.clear();
        this.indicesMap.putAll(src.indicesMap);
        this.copy(src, this);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("ColumnInfo[");
        buf.append(this.mutable).append(",");
        if (this.indicesMap != null) {
            boolean commaNeeded = false;
            for (Map.Entry<String, ColumnDetails> entry : this.indicesMap.entrySet()) {
                if (commaNeeded) {
                    buf.append(",");
                }
                buf.append(entry.getKey()).append("->").append(entry.getValue());
                commaNeeded = true;
            }
        }
        return buf.append("]").toString();
    }

    protected abstract ColumnInfo copy(boolean var1);

    protected abstract void copy(ColumnInfo var1, ColumnInfo var2);

    protected final long addColumnDetails(String columnName, OsObjectSchemaInfo objectSchemaInfo) {
        Property property = objectSchemaInfo.getProperty(columnName);
        this.indicesMap.put(columnName, new ColumnDetails(property));
        return property.getColumnIndex();
    }

    protected final void addBacklinkDetails(OsSchemaInfo schemaInfo, String columnName, String sourceTableName, String sourceColumnName) {
        long columnIndex = schemaInfo.getObjectSchemaInfo(sourceTableName).getProperty(sourceColumnName).getColumnIndex();
        this.indicesMap.put(columnName, new ColumnDetails(columnIndex, RealmFieldType.LINKING_OBJECTS, sourceTableName));
    }

    public Map<String, ColumnDetails> getIndicesMap() {
        return this.indicesMap;
    }

    public static final class ColumnDetails {
        public final long columnIndex;
        public final RealmFieldType columnType;
        public final String linkedClassName;

        private ColumnDetails(long columnIndex, RealmFieldType columnType, @Nullable String linkedClassName) {
            this.columnIndex = columnIndex;
            this.columnType = columnType;
            this.linkedClassName = linkedClassName;
        }

        ColumnDetails(Property property) {
            this(property.getColumnIndex(), property.getType(), property.getLinkedObjectName());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("ColumnDetails[");
            buf.append(this.columnIndex);
            buf.append(", ").append((Object)this.columnType);
            buf.append(", ").append(this.linkedClassName);
            return buf.append("]").toString();
        }
    }
}

