/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ObserverPairList<T extends ObserverPair> {
    private List<T> pairs = new CopyOnWriteArrayList<T>();
    private boolean cleared = false;

    public void foreach(Callback<T> callback) {
        for (ObserverPair pair : this.pairs) {
            if (this.cleared) break;
            Object observer = pair.observerRef.get();
            if (observer == null) {
                this.pairs.remove(pair);
                continue;
            }
            if (pair.removed) continue;
            callback.onCalled(pair, observer);
        }
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public void clear() {
        this.cleared = true;
        this.pairs.clear();
    }

    public void add(T pair) {
        if (!this.pairs.contains(pair)) {
            this.pairs.add(pair);
            ((ObserverPair)pair).removed = false;
        }
        if (this.cleared) {
            this.cleared = false;
        }
    }

    public <S, U> void remove(S observer, U listener) {
        for (ObserverPair pair : this.pairs) {
            if (observer != pair.observerRef.get() || !listener.equals(pair.listener)) continue;
            pair.removed = true;
            this.pairs.remove(pair);
            break;
        }
    }

    void removeByObserver(Object observer) {
        for (ObserverPair pair : this.pairs) {
            Object object = pair.observerRef.get();
            if (object != null && object != observer) continue;
            pair.removed = true;
            this.pairs.remove(pair);
        }
    }

    public int size() {
        return this.pairs.size();
    }

    public static interface Callback<T extends ObserverPair> {
        public void onCalled(T var1, Object var2);
    }

    public static abstract class ObserverPair<T, S> {
        final WeakReference<T> observerRef;
        protected final S listener;
        boolean removed = false;

        ObserverPair(T observer, S listener) {
            this.listener = listener;
            this.observerRef = new WeakReference<T>(observer);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ObserverPair) {
                ObserverPair anotherPair = (ObserverPair)obj;
                return this.listener.equals(anotherPair.listener) && this.observerRef.get() == anotherPair.observerRef.get();
            }
            return false;
        }

        public int hashCode() {
            Object observer = this.observerRef.get();
            int result = 17;
            result = 31 * result + (observer != null ? observer.hashCode() : 0);
            result = 31 * result + (this.listener != null ? this.listener.hashCode() : 0);
            return result;
        }
    }
}

