/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.OrderedCollectionChangeSet;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;

public class OsCollectionChangeSet
implements OrderedCollectionChangeSet,
NativeObject {
    public static final int TYPE_DELETION = 0;
    public static final int TYPE_INSERTION = 1;
    public static final int TYPE_MODIFICATION = 2;
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private static long finalizerPtr = OsCollectionChangeSet.nativeGetFinalizerPtr();
    private final long nativePtr;

    public OsCollectionChangeSet(long nativePtr) {
        this.nativePtr = nativePtr;
        NativeContext.dummyContext.addReference(this);
    }

    @Override
    public int[] getDeletions() {
        return OsCollectionChangeSet.nativeGetIndices(this.nativePtr, 0);
    }

    @Override
    public int[] getInsertions() {
        return OsCollectionChangeSet.nativeGetIndices(this.nativePtr, 1);
    }

    @Override
    public int[] getChanges() {
        return OsCollectionChangeSet.nativeGetIndices(this.nativePtr, 2);
    }

    @Override
    public OrderedCollectionChangeSet.Range[] getDeletionRanges() {
        return this.longArrayToRangeArray(OsCollectionChangeSet.nativeGetRanges(this.nativePtr, 0));
    }

    @Override
    public OrderedCollectionChangeSet.Range[] getInsertionRanges() {
        return this.longArrayToRangeArray(OsCollectionChangeSet.nativeGetRanges(this.nativePtr, 1));
    }

    @Override
    public OrderedCollectionChangeSet.Range[] getChangeRanges() {
        return this.longArrayToRangeArray(OsCollectionChangeSet.nativeGetRanges(this.nativePtr, 2));
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return finalizerPtr;
    }

    private OrderedCollectionChangeSet.Range[] longArrayToRangeArray(int[] longArray) {
        if (longArray == null) {
            return new OrderedCollectionChangeSet.Range[0];
        }
        OrderedCollectionChangeSet.Range[] ranges = new OrderedCollectionChangeSet.Range[longArray.length / 2];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = new OrderedCollectionChangeSet.Range(longArray[i * 2], longArray[i * 2 + 1]);
        }
        return ranges;
    }

    private static native long nativeGetFinalizerPtr();

    private static native int[] nativeGetRanges(long var0, int var2);

    private static native int[] nativeGetIndices(long var0, int var2);
}

