/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.RealmChangeListener;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.ObservableCollection;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsCollectionChangeSet;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.UncheckedRow;
import java.util.Date;
import javax.annotation.Nullable;

public class OsList
implements NativeObject,
ObservableCollection {
    private final long nativePtr;
    private final NativeContext context;
    private final Table targetTable;
    private static final long nativeFinalizerPtr = OsList.nativeGetFinalizerPtr();
    private final ObserverPairList<ObservableCollection.CollectionObserverPair> observerPairs = new ObserverPairList();

    public OsList(UncheckedRow row, long columnIndex) {
        OsSharedRealm sharedRealm = row.getTable().getSharedRealm();
        long[] ptrs = OsList.nativeCreate(sharedRealm.getNativePtr(), row.getNativePtr(), columnIndex);
        this.nativePtr = ptrs[0];
        this.context = sharedRealm.context;
        this.context.addReference(this);
        this.targetTable = ptrs[1] != 0L ? new Table(sharedRealm, ptrs[1]) : null;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public UncheckedRow getUncheckedRow(long index) {
        return this.targetTable.getUncheckedRowByPointer(OsList.nativeGetRow(this.nativePtr, index));
    }

    public void addRow(long targetRowIndex) {
        OsList.nativeAddRow(this.nativePtr, targetRowIndex);
    }

    public void insertRow(long pos, long targetRowIndex) {
        OsList.nativeInsertRow(this.nativePtr, pos, targetRowIndex);
    }

    public void setRow(long pos, long targetRowIndex) {
        OsList.nativeSetRow(this.nativePtr, pos, targetRowIndex);
    }

    public void addNull() {
        OsList.nativeAddNull(this.nativePtr);
    }

    public void insertNull(long pos) {
        OsList.nativeInsertNull(this.nativePtr, pos);
    }

    public void setNull(long pos) {
        OsList.nativeSetNull(this.nativePtr, pos);
    }

    public void addLong(long value) {
        OsList.nativeAddLong(this.nativePtr, value);
    }

    public void insertLong(long pos, long value) {
        OsList.nativeInsertLong(this.nativePtr, pos, value);
    }

    public void setLong(long pos, long value) {
        OsList.nativeSetLong(this.nativePtr, pos, value);
    }

    public void addDouble(double value) {
        OsList.nativeAddDouble(this.nativePtr, value);
    }

    public void insertDouble(long pos, double value) {
        OsList.nativeInsertDouble(this.nativePtr, pos, value);
    }

    public void setDouble(long pos, double value) {
        OsList.nativeSetDouble(this.nativePtr, pos, value);
    }

    public void addFloat(float value) {
        OsList.nativeAddFloat(this.nativePtr, value);
    }

    public void insertFloat(long pos, float value) {
        OsList.nativeInsertFloat(this.nativePtr, pos, value);
    }

    public void setFloat(long pos, float value) {
        OsList.nativeSetFloat(this.nativePtr, pos, value);
    }

    public void addBoolean(boolean value) {
        OsList.nativeAddBoolean(this.nativePtr, value);
    }

    public void insertBoolean(long pos, boolean value) {
        OsList.nativeInsertBoolean(this.nativePtr, pos, value);
    }

    public void setBoolean(long pos, boolean value) {
        OsList.nativeSetBoolean(this.nativePtr, pos, value);
    }

    public void addBinary(@Nullable byte[] value) {
        OsList.nativeAddBinary(this.nativePtr, value);
    }

    public void insertBinary(long pos, @Nullable byte[] value) {
        OsList.nativeInsertBinary(this.nativePtr, pos, value);
    }

    public void setBinary(long pos, @Nullable byte[] value) {
        OsList.nativeSetBinary(this.nativePtr, pos, value);
    }

    public void addString(@Nullable String value) {
        OsList.nativeAddString(this.nativePtr, value);
    }

    public void insertString(long pos, @Nullable String value) {
        OsList.nativeInsertString(this.nativePtr, pos, value);
    }

    public void setString(long pos, @Nullable String value) {
        OsList.nativeSetString(this.nativePtr, pos, value);
    }

    public void addDate(@Nullable Date value) {
        if (value == null) {
            OsList.nativeAddNull(this.nativePtr);
        } else {
            OsList.nativeAddDate(this.nativePtr, value.getTime());
        }
    }

    public void insertDate(long pos, @Nullable Date value) {
        if (value == null) {
            OsList.nativeInsertNull(this.nativePtr, pos);
        } else {
            OsList.nativeInsertDate(this.nativePtr, pos, value.getTime());
        }
    }

    public void setDate(long pos, @Nullable Date value) {
        if (value == null) {
            OsList.nativeSetNull(this.nativePtr, pos);
        } else {
            OsList.nativeSetDate(this.nativePtr, pos, value.getTime());
        }
    }

    @Nullable
    public Object getValue(long pos) {
        return OsList.nativeGetValue(this.nativePtr, pos);
    }

    public void move(long sourceIndex, long targetIndex) {
        OsList.nativeMove(this.nativePtr, sourceIndex, targetIndex);
    }

    public void remove(long index) {
        OsList.nativeRemove(this.nativePtr, index);
    }

    public void removeAll() {
        OsList.nativeRemoveAll(this.nativePtr);
    }

    public long size() {
        return OsList.nativeSize(this.nativePtr);
    }

    public boolean isEmpty() {
        return OsList.nativeSize(this.nativePtr) <= 0L;
    }

    public TableQuery getQuery() {
        return new TableQuery(this.context, this.targetTable, OsList.nativeGetQuery(this.nativePtr));
    }

    public boolean isValid() {
        return OsList.nativeIsValid(this.nativePtr);
    }

    public void delete(long index) {
        OsList.nativeDelete(this.nativePtr, index);
    }

    public void deleteAll() {
        OsList.nativeDeleteAll(this.nativePtr);
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public <T> void addListener(T observer, OrderedRealmCollectionChangeListener<T> listener) {
        if (this.observerPairs.isEmpty()) {
            this.nativeStartListening(this.nativePtr);
        }
        ObservableCollection.CollectionObserverPair<T> collectionObserverPair = new ObservableCollection.CollectionObserverPair<T>(observer, listener);
        this.observerPairs.add(collectionObserverPair);
    }

    public <T> void addListener(T observer, RealmChangeListener<T> listener) {
        this.addListener(observer, new ObservableCollection.RealmChangeListenerWrapper<T>(listener));
    }

    public <T> void removeListener(T observer, OrderedRealmCollectionChangeListener<T> listener) {
        this.observerPairs.remove(observer, listener);
        if (this.observerPairs.isEmpty()) {
            this.nativeStopListening(this.nativePtr);
        }
    }

    public <T> void removeListener(T observer, RealmChangeListener<T> listener) {
        this.removeListener(observer, new ObservableCollection.RealmChangeListenerWrapper<T>(listener));
    }

    public void removeAllListeners() {
        this.observerPairs.clear();
        this.nativeStopListening(this.nativePtr);
    }

    @Override
    public void notifyChangeListeners(long nativeChangeSetPtr) {
        if (nativeChangeSetPtr == 0L) {
            return;
        }
        this.observerPairs.foreach(new ObservableCollection.Callback(new OsCollectionChangeSet(nativeChangeSetPtr)));
    }

    private static native long nativeGetFinalizerPtr();

    private static native long[] nativeCreate(long var0, long var2, long var4);

    private static native long nativeGetRow(long var0, long var2);

    private static native void nativeAddRow(long var0, long var2);

    private static native void nativeInsertRow(long var0, long var2, long var4);

    private static native void nativeSetRow(long var0, long var2, long var4);

    private static native void nativeMove(long var0, long var2, long var4);

    private static native void nativeRemove(long var0, long var2);

    private static native void nativeRemoveAll(long var0);

    private static native long nativeSize(long var0);

    private static native long nativeGetQuery(long var0);

    private static native boolean nativeIsValid(long var0);

    private static native void nativeDelete(long var0, long var2);

    private static native void nativeDeleteAll(long var0);

    private static native void nativeAddNull(long var0);

    private static native void nativeInsertNull(long var0, long var2);

    private static native void nativeSetNull(long var0, long var2);

    private static native void nativeAddLong(long var0, long var2);

    private static native void nativeInsertLong(long var0, long var2, long var4);

    private static native void nativeSetLong(long var0, long var2, long var4);

    private static native void nativeAddDouble(long var0, double var2);

    private static native void nativeInsertDouble(long var0, long var2, double var4);

    private static native void nativeSetDouble(long var0, long var2, double var4);

    private static native void nativeAddFloat(long var0, float var2);

    private static native void nativeInsertFloat(long var0, long var2, float var4);

    private static native void nativeSetFloat(long var0, long var2, float var4);

    private static native void nativeAddBoolean(long var0, boolean var2);

    private static native void nativeInsertBoolean(long var0, long var2, boolean var4);

    private static native void nativeSetBoolean(long var0, long var2, boolean var4);

    private static native void nativeAddBinary(long var0, @Nullable byte[] var2);

    private static native void nativeInsertBinary(long var0, long var2, @Nullable byte[] var4);

    private static native void nativeSetBinary(long var0, long var2, @Nullable byte[] var4);

    private static native void nativeAddDate(long var0, long var2);

    private static native void nativeInsertDate(long var0, long var2, long var4);

    private static native void nativeSetDate(long var0, long var2, long var4);

    private static native void nativeAddString(long var0, @Nullable String var2);

    private static native void nativeInsertString(long var0, long var2, @Nullable String var4);

    private static native void nativeSetString(long var0, long var2, @Nullable String var4);

    private static native Object nativeGetValue(long var0, long var2);

    private native void nativeStartListening(long var1);

    private native void nativeStopListening(long var1);
}

