/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.ObjectChangeSet;
import io.realm.RealmFieldType;
import io.realm.RealmModel;
import io.realm.RealmObjectChangeListener;
import io.realm.exceptions.RealmException;
import io.realm.internal.Keep;
import io.realm.internal.NativeObject;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsObjectStore;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import javax.annotation.Nullable;

@Keep
public class OsObject
implements NativeObject {
    private static final String OBJECT_ID_COLUMN_NAME = OsObject.nativeGetObjectIdColumName();
    private final long nativePtr;
    private static final long nativeFinalizerPtr = OsObject.nativeGetFinalizerPtr();
    private ObserverPairList<ObjectObserverPair> observerPairs = new ObserverPairList();

    public OsObject(OsSharedRealm sharedRealm, UncheckedRow row) {
        this.nativePtr = OsObject.nativeCreate(sharedRealm.getNativePtr(), row.getNativePtr());
        sharedRealm.context.addReference(this);
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public <T extends RealmModel> void addListener(T observer, RealmObjectChangeListener<T> listener) {
        if (this.observerPairs.isEmpty()) {
            this.nativeStartListening(this.nativePtr);
        }
        ObjectObserverPair<T> pair = new ObjectObserverPair<T>(observer, listener);
        this.observerPairs.add(pair);
    }

    public <T extends RealmModel> void removeListener(T observer) {
        this.observerPairs.removeByObserver(observer);
        if (this.observerPairs.isEmpty()) {
            this.nativeStopListening(this.nativePtr);
        }
    }

    public <T extends RealmModel> void removeListener(T observer, RealmObjectChangeListener<T> listener) {
        this.observerPairs.remove(observer, listener);
        if (this.observerPairs.isEmpty()) {
            this.nativeStopListening(this.nativePtr);
        }
    }

    public void setObserverPairs(ObserverPairList<ObjectObserverPair> pairs) {
        if (!this.observerPairs.isEmpty()) {
            throw new IllegalStateException("'observerPairs' is not empty. Listeners have been added before.");
        }
        this.observerPairs = pairs;
        if (!pairs.isEmpty()) {
            this.nativeStartListening(this.nativePtr);
        }
    }

    public static UncheckedRow create(Table table) {
        OsSharedRealm sharedRealm = table.getSharedRealm();
        return new UncheckedRow(sharedRealm.context, table, OsObject.nativeCreateNewObject(sharedRealm.getNativePtr(), table.getNativePtr()));
    }

    public static long createRow(Table table) {
        OsSharedRealm sharedRealm = table.getSharedRealm();
        return OsObject.nativeCreateRow(sharedRealm.getNativePtr(), table.getNativePtr());
    }

    private static long getAndVerifyPrimaryKeyColumnIndex(Table table) {
        String pkField = OsObjectStore.getPrimaryKeyForObject(table.getSharedRealm(), table.getClassName());
        if (pkField == null) {
            throw new IllegalStateException(table.getName() + " has no primary key defined.");
        }
        return table.getColumnIndex(pkField);
    }

    public static UncheckedRow createWithPrimaryKey(Table table, @Nullable Object primaryKeyValue) {
        long primaryKeyColumnIndex = OsObject.getAndVerifyPrimaryKeyColumnIndex(table);
        RealmFieldType type = table.getColumnType(primaryKeyColumnIndex);
        OsSharedRealm sharedRealm = table.getSharedRealm();
        if (type == RealmFieldType.STRING) {
            if (primaryKeyValue != null && !(primaryKeyValue instanceof String)) {
                throw new IllegalArgumentException("Primary key value is not a String: " + primaryKeyValue);
            }
            return new UncheckedRow(sharedRealm.context, table, OsObject.nativeCreateNewObjectWithStringPrimaryKey(sharedRealm.getNativePtr(), table.getNativePtr(), primaryKeyColumnIndex, (String)primaryKeyValue));
        }
        if (type == RealmFieldType.INTEGER) {
            long value = primaryKeyValue == null ? 0L : Long.parseLong(primaryKeyValue.toString());
            return new UncheckedRow(sharedRealm.context, table, OsObject.nativeCreateNewObjectWithLongPrimaryKey(sharedRealm.getNativePtr(), table.getNativePtr(), primaryKeyColumnIndex, value, primaryKeyValue == null));
        }
        throw new RealmException("Cannot check for duplicate rows for unsupported primary key type: " + (Object)((Object)type));
    }

    public static long createRowWithPrimaryKey(Table table, long primaryKeyColumnIndex, Object primaryKeyValue) {
        RealmFieldType type = table.getColumnType(primaryKeyColumnIndex);
        OsSharedRealm sharedRealm = table.getSharedRealm();
        if (type == RealmFieldType.STRING) {
            if (primaryKeyValue != null && !(primaryKeyValue instanceof String)) {
                throw new IllegalArgumentException("Primary key value is not a String: " + primaryKeyValue);
            }
            return OsObject.nativeCreateRowWithStringPrimaryKey(sharedRealm.getNativePtr(), table.getNativePtr(), primaryKeyColumnIndex, (String)primaryKeyValue);
        }
        if (type == RealmFieldType.INTEGER) {
            long value = primaryKeyValue == null ? 0L : Long.parseLong(primaryKeyValue.toString());
            return OsObject.nativeCreateRowWithLongPrimaryKey(sharedRealm.getNativePtr(), table.getNativePtr(), primaryKeyColumnIndex, value, primaryKeyValue == null);
        }
        throw new RealmException("Cannot check for duplicate rows for unsupported primary key type: " + (Object)((Object)type));
    }

    public static boolean isObjectIdColumn(String columnName) {
        return OBJECT_ID_COLUMN_NAME.equals(columnName);
    }

    private void notifyChangeListeners(String[] changedFields) {
        this.observerPairs.foreach(new Callback(changedFields));
    }

    private static native long nativeGetFinalizerPtr();

    private static native long nativeCreate(long var0, long var2);

    private native void nativeStartListening(long var1);

    private native void nativeStopListening(long var1);

    private static native long nativeCreateNewObject(long var0, long var2);

    private static native long nativeCreateRow(long var0, long var2);

    private static native long nativeCreateNewObjectWithLongPrimaryKey(long var0, long var2, long var4, long var6, boolean var8);

    private static native long nativeCreateRowWithLongPrimaryKey(long var0, long var2, long var4, long var6, boolean var8);

    private static native long nativeCreateNewObjectWithStringPrimaryKey(long var0, long var2, long var4, @Nullable String var6);

    private static native long nativeCreateRowWithStringPrimaryKey(long var0, long var2, long var4, String var6);

    private static native String nativeGetObjectIdColumName();

    private static class Callback
    implements ObserverPairList.Callback<ObjectObserverPair> {
        private final String[] changedFields;

        Callback(String[] changedFields) {
            this.changedFields = changedFields;
        }

        private ObjectChangeSet createChangeSet() {
            boolean isDeleted = this.changedFields == null;
            return new OsObjectChangeSet(isDeleted ? new String[]{} : this.changedFields, isDeleted);
        }

        @Override
        public void onCalled(ObjectObserverPair pair, Object observer) {
            pair.onChange((RealmModel)observer, this.createChangeSet());
        }
    }

    public static class ObjectObserverPair<T extends RealmModel>
    extends ObserverPairList.ObserverPair<T, RealmObjectChangeListener<T>> {
        public ObjectObserverPair(T observer, RealmObjectChangeListener<T> listener) {
            super(observer, listener);
        }

        public void onChange(T observer, @Nullable ObjectChangeSet changeSet) {
            ((RealmObjectChangeListener)this.listener).onChange(observer, changeSet);
        }
    }

    private static class OsObjectChangeSet
    implements ObjectChangeSet {
        final String[] changedFields;
        final boolean deleted;

        OsObjectChangeSet(String[] changedFields, boolean deleted) {
            this.changedFields = changedFields;
            this.deleted = deleted;
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }

        @Override
        public String[] getChangedFields() {
            return this.changedFields;
        }

        @Override
        public boolean isFieldChanged(String fieldName) {
            for (String name : this.changedFields) {
                if (!name.equals(fieldName)) continue;
                return true;
            }
            return false;
        }
    }
}

