/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.CompactOnLaunchCallback;
import io.realm.RealmConfiguration;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.OsSharedRealm;
import io.realm.log.RealmLog;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

public class OsRealmConfig
implements NativeObject {
    private static final byte SCHEMA_MODE_VALUE_AUTOMATIC = 0;
    private static final byte SCHEMA_MODE_VALUE_IMMUTABLE = 1;
    private static final byte SCHEMA_MODE_VALUE_READONLY = 2;
    private static final byte SCHEMA_MODE_VALUE_RESET_FILE = 3;
    private static final byte SCHEMA_MODE_VALUE_ADDITIVE = 4;
    private static final byte SCHEMA_MODE_VALUE_MANUAL = 5;
    private static final byte SYNCSESSION_STOP_POLICY_VALUE_IMMEDIATELY = 0;
    private static final byte SYNCSESSION_STOP_POLICY_VALUE_LIVE_INDEFINETELY = 1;
    private static final byte SYNCSESSION_STOP_POLICY_VALUE_AFTER_CHANGES_UPLOADED = 2;
    private static final long nativeFinalizerPtr = OsRealmConfig.nativeGetFinalizerPtr();
    private final RealmConfiguration realmConfiguration;
    private final URI resolvedRealmURI;
    private final long nativePtr;
    private final NativeContext context = new NativeContext();
    private final CompactOnLaunchCallback compactOnLaunchCallback;
    private final OsSharedRealm.MigrationCallback migrationCallback;
    private final OsSharedRealm.InitializationCallback initializationCallback;

    private OsRealmConfig(RealmConfiguration config, boolean autoUpdateNotification, @Nullable OsSchemaInfo schemaInfo, @Nullable OsSharedRealm.MigrationCallback migrationCallback, @Nullable OsSharedRealm.InitializationCallback initializationCallback) {
        this.realmConfiguration = config;
        this.nativePtr = OsRealmConfig.nativeCreate(config.getPath(), false, true);
        NativeContext.dummyContext.addReference(this);
        Object[] syncConfigurationOptions = ObjectServerFacade.getSyncFacadeIfPossible().getUserAndServerUrl(this.realmConfiguration);
        String syncUserIdentifier = (String)syncConfigurationOptions[0];
        String syncRealmUrl = (String)syncConfigurationOptions[1];
        String syncRealmAuthUrl = (String)syncConfigurationOptions[2];
        String syncRefreshToken = (String)syncConfigurationOptions[3];
        boolean syncClientValidateSsl = Boolean.TRUE.equals(syncConfigurationOptions[4]);
        String syncSslTrustCertificatePath = (String)syncConfigurationOptions[5];
        Byte sessionStopPolicy = (Byte)syncConfigurationOptions[6];
        boolean isPartial = Boolean.TRUE.equals(syncConfigurationOptions[7]);
        byte[] key = config.getEncryptionKey();
        if (key != null) {
            OsRealmConfig.nativeSetEncryptionKey(this.nativePtr, key);
        }
        OsRealmConfig.nativeSetInMemory(this.nativePtr, config.getDurability() == Durability.MEM_ONLY);
        OsRealmConfig.nativeEnableChangeNotification(this.nativePtr, autoUpdateNotification);
        SchemaMode schemaMode = SchemaMode.SCHEMA_MODE_MANUAL;
        if (config.isRecoveryConfiguration()) {
            schemaMode = SchemaMode.SCHEMA_MODE_IMMUTABLE;
        } else if (config.isReadOnly()) {
            schemaMode = SchemaMode.SCHEMA_MODE_READONLY;
        } else if (syncRealmUrl != null) {
            schemaMode = SchemaMode.SCHEMA_MODE_ADDITIVE;
        } else if (config.shouldDeleteRealmIfMigrationNeeded()) {
            schemaMode = SchemaMode.SCHEMA_MODE_RESET_FILE;
        }
        long schemaVersion = config.getSchemaVersion();
        long nativeSchemaPtr = schemaInfo == null ? 0L : schemaInfo.getNativePtr();
        this.migrationCallback = migrationCallback;
        this.nativeSetSchemaConfig(this.nativePtr, schemaMode.getNativeValue(), schemaVersion, nativeSchemaPtr, migrationCallback);
        this.compactOnLaunchCallback = config.getCompactOnLaunchCallback();
        if (this.compactOnLaunchCallback != null) {
            OsRealmConfig.nativeSetCompactOnLaunchCallback(this.nativePtr, this.compactOnLaunchCallback);
        }
        this.initializationCallback = initializationCallback;
        if (initializationCallback != null) {
            this.nativeSetInitializationCallback(this.nativePtr, initializationCallback);
        }
        URI resolvedRealmURI = null;
        if (syncRealmUrl != null) {
            String resolvedSyncRealmUrl = OsRealmConfig.nativeCreateAndSetSyncConfig(this.nativePtr, syncRealmUrl, syncRealmAuthUrl, syncUserIdentifier, syncRefreshToken, isPartial, sessionStopPolicy);
            try {
                resolvedRealmURI = new URI(resolvedSyncRealmUrl);
            }
            catch (URISyntaxException e) {
                RealmLog.error(e, "Cannot create a URI from the Realm URL address", new Object[0]);
            }
            OsRealmConfig.nativeSetSyncConfigSslSettings(this.nativePtr, syncClientValidateSsl, syncSslTrustCertificatePath);
        }
        this.resolvedRealmURI = resolvedRealmURI;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public RealmConfiguration getRealmConfiguration() {
        return this.realmConfiguration;
    }

    public URI getResolvedRealmURI() {
        return this.resolvedRealmURI;
    }

    NativeContext getContext() {
        return this.context;
    }

    private static native long nativeCreate(String var0, boolean var1, boolean var2);

    private static native void nativeSetEncryptionKey(long var0, byte[] var2);

    private static native void nativeSetInMemory(long var0, boolean var2);

    private native void nativeSetSchemaConfig(long var1, byte var3, long var4, long var6, @Nullable OsSharedRealm.MigrationCallback var8);

    private static native void nativeSetCompactOnLaunchCallback(long var0, CompactOnLaunchCallback var2);

    private native void nativeSetInitializationCallback(long var1, OsSharedRealm.InitializationCallback var3);

    private static native void nativeEnableChangeNotification(long var0, boolean var2);

    private static native String nativeCreateAndSetSyncConfig(long var0, String var2, String var3, String var4, String var5, boolean var6, byte var7);

    private static native void nativeSetSyncConfigSslSettings(long var0, boolean var2, String var3);

    private static native long nativeGetFinalizerPtr();

    public static class Builder {
        private RealmConfiguration configuration;
        private OsSchemaInfo schemaInfo = null;
        private OsSharedRealm.MigrationCallback migrationCallback = null;
        private OsSharedRealm.InitializationCallback initializationCallback = null;
        private boolean autoUpdateNotification = false;

        public Builder(RealmConfiguration configuration) {
            this.configuration = configuration;
        }

        public Builder schemaInfo(@Nullable OsSchemaInfo schemaInfo) {
            this.schemaInfo = schemaInfo;
            return this;
        }

        public Builder migrationCallback(@Nullable OsSharedRealm.MigrationCallback migrationCallback) {
            this.migrationCallback = migrationCallback;
            return this;
        }

        public Builder initializationCallback(@Nullable OsSharedRealm.InitializationCallback initializationCallback) {
            this.initializationCallback = initializationCallback;
            return this;
        }

        public Builder autoUpdateNotification(boolean autoUpdateNotification) {
            this.autoUpdateNotification = autoUpdateNotification;
            return this;
        }

        OsRealmConfig build() {
            return new OsRealmConfig(this.configuration, this.autoUpdateNotification, this.schemaInfo, this.migrationCallback, this.initializationCallback);
        }
    }

    public static enum SyncSessionStopPolicy {
        IMMEDIATELY(0),
        LIVE_INDEFINITELY(1),
        AFTER_CHANGES_UPLOADED(2);

        final byte value;

        private SyncSessionStopPolicy(byte value) {
            this.value = value;
        }

        public byte getNativeValue() {
            return this.value;
        }
    }

    public static enum SchemaMode {
        SCHEMA_MODE_AUTOMATIC(0),
        SCHEMA_MODE_IMMUTABLE(1),
        SCHEMA_MODE_READONLY(2),
        SCHEMA_MODE_RESET_FILE(3),
        SCHEMA_MODE_ADDITIVE(4),
        SCHEMA_MODE_MANUAL(5);

        final byte value;

        private SchemaMode(byte value) {
            this.value = value;
        }

        public byte getNativeValue() {
            return this.value;
        }
    }

    public static enum Durability {
        FULL(0),
        MEM_ONLY(1);

        final int value;

        private Durability(int value) {
            this.value = value;
        }
    }
}

