/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.RealmChangeListener;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.ObservableCollection;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsCollectionChangeSet;
import io.realm.internal.OsList;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.SortDescriptor;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.UncheckedRow;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class OsResults
implements NativeObject,
ObservableCollection {
    private static final String CLOSED_REALM_MESSAGE = "This Realm instance has already been closed, making it unusable.";
    private final long nativePtr;
    private static final long nativeFinalizerPtr = OsResults.nativeGetFinalizerPtr();
    private final OsSharedRealm sharedRealm;
    private final NativeContext context;
    private final Table table;
    private boolean loaded;
    private boolean isSnapshot = false;
    private final ObserverPairList<ObservableCollection.CollectionObserverPair> observerPairs = new ObserverPairList();
    public static final byte AGGREGATE_FUNCTION_MINIMUM = 1;
    public static final byte AGGREGATE_FUNCTION_MAXIMUM = 2;
    public static final byte AGGREGATE_FUNCTION_AVERAGE = 3;
    public static final byte AGGREGATE_FUNCTION_SUM = 4;
    public static final byte MODE_EMPTY = 0;
    public static final byte MODE_TABLE = 1;
    public static final byte MODE_QUERY = 2;
    public static final byte MODE_LINKVIEW = 3;
    public static final byte MODE_TABLEVIEW = 4;

    public static OsResults createBacklinksCollection(OsSharedRealm realm, UncheckedRow row, Table srcTable, String srcFieldName) {
        long backlinksPtr = OsResults.nativeCreateResultsFromBacklinks(realm.getNativePtr(), row.getNativePtr(), srcTable.getNativePtr(), srcTable.getColumnIndex(srcFieldName));
        return new OsResults(realm, srcTable, backlinksPtr, true);
    }

    public OsResults(OsSharedRealm sharedRealm, TableQuery query, @Nullable SortDescriptor sortDescriptor, @Nullable SortDescriptor distinctDescriptor) {
        query.validateQuery();
        this.nativePtr = OsResults.nativeCreateResults(sharedRealm.getNativePtr(), query.getNativePtr(), sortDescriptor, distinctDescriptor);
        this.sharedRealm = sharedRealm;
        this.context = sharedRealm.context;
        this.table = query.getTable();
        this.context.addReference(this);
        this.loaded = false;
    }

    public OsResults(OsSharedRealm sharedRealm, TableQuery query, @Nullable SortDescriptor sortDescriptor) {
        this(sharedRealm, query, sortDescriptor, null);
    }

    public OsResults(OsSharedRealm sharedRealm, TableQuery query) {
        this(sharedRealm, query, null, null);
    }

    public OsResults(OsSharedRealm sharedRealm, OsList osList, @Nullable SortDescriptor sortDescriptor) {
        this.nativePtr = OsResults.nativeCreateResultsFromList(sharedRealm.getNativePtr(), osList.getNativePtr(), sortDescriptor);
        this.sharedRealm = sharedRealm;
        this.context = sharedRealm.context;
        this.table = osList.getTargetTable();
        this.context.addReference(this);
        this.loaded = true;
    }

    private OsResults(OsSharedRealm sharedRealm, Table table, long nativePtr) {
        this(sharedRealm, table, nativePtr, false);
    }

    OsResults(OsSharedRealm sharedRealm, Table table, long nativePtr, boolean loaded) {
        this.sharedRealm = sharedRealm;
        this.context = sharedRealm.context;
        this.table = table;
        this.nativePtr = nativePtr;
        this.context.addReference(this);
        this.loaded = loaded;
    }

    public OsResults createSnapshot() {
        if (this.isSnapshot) {
            return this;
        }
        OsResults osResults = new OsResults(this.sharedRealm, this.table, OsResults.nativeCreateSnapshot(this.nativePtr));
        osResults.isSnapshot = true;
        return osResults;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public UncheckedRow getUncheckedRow(int index) {
        return this.table.getUncheckedRowByPointer(OsResults.nativeGetRow(this.nativePtr, index));
    }

    public UncheckedRow firstUncheckedRow() {
        long rowPtr = OsResults.nativeFirstRow(this.nativePtr);
        if (rowPtr != 0L) {
            return this.table.getUncheckedRowByPointer(rowPtr);
        }
        return null;
    }

    public UncheckedRow lastUncheckedRow() {
        long rowPtr = OsResults.nativeLastRow(this.nativePtr);
        if (rowPtr != 0L) {
            return this.table.getUncheckedRowByPointer(rowPtr);
        }
        return null;
    }

    public Table getTable() {
        return this.table;
    }

    public TableQuery where() {
        long nativeQueryPtr = OsResults.nativeWhere(this.nativePtr);
        return new TableQuery(this.context, this.table, nativeQueryPtr);
    }

    public Number aggregateNumber(Aggregate aggregateMethod, long columnIndex) {
        return (Number)OsResults.nativeAggregate(this.nativePtr, columnIndex, aggregateMethod.getValue());
    }

    public Date aggregateDate(Aggregate aggregateMethod, long columnIndex) {
        return (Date)OsResults.nativeAggregate(this.nativePtr, columnIndex, aggregateMethod.getValue());
    }

    public long size() {
        return OsResults.nativeSize(this.nativePtr);
    }

    public void clear() {
        OsResults.nativeClear(this.nativePtr);
    }

    public OsResults sort(SortDescriptor sortDescriptor) {
        return new OsResults(this.sharedRealm, this.table, OsResults.nativeSort(this.nativePtr, sortDescriptor));
    }

    public OsResults distinct(SortDescriptor distinctDescriptor) {
        return new OsResults(this.sharedRealm, this.table, OsResults.nativeDistinct(this.nativePtr, distinctDescriptor));
    }

    public boolean contains(UncheckedRow row) {
        return OsResults.nativeContains(this.nativePtr, row.getNativePtr());
    }

    public int indexOf(UncheckedRow row) {
        long index = OsResults.nativeIndexOf(this.nativePtr, row.getNativePtr());
        return index > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)index;
    }

    public void delete(long index) {
        OsResults.nativeDelete(this.nativePtr, index);
    }

    public boolean deleteFirst() {
        return OsResults.nativeDeleteFirst(this.nativePtr);
    }

    public boolean deleteLast() {
        return OsResults.nativeDeleteLast(this.nativePtr);
    }

    public <T> void addListener(T observer, OrderedRealmCollectionChangeListener<T> listener) {
        if (this.observerPairs.isEmpty()) {
            this.nativeStartListening(this.nativePtr);
        }
        ObservableCollection.CollectionObserverPair<T> collectionObserverPair = new ObservableCollection.CollectionObserverPair<T>(observer, listener);
        this.observerPairs.add(collectionObserverPair);
    }

    public <T> void addListener(T observer, RealmChangeListener<T> listener) {
        this.addListener(observer, new ObservableCollection.RealmChangeListenerWrapper<T>(listener));
    }

    public <T> void removeListener(T observer, OrderedRealmCollectionChangeListener<T> listener) {
        this.observerPairs.remove(observer, listener);
        if (this.observerPairs.isEmpty()) {
            this.nativeStopListening(this.nativePtr);
        }
    }

    public <T> void removeListener(T observer, RealmChangeListener<T> listener) {
        this.removeListener(observer, new ObservableCollection.RealmChangeListenerWrapper<T>(listener));
    }

    public void removeAllListeners() {
        this.observerPairs.clear();
        this.nativeStopListening(this.nativePtr);
    }

    public boolean isValid() {
        return OsResults.nativeIsValid(this.nativePtr);
    }

    @Override
    public void notifyChangeListeners(long nativeChangeSetPtr) {
        if (nativeChangeSetPtr == 0L && this.isLoaded()) {
            return;
        }
        boolean wasLoaded = this.loaded;
        this.loaded = true;
        this.observerPairs.foreach(new ObservableCollection.Callback(nativeChangeSetPtr == 0L || !wasLoaded ? null : new OsCollectionChangeSet(nativeChangeSetPtr)));
    }

    public Mode getMode() {
        return Mode.getByValue(OsResults.nativeGetMode(this.nativePtr));
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        this.notifyChangeListeners(0L);
    }

    private static native long nativeGetFinalizerPtr();

    private static native long nativeCreateResults(long var0, long var2, @Nullable SortDescriptor var4, @Nullable SortDescriptor var5);

    private static native long nativeCreateResultsFromList(long var0, long var2, @Nullable SortDescriptor var4);

    private static native long nativeCreateSnapshot(long var0);

    private static native long nativeGetRow(long var0, int var2);

    private static native long nativeFirstRow(long var0);

    private static native long nativeLastRow(long var0);

    private static native boolean nativeContains(long var0, long var2);

    private static native void nativeClear(long var0);

    private static native long nativeSize(long var0);

    private static native Object nativeAggregate(long var0, long var2, byte var4);

    private static native long nativeSort(long var0, SortDescriptor var2);

    private static native long nativeDistinct(long var0, SortDescriptor var2);

    private static native boolean nativeDeleteFirst(long var0);

    private static native boolean nativeDeleteLast(long var0);

    private static native void nativeDelete(long var0, long var2);

    private native void nativeStartListening(long var1);

    private native void nativeStopListening(long var1);

    private static native long nativeWhere(long var0);

    private static native long nativeIndexOf(long var0, long var2);

    private static native boolean nativeIsValid(long var0);

    private static native byte nativeGetMode(long var0);

    private static native long nativeCreateResultsFromBacklinks(long var0, long var2, long var4, long var6);

    public static enum Mode {
        EMPTY,
        TABLE,
        QUERY,
        LINKVIEW,
        TABLEVIEW;


        static Mode getByValue(byte value) {
            switch (value) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return TABLE;
                }
                case 2: {
                    return QUERY;
                }
                case 3: {
                    return LINKVIEW;
                }
                case 4: {
                    return TABLEVIEW;
                }
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum Aggregate {
        MINIMUM(1),
        MAXIMUM(2),
        AVERAGE(3),
        SUM(4);

        private final byte value;

        private Aggregate(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static abstract class ListIterator<T>
    extends Iterator<T>
    implements java.util.ListIterator<T> {
        public ListIterator(OsResults osResults, int start) {
            super(osResults);
            if (start < 0 || (long)start > this.iteratorOsResults.size()) {
                throw new IndexOutOfBoundsException("Starting location must be a valid index: [0, " + (this.iteratorOsResults.size() - 1L) + "]. Yours was " + start);
            }
            this.pos = start - 1;
        }

        @Override
        @Deprecated
        public void add(@Nullable T object) {
            throw new UnsupportedOperationException("Adding an element is not supported. Use Realm.createObject() instead.");
        }

        @Override
        public boolean hasPrevious() {
            this.checkValid();
            return this.pos >= 0;
        }

        @Override
        public int nextIndex() {
            this.checkValid();
            return this.pos + 1;
        }

        @Override
        @Nullable
        public T previous() {
            this.checkValid();
            try {
                Object obj = this.get(this.pos);
                --this.pos;
                return obj;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("Cannot access index less than zero. This was " + this.pos + ". Remember to check hasPrevious() before using previous().");
            }
        }

        @Override
        public int previousIndex() {
            this.checkValid();
            return this.pos;
        }

        @Override
        @Deprecated
        public void set(@Nullable T object) {
            throw new UnsupportedOperationException("Replacing an element is not supported.");
        }
    }

    public static abstract class Iterator<T>
    implements java.util.Iterator<T> {
        OsResults iteratorOsResults;
        protected int pos = -1;

        public Iterator(OsResults osResults) {
            if (osResults.sharedRealm.isClosed()) {
                throw new IllegalStateException(OsResults.CLOSED_REALM_MESSAGE);
            }
            this.iteratorOsResults = osResults;
            if (osResults.isSnapshot) {
                return;
            }
            if (osResults.sharedRealm.isInTransaction()) {
                this.detach();
            } else {
                this.iteratorOsResults.sharedRealm.addIterator(this);
            }
        }

        @Override
        public boolean hasNext() {
            this.checkValid();
            return (long)(this.pos + 1) < this.iteratorOsResults.size();
        }

        @Override
        @Nullable
        public T next() {
            this.checkValid();
            ++this.pos;
            if ((long)this.pos >= this.iteratorOsResults.size()) {
                throw new NoSuchElementException("Cannot access index " + this.pos + " when size is " + this.iteratorOsResults.size() + ". Remember to check hasNext() before using next().");
            }
            return this.get(this.pos);
        }

        @Override
        @Deprecated
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported by RealmResults iterators.");
        }

        void detach() {
            this.iteratorOsResults = this.iteratorOsResults.createSnapshot();
        }

        void invalidate() {
            this.iteratorOsResults = null;
        }

        void checkValid() {
            if (this.iteratorOsResults == null) {
                throw new ConcurrentModificationException("No outside changes to a Realm is allowed while iterating a living Realm collection.");
            }
        }

        @Nullable
        T get(int pos) {
            return this.convertRowToObject(this.iteratorOsResults.getUncheckedRow(pos));
        }

        protected abstract T convertRowToObject(UncheckedRow var1);
    }
}

