/*
 * Decompiled with CFR 0.152.
 */
package io.realm.log;

import android.util.Log;
import io.realm.log.RealmLogger;
import java.util.Locale;
import javax.annotation.Nullable;

public final class RealmLog {
    private static String REALM_JAVA_TAG = "REALM_JAVA";

    public static void add(RealmLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("A non-null logger has to be provided");
        }
        RealmLog.nativeAddLogger(logger);
    }

    public static void setLevel(int level) {
        if (level < 1 || level > 8) {
            throw new IllegalArgumentException("Invalid log level: " + level);
        }
        RealmLog.nativeSetLogLevel(level);
    }

    public static int getLevel() {
        return RealmLog.nativeGetLogLevel();
    }

    public static boolean remove(RealmLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("A non-null logger has to be provided");
        }
        RealmLog.nativeRemoveLogger(logger);
        return true;
    }

    public static void clear() {
        RealmLog.nativeClearLoggers();
    }

    public static void registerDefaultLogger() {
        RealmLog.nativeRegisterDefaultLogger();
    }

    public static void trace(Throwable throwable) {
        RealmLog.trace(throwable, null, new Object[0]);
    }

    public static void trace(String message, Object ... args) {
        RealmLog.trace(null, message, args);
    }

    public static void trace(@Nullable Throwable throwable, @Nullable String message, Object ... args) {
        RealmLog.log(2, throwable, message, args);
    }

    public static void debug(@Nullable Throwable throwable) {
        RealmLog.debug(throwable, null, new Object[0]);
    }

    public static void debug(String message, Object ... args) {
        RealmLog.debug(null, message, args);
    }

    public static void debug(@Nullable Throwable throwable, @Nullable String message, Object ... args) {
        RealmLog.log(3, throwable, message, args);
    }

    public static void info(Throwable throwable) {
        RealmLog.info(throwable, null, new Object[0]);
    }

    public static void info(String message, Object ... args) {
        RealmLog.info(null, message, args);
    }

    public static void info(@Nullable Throwable throwable, @Nullable String message, Object ... args) {
        RealmLog.log(4, throwable, message, args);
    }

    public static void warn(Throwable throwable) {
        RealmLog.warn(throwable, null, new Object[0]);
    }

    public static void warn(String message, Object ... args) {
        RealmLog.warn(null, message, args);
    }

    public static void warn(@Nullable Throwable throwable, @Nullable String message, Object ... args) {
        RealmLog.log(5, throwable, message, args);
    }

    public static void error(Throwable throwable) {
        RealmLog.error(throwable, null, new Object[0]);
    }

    public static void error(String message, Object ... args) {
        RealmLog.error(null, message, args);
    }

    public static void error(@Nullable Throwable throwable, @Nullable String message, Object ... args) {
        RealmLog.log(6, throwable, message, args);
    }

    public static void fatal(Throwable throwable) {
        RealmLog.fatal(throwable, null, new Object[0]);
    }

    public static void fatal(String message, Object ... args) {
        RealmLog.fatal(null, message, args);
    }

    public static void fatal(@Nullable Throwable throwable, @Nullable String message, Object ... args) {
        RealmLog.log(7, throwable, message, args);
    }

    private static void log(int level, @Nullable Throwable throwable, @Nullable String message, Object ... args) {
        if (level < RealmLog.getLevel()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (message != null && args != null && args.length > 0) {
            message = String.format(Locale.US, message, args);
        }
        if (throwable != null) {
            stringBuilder.append(Log.getStackTraceString((Throwable)throwable));
        }
        if (message != null) {
            if (throwable != null) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(message);
        }
        RealmLog.nativeLog(level, REALM_JAVA_TAG, throwable, stringBuilder.toString());
    }

    private static native void nativeAddLogger(RealmLogger var0);

    private static native void nativeRemoveLogger(RealmLogger var0);

    private static native void nativeClearLoggers();

    private static native void nativeRegisterDefaultLogger();

    private static native void nativeLog(int var0, String var1, @Nullable Throwable var2, @Nullable String var3);

    private static native void nativeSetLogLevel(int var0);

    private static native int nativeGetLogLevel();

    static native long nativeCreateCoreLoggerBridge(String var0);

    static native void nativeCloseCoreLoggerBridge(long var0);

    static native void nativeLogToCoreLoggerBridge(long var0, int var2, String var3);
}

